/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.pro.licensechecker.Product;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import tools.jackson.databind.node.ObjectNode;

public class CvdlProducts {
    private static final String CVDL_PACKAGE_KEY = "cvdlName";

    public static Product getProductIfCvdl(File nodeModules, String npmModule) {
        File packageJsonFile = new File(new File(nodeModules, npmModule), "package.json");
        if (!packageJsonFile.exists()) {
            return null;
        }
        try {
            ObjectNode packageJson = JacksonUtils.readTree(FileUtils.readFileToString((File)packageJsonFile, (Charset)StandardCharsets.UTF_8));
            if (packageJson.has(CVDL_PACKAGE_KEY)) {
                return new Product(packageJson.get(CVDL_PACKAGE_KEY).asString(), packageJson.get("version").asString());
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read package.json file " + String.valueOf(packageJsonFile), e);
        }
    }
}

