/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import java.io.IOException;

class UploadSizeLimitExceededException
extends IOException {
    private final long actualSize;
    private final long permittedSize;

    public UploadSizeLimitExceededException(long actualSize, long permittedSize) {
        super(String.format("Upload request size (%d bytes) exceeds the permitted maximum (%d bytes)", actualSize, permittedSize));
        this.actualSize = actualSize;
        this.permittedSize = permittedSize;
    }

    public long getActualSize() {
        return this.actualSize;
    }

    public long getPermittedSize() {
        return this.permittedSize;
    }
}

