/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.EncodeUtil;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class DownloadEvent {
    private VaadinRequest request;
    private VaadinResponse response;
    private VaadinSession session;
    private Element owningElement;
    private String fileName;
    private String contentType;
    private long contentLength = -1L;
    private Exception exception;

    public DownloadEvent(VaadinRequest request, VaadinResponse response, VaadinSession session, Element owningElement) {
        this.request = request;
        this.response = response;
        this.session = session;
        this.owningElement = owningElement;
    }

    public OutputStream getOutputStream() {
        try {
            return this.response.getOutputStream();
        }
        catch (IOException e) {
            LoggerFactory.getLogger(DownloadEvent.class).error("Error getting output stream", (Throwable)e);
            throw new UncheckedIOException("Error getting output stream", e);
        }
    }

    public PrintWriter getWriter() {
        try {
            return this.response.getWriter();
        }
        catch (IOException e) {
            LoggerFactory.getLogger(DownloadEvent.class).error("Error getting print writer");
            throw new UncheckedIOException("Error getting writer", e);
        }
    }

    public VaadinRequest getRequest() {
        return this.request;
    }

    public VaadinResponse getResponse() {
        return this.response;
    }

    public VaadinSession getSession() {
        return this.session;
    }

    public void setFileName(String fileName) {
        if (fileName == null) {
            return;
        }
        if (fileName.isEmpty()) {
            this.response.setHeader("Content-Disposition", "attachment");
        } else {
            StringBuilder value = new StringBuilder();
            value.append("attachment; ");
            if (EncodeUtil.isPureUSASCII(fileName)) {
                value.append("filename=\"").append(fileName).append("\"");
            } else {
                value.append("filename=\"").append(EncodeUtil.rfc2047Encode(fileName)).append("\"; filename*=UTF-8''").append(EncodeUtil.rfc5987Encode(fileName));
            }
            this.response.setHeader("Content-Disposition", value.toString());
        }
        this.fileName = fileName;
    }

    public void setContentType(String contentType) {
        this.response.setContentType(contentType);
        this.contentType = contentType;
    }

    public void setContentLength(long contentLength) {
        if (contentLength != -1L) {
            this.response.setContentLengthLong(contentLength);
        }
        this.contentLength = contentLength;
    }

    public Component getOwningComponent() {
        return this.owningElement.getComponent().orElse(null);
    }

    public Element getOwningElement() {
        return this.owningElement;
    }

    public UI getUI() {
        Optional<Component> component = this.owningElement.getComponent();
        return component.map(value -> value.getUI().orElseGet(UI::getCurrent)).orElseGet(UI::getCurrent);
    }

    String getFileName() {
        return this.fileName;
    }

    String getContentType() {
        return this.contentType;
    }

    long getContentLength() {
        return this.contentLength;
    }

    Exception getException() {
        return this.exception;
    }

    void setException(Exception exception) {
        this.exception = exception;
    }
}

