/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.streams.AbstractDownloadHandler;
import com.vaadin.flow.server.streams.DownloadEvent;
import com.vaadin.flow.server.streams.TransferUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.LoggerFactory;

public class ClassDownloadHandler
extends AbstractDownloadHandler<ClassDownloadHandler> {
    private final Class<?> clazz;
    private final String resourceName;
    private String fileName;

    public ClassDownloadHandler(Class<?> clazz, String resourceName) {
        this(clazz, resourceName, null);
    }

    public ClassDownloadHandler(Class<?> clazz, String resourceName, String fileName) {
        this.clazz = clazz;
        this.resourceName = resourceName;
        this.fileName = fileName;
        if (clazz.getResource(resourceName) == null) {
            LoggerFactory.getLogger(ClassDownloadHandler.class).warn("No resource found for '{}'. The resource will receive a 404 not found response.", (Object)resourceName);
        }
    }

    @Override
    public void handleDownloadRequest(DownloadEvent downloadEvent) throws IOException {
        if (this.clazz.getResource(this.resourceName) == null) {
            LoggerFactory.getLogger(ClassDownloadHandler.class).warn("No resource found for '{}'", (Object)this.resourceName);
            downloadEvent.getResponse().setStatus(HttpStatusCode.NOT_FOUND.getCode());
            return;
        }
        try (OutputStream outputStream = downloadEvent.getOutputStream();
             InputStream inputStream = this.clazz.getResourceAsStream(this.resourceName);){
            String resourceName = this.getUrlPostfix();
            downloadEvent.setContentType(this.getContentType(resourceName, downloadEvent.getResponse()));
            if (!this.isInline()) {
                downloadEvent.setFileName(resourceName);
            } else {
                downloadEvent.getResponse().setHeader("Content-Disposition", "inline");
            }
            TransferUtil.transfer(inputStream, outputStream, this.getTransferContext(downloadEvent), this.getListeners());
        }
        catch (IOException ioe) {
            downloadEvent.getResponse().setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
            downloadEvent.setException(ioe);
            this.notifyError(downloadEvent, ioe);
            throw ioe;
        }
    }

    @Override
    public String getUrlPostfix() {
        if (this.fileName != null) {
            return this.fileName;
        }
        if (this.resourceName.contains("/")) {
            return this.resourceName.substring(this.resourceName.lastIndexOf(47) + 1);
        }
        return this.resourceName;
    }
}

