/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.DevBundleUtils;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskCopyNpmAssetsFiles;
import com.vaadin.flow.shared.util.SharedUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRunDevBundleBuild
implements FallibleCommand {
    public static final String README = "This directory is automatically generated by Vaadin and contains the pre-compiled \nfrontend files/resources for your project (frontend development bundle).\n\nIt should be added to Version Control System and committed, so that other developers\ndo not have to compile it again.\n\nFrontend development bundle is automatically updated when needed:\n- an npm/pnpm package is added with @NpmPackage or directly into package.json\n- CSS, JavaScript or TypeScript files are added with @CssImport, @JsModule or @JavaScript\n- Vaadin add-on with front-end customizations is added\n- Custom theme imports/assets added into 'theme.json' file\n- Exported web component is added.\n\nIf your project development needs a hot deployment of the frontend changes, \nyou can switch Flow to use Vite development server (default in Vaadin 23.3 and earlier versions):\n- set `vaadin.frontend.hotdeploy=true` in `application.properties`\n- configure `vaadin-maven-plugin`:\n```\n   <configuration>\n       <frontendHotdeploy>true</frontendHotdeploy>\n   </configuration>\n```\n- configure `jetty-maven-plugin`:\n```\n   <configuration>\n       <systemProperties>\n           <vaadin.frontend.hotdeploy>true</vaadin.frontend.hotdeploy>\n       </systemProperties>\n   </configuration>\n```\n\nRead more [about Vaadin development mode](https://vaadin.com/docs/next/flow/configuration/development-mode#precompiled-bundle).";
    private final String README_NOT_CREATED;
    private final Options options;

    TaskRunDevBundleBuild(Options options) {
        this.options = options;
        this.README_NOT_CREATED = "Failed to create a README file in " + options.getBuildDirectoryName() + "/dev-bundle";
    }

    @Override
    public void execute() throws ExecutionFailedException {
        TaskRunDevBundleBuild.getLogger().info("Creating a new development mode bundle. This can take a while but will only run when the project setup is changed, addons are added or frontend files are modified");
        this.runFrontendBuildTool("Vite", "vite", "vite", "build");
        this.copyPackageLockToBundleFolder();
        this.addReadme();
        new TaskCopyNpmAssetsFiles(this.options).execute();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(TaskRunDevBundleBuild.class);
    }

    private void runFrontendBuildTool(String toolName, String packageName, String binaryName, String ... params) throws ExecutionFailedException {
        File buildExecutable;
        Logger logger = TaskRunDevBundleBuild.getLogger();
        FrontendToolsSettings settings = new FrontendToolsSettings(this.options.getNpmFolder().getAbsolutePath(), () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
        settings.setNodeDownloadRoot(this.options.getNodeDownloadRoot());
        settings.setForceAlternativeNode(this.options.isRequireHomeNodeExec());
        settings.setUseGlobalPnpm(this.options.isUseGlobalPnpm());
        settings.setAutoUpdate(this.options.isNodeAutoUpdate());
        settings.setNodeVersion(this.options.getNodeVersion());
        settings.setIgnoreVersionChecks(this.options.isFrontendIgnoreVersionChecks());
        FrontendTools frontendTools = new FrontendTools(settings);
        try {
            buildExecutable = frontendTools.getNpmPackageExecutable(packageName, binaryName, this.options.getNpmFolder()).toFile();
        }
        catch (FrontendUtils.CommandExecutionException e) {
            throw new IllegalStateException(String.format("Unable to locate %s executable. Expected the \"%s\" npm package to be installed and to provide the \"%s\" binary. Double check that the npm dependencies are installed.", toolName, packageName, binaryName));
        }
        if (!buildExecutable.isFile()) {
            throw new IllegalStateException(String.format("Unable to locate %s executable by path '%s'. Double check that the plugin is executed correctly", toolName, buildExecutable.getAbsolutePath()));
        }
        String nodePath = this.options.isRequireHomeNodeExec() ? frontendTools.forceAlternativeNodeExecutable() : frontendTools.getNodeExecutable();
        ArrayList<String> command = new ArrayList<String>();
        command.add(nodePath);
        command.add(buildExecutable.getAbsolutePath());
        command.addAll(Arrays.asList(params));
        String commandString = command.stream().collect(Collectors.joining(" "));
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        builder.environment().put("devBundle", "true");
        builder.environment().put("NODE_ENV", "development");
        Process process = null;
        try {
            builder.directory(this.options.getNpmFolder());
            builder.redirectInput(ProcessBuilder.Redirect.PIPE);
            builder.redirectErrorStream(true);
            process = builder.start();
            Runtime.getRuntime().addShutdownHook(new Thread(process::destroyForcibly));
            logger.debug("Output of `{}`:", (Object)commandString);
            StringBuilder toolOutput = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String stdoutLine;
                while ((stdoutLine = reader.readLine()) != null) {
                    logger.debug(stdoutLine);
                    toolOutput.append(stdoutLine).append(System.lineSeparator());
                }
            }
            int errorCode = process.waitFor();
            if (errorCode != 0) {
                logger.error("Command `{}` failed:\n{}", (Object)commandString, (Object)toolOutput);
                throw new ExecutionFailedException(SharedUtil.capitalize(toolName) + " build exited with a non zero status");
            }
            logger.info("Development frontend bundle built");
        }
        catch (IOException | InterruptedException e) {
            logger.error("Error when running `{}`", (Object)commandString, (Object)e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new ExecutionFailedException("Command '" + commandString + "' failed to finish", e);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
        if (this.options.isCompressBundle()) {
            DevBundleUtils.compressBundle(this.options.getNpmFolder(), new File(new File(this.options.getNpmFolder(), this.options.getBuildDirectoryName()), "dev-bundle"));
        }
    }

    private void copyPackageLockToBundleFolder() {
        File devBundleFolder = new File(new File(this.options.getNpmFolder(), this.options.getBuildDirectoryName()), "dev-bundle");
        assert (devBundleFolder.exists()) : "No dev-bundle folder created";
        String packageLockFile = this.options.isEnablePnpm() ? "pnpm-lock.yaml" : "package-lock.json";
        File packageLockJson = new File(this.options.getNpmFolder(), packageLockFile);
        if (packageLockJson.exists()) {
            try {
                FileUtils.copyFile((File)packageLockJson, (File)new File(devBundleFolder, packageLockFile));
            }
            catch (IOException e) {
                TaskRunDevBundleBuild.getLogger().error("Failed to copy '" + packageLockFile + "' to dev-bundle", (Throwable)e);
            }
        }
    }

    private void addReadme() {
        if (!this.options.isCompressBundle()) {
            return;
        }
        File devBundleFolder = new File(this.options.getNpmFolder(), "src/main/bundles/");
        assert (devBundleFolder.exists());
        try {
            File readme = new File(devBundleFolder, "README.md");
            if (readme.exists()) {
                return;
            }
            boolean created = readme.createNewFile();
            if (created) {
                FileUtils.writeStringToFile((File)readme, (String)README, (Charset)StandardCharsets.UTF_8);
            } else {
                TaskRunDevBundleBuild.getLogger().warn(this.README_NOT_CREATED);
            }
        }
        catch (Exception e) {
            TaskRunDevBundleBuild.getLogger().error(this.README_NOT_CREATED, (Throwable)e);
        }
    }
}

