/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.server.Platform;
import com.vaadin.flow.server.frontend.ExclusionFilter;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;

public class TaskUpdatePackages
extends NodeUpdater {
    protected static final String VAADIN_APP_PACKAGE_HASH = "vaadinAppPackageHash";
    private final boolean forceCleanUp;
    private final boolean enablePnpm;
    private File jarResourcesFolder;

    TaskUpdatePackages(FrontendDependenciesScanner frontendDependencies, Options options) {
        super(frontendDependencies, options);
        this.jarResourcesFolder = options.getJarFrontendResourcesFolder();
        this.forceCleanUp = options.isCleanNpmFiles();
        this.enablePnpm = options.isEnablePnpm();
    }

    @Override
    public void execute() {
        try {
            Map<String, String> scannedApplicationDependencies = this.frontDeps.getPackages();
            Map<String, String> scannedApplicationDevDependencies = this.frontDeps.getDevPackages();
            ObjectNode packageJson = this.getPackageJson();
            this.modified = this.updatePackageJsonDependencies(packageJson, scannedApplicationDependencies, scannedApplicationDevDependencies);
            this.generateVersionsJson(packageJson);
            boolean npmVersionLockingUpdated = this.lockVersionForNpm(packageJson);
            if (this.modified || npmVersionLockingUpdated) {
                if (!packageJson.has("type") || !packageJson.get("type").textValue().equals("module")) {
                    packageJson.put("type", "module");
                    this.log().info("Adding package.json type as module to enable ES6 modules which is now required.\nWith this change sources need to use 'import' instead of 'require' for imports.\n");
                }
                this.writePackageFile((JsonNode)packageJson);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    boolean lockVersionForNpm(ObjectNode packageJson) throws IOException {
        boolean versionLockingUpdated = false;
        ObjectNode overridesSection = this.getOverridesSection(packageJson);
        JsonNode dependencies = packageJson.get("dependencies");
        ObjectNode fullPlatformDependencies = this.getFullPlatformDependencies();
        for (String key : JacksonUtils.getKeys((JsonNode)fullPlatformDependencies)) {
            if (!overridesSection.has(key) || overridesSection.get(key).textValue().startsWith("$") || !new FrontendVersion(overridesSection.get(key).textValue()).isOlderThan(new FrontendVersion(fullPlatformDependencies.get(key).textValue()))) continue;
            overridesSection.remove(key);
        }
        for (String dependency : JacksonUtils.getKeys((JsonNode)this.versionsJson)) {
            if (overridesSection.has(dependency) || !this.shouldLockDependencyVersion(dependency, dependencies, (JsonNode)this.versionsJson)) continue;
            overridesSection.put(dependency, "$" + dependency);
            versionLockingUpdated = true;
        }
        ObjectNode devDependencies = (ObjectNode)packageJson.get("devDependencies");
        for (String dependency : JacksonUtils.getKeys((JsonNode)overridesSection)) {
            if (dependencies.has(dependency) || devDependencies.has(dependency) || !overridesSection.get(dependency).textValue().startsWith("$")) continue;
            overridesSection.remove(dependency);
            versionLockingUpdated = true;
        }
        for (String dependency : JacksonUtils.getKeys(dependencies)) {
            fullPlatformDependencies.remove(dependency);
        }
        for (String dependency : JacksonUtils.getKeys((JsonNode)devDependencies)) {
            fullPlatformDependencies.remove(dependency);
        }
        for (String dependency : JacksonUtils.getKeys((JsonNode)fullPlatformDependencies)) {
            try {
                FrontendVersion frontendVersion = new FrontendVersion(fullPlatformDependencies.get(dependency).textValue());
                if ("SNAPSHOT".equals(frontendVersion.getBuildIdentifier())) continue;
                overridesSection.set(dependency, JacksonUtils.createNode(frontendVersion.getFullVersion()));
                versionLockingUpdated = true;
            }
            catch (NumberFormatException nfe) {}
        }
        return versionLockingUpdated;
    }

    private ObjectNode getFullPlatformDependencies() throws IOException {
        ObjectNode platformDependencies = JacksonUtils.createObjectNode();
        URL coreVersionsResource = this.finder.getResource("vaadin-core-versions.json");
        if (coreVersionsResource == null) {
            return platformDependencies;
        }
        try (InputStream content = coreVersionsResource.openStream();){
            this.collectDependencies((JsonNode)JacksonUtils.readTree(IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8)), platformDependencies);
        }
        URL vaadinVersionsResource = this.finder.getResource("vaadin-versions.json");
        if (vaadinVersionsResource == null) {
            return platformDependencies;
        }
        try (InputStream content = vaadinVersionsResource.openStream();){
            this.collectDependencies((JsonNode)JacksonUtils.readTree(IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8)), platformDependencies);
        }
        return platformDependencies;
    }

    private void collectDependencies(JsonNode obj, ObjectNode collection) {
        for (String key : JacksonUtils.getKeys(obj)) {
            JsonNode value = obj.get(key);
            if (!(value instanceof ObjectNode)) continue;
            if (value.has("npmName")) {
                String version;
                String npmName = value.get("npmName").textValue();
                if (Objects.equals(npmName, "@vaadin/vaadin-core")) {
                    return;
                }
                if (value.has("npmVersion")) {
                    version = value.get("npmVersion").textValue();
                } else if (value.has("jsVersion")) {
                    version = value.get("jsVersion").textValue();
                } else {
                    this.log().debug("dependency '{}' has no 'npmVersion'/'jsVersion'.", (Object)npmName);
                    continue;
                }
                collection.put(npmName, version);
                continue;
            }
            this.collectDependencies(value, collection);
        }
    }

    private boolean shouldLockDependencyVersion(String dependency, JsonNode projectDependencies, JsonNode versionsJson) {
        String platformDefinedVersion = versionsJson.get(dependency).textValue();
        if (this.isInternalPseudoDependency(platformDefinedVersion)) {
            return false;
        }
        if (projectDependencies.has(dependency)) {
            try {
                new FrontendVersion(projectDependencies.get(dependency).textValue());
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isInternalPseudoDependency(String dependencyVersion) {
        return dependencyVersion != null && dependencyVersion.startsWith("./" + this.options.getBuildDirectoryName());
    }

    private ObjectNode getOverridesSection(ObjectNode packageJson) {
        Object overridesSection = (ObjectNode)packageJson.get("overrides");
        ObjectNode oldOverrides = null;
        if (this.options.isEnablePnpm()) {
            JsonNode pnpm;
            if (overridesSection != null) {
                oldOverrides = overridesSection;
                packageJson.remove("overrides");
            }
            overridesSection = (pnpm = packageJson.get("pnpm")) == null ? null : (ObjectNode)pnpm.get("overrides");
        } else if (packageJson.has("pnpm")) {
            oldOverrides = overridesSection;
            ((ObjectNode)packageJson.get("pnpm")).remove("overrides");
        }
        if (overridesSection == null) {
            ObjectNode objectNode = overridesSection = oldOverrides == null ? JacksonUtils.createObjectNode() : oldOverrides;
            if (this.options.isEnablePnpm()) {
                ObjectNode pnpmNode = packageJson.has("pnpm") ? (ObjectNode)packageJson.get("pnpm") : JacksonUtils.createObjectNode();
                packageJson.set("pnpm", (JsonNode)pnpmNode);
                pnpmNode.set("overrides", (JsonNode)overridesSection);
            } else {
                packageJson.set("overrides", (JsonNode)overridesSection);
            }
        }
        return overridesSection;
    }

    @Override
    String writePackageFile(JsonNode json) throws IOException {
        this.sortObject(json, "dependencies");
        this.sortObject(json, "devDependencies");
        this.sortObject(json, "vaadin");
        return super.writePackageFile(json);
    }

    private void sortObject(JsonNode json, String key) {
        if (!json.has(key)) {
            return;
        }
        ObjectNode object = (ObjectNode)json.get(key);
        ObjectNode ordered = this.orderKeys((JsonNode)object);
        JacksonUtils.getKeys((JsonNode)object).forEach(arg_0 -> ((ObjectNode)object).remove(arg_0));
        JacksonUtils.getKeys((JsonNode)ordered).forEach(prop -> {
            JsonNode value = ordered.get(prop);
            object.set(prop, value);
        });
    }

    private ObjectNode orderKeys(JsonNode object) {
        Object[] keys = (String[])JacksonUtils.getKeys(object).toArray(String[]::new);
        Arrays.sort(keys);
        ObjectNode result = JacksonUtils.createObjectNode();
        for (Object key : keys) {
            JsonNode value = object.get((String)key);
            if (value instanceof ObjectNode) {
                value = this.orderKeys(value);
            }
            result.set((String)key, value);
        }
        return result;
    }

    private boolean updatePackageJsonDependencies(ObjectNode packageJson, Map<String, String> applicationDependencies, Map<String, String> applicationDevDependencies) throws IOException {
        int added = 0;
        Map<String, String> filteredApplicationDependencies = new ExclusionFilter(this.finder, this.options.isReactEnabled() && FrontendUtils.isReactModuleAvailable(this.options), this.options.isNpmExcludeWebComponents()).exclude(applicationDependencies);
        for (Map.Entry<String, String> dep : filteredApplicationDependencies.entrySet()) {
            added += this.addDependency(packageJson, "dependencies", dep.getKey(), dep.getValue());
        }
        for (Map.Entry<String, String> devDep : applicationDevDependencies.entrySet()) {
            added += this.addDependency(packageJson, "devDependencies", devDep.getKey(), devDep.getValue());
        }
        ArrayList<String> pinnedPlatformDependencies = new ArrayList<String>();
        ObjectNode platformPinnedDependencies = this.getPlatformPinnedDependencies();
        for (String key : JacksonUtils.getKeys((JsonNode)platformPinnedDependencies)) {
            if (!filteredApplicationDependencies.containsKey(key) && TaskUpdatePackages.pinPlatformDependency((JsonNode)packageJson, (JsonNode)platformPinnedDependencies, key)) {
                ++added;
            }
            pinnedPlatformDependencies.add(key);
        }
        if (added > 0) {
            this.log().debug("Added {} dependencies to main package.json", (Object)added);
        }
        List<String> dependencyCollection = Stream.concat(filteredApplicationDependencies.entrySet().stream(), this.getDefaultDependencies().entrySet().stream()).map(Map.Entry::getKey).collect(Collectors.toList());
        dependencyCollection.addAll(pinnedPlatformDependencies);
        boolean doCleanUp = this.forceCleanUp;
        int removed = this.removeLegacyProperties(packageJson);
        removed += this.cleanDependencies(dependencyCollection, (JsonNode)packageJson, "dependencies");
        doCleanUp = doCleanUp || !this.enablePnpm && this.isPlatformVersionUpdated();
        dependencyCollection = new ArrayList<String>(this.getDefaultDevDependencies().keySet());
        dependencyCollection.addAll(applicationDevDependencies.keySet());
        int removedDev = 0;
        removedDev = this.cleanDependencies(dependencyCollection, (JsonNode)packageJson, "devDependencies");
        if (removed > 0) {
            this.log().debug("Removed {} dependencies", (Object)removed);
        }
        if (removedDev > 0) {
            this.log().debug("Removed {} devDependencies", (Object)removedDev);
        }
        if (doCleanUp) {
            this.cleanUp();
        }
        String oldHash = packageJson.get("vaadin").get("hash").textValue();
        String newHash = TaskUpdatePackages.generatePackageJsonHash((JsonNode)packageJson);
        ((ObjectNode)packageJson.get("vaadin")).put("hash", newHash);
        return added > 0 || removed > 0 || removedDev > 0 || !oldHash.equals(newHash);
    }

    private int cleanDependencies(List<String> dependencyCollection, JsonNode packageJson, String dependencyKey) {
        int removed = 0;
        ObjectNode dependencyObject = (ObjectNode)packageJson.get(dependencyKey);
        ObjectNode vaadinDependencyObject = (ObjectNode)packageJson.get("vaadin").get(dependencyKey);
        if (dependencyObject != null) {
            for (String key : JacksonUtils.getKeys((JsonNode)dependencyObject)) {
                if (dependencyCollection.contains(key) || !vaadinDependencyObject.has(key)) continue;
                dependencyObject.remove(key);
                vaadinDependencyObject.remove(key);
                this.log().debug("Removed \"{}\".", (Object)key);
                ++removed;
            }
        }
        return removed;
    }

    protected static boolean pinPlatformDependency(JsonNode packageJson, JsonNode platformPinnedVersions, String pkg) {
        FrontendVersion platformPinnedVersion = FrontendUtils.getPackageVersionFromJson(platformPinnedVersions, pkg, "vaadin_dependencies.json");
        if (platformPinnedVersion == null) {
            return false;
        }
        ObjectNode vaadinDeps = (ObjectNode)packageJson.get("vaadin").get("dependencies");
        ObjectNode packageJsonDeps = (ObjectNode)packageJson.get("dependencies");
        assert (vaadinDeps != null) : "vaadin{ dependencies { } } should exist";
        assert (packageJsonDeps != null) : "dependencies { } should exist";
        FrontendVersion packageJsonVersion = null;
        FrontendVersion vaadinDepsVersion = null;
        try {
            if (packageJsonDeps.has(pkg)) {
                packageJsonVersion = new FrontendVersion(packageJsonDeps.get(pkg).textValue());
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        try {
            if (vaadinDeps.has(pkg)) {
                vaadinDepsVersion = new FrontendVersion(vaadinDeps.get(pkg).textValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (vaadinDepsVersion != null && packageJsonVersion != null && !vaadinDepsVersion.equals(packageJsonVersion)) {
            return false;
        }
        if (platformPinnedVersion.equals(packageJsonVersion) && platformPinnedVersion.equals(vaadinDepsVersion)) {
            return false;
        }
        packageJsonDeps.put(pkg, platformPinnedVersion.getFullVersion());
        vaadinDeps.put(pkg, platformPinnedVersion.getFullVersion());
        return true;
    }

    private boolean isPlatformVersionUpdated() throws IOException {
        Optional<String> platformVersion = TaskUpdatePackages.getVaadinVersion(this.finder);
        if (platformVersion.isPresent() && this.options.getNodeModulesFolder().exists()) {
            ObjectNode vaadinJsonContents = this.getVaadinJsonContents();
            if (!vaadinJsonContents.has("vaadinVersion")) {
                return true;
            }
            return !Objects.equals(vaadinJsonContents.get("vaadinVersion").textValue(), platformVersion.get());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Optional<String> getVaadinVersion(ClassFinder finder) {
        URL coreVersionsResource = finder.getResource("vaadin-core-versions.json");
        if (coreVersionsResource == null) {
            return Optional.empty();
        }
        try (InputStream vaadinVersionsStream = coreVersionsResource.openStream();){
            ObjectNode versionsJson = JacksonUtils.readTree(IOUtils.toString((InputStream)vaadinVersionsStream, (Charset)StandardCharsets.UTF_8));
            if (!versionsJson.has("platform")) return Optional.empty();
            Optional<String> optional = Optional.of(versionsJson.get("platform").textValue());
            return optional;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(Platform.class).error("Unable to determine version information", (Throwable)e);
        }
        return Optional.empty();
    }

    private int removeLegacyProperties(ObjectNode packageJson) throws IOException {
        int result = 0;
        if (packageJson.has("dependencies")) {
            ObjectNode object = (ObjectNode)packageJson.get("dependencies");
            if (object.has("@vaadin/flow-deps")) {
                object.remove("@vaadin/flow-deps");
                this.log().debug("Removed \"{}\" as it's not generated anymore.", (Object)"@vaadin/flow-deps");
                ++result;
            }
            if (object.has("@vaadin/flow-frontend")) {
                object.remove("@vaadin/flow-frontend");
                this.log().debug("Removed \"{}\" as it's not needed anymore.", (Object)"@vaadin/flow-frontend");
                ++result;
            }
        }
        if (packageJson.has(VAADIN_APP_PACKAGE_HASH)) {
            packageJson.remove(VAADIN_APP_PACKAGE_HASH);
            this.log().debug("Removed \"{}\" as it's not used.", (Object)VAADIN_APP_PACKAGE_HASH);
            ++result;
        }
        if (!this.enablePnpm) {
            return result;
        }
        File packageLockFile = this.getPackageLockFile();
        if (packageLockFile.exists()) {
            FileUtils.forceDelete((File)this.getPackageLockFile());
        }
        return result;
    }

    private void cleanUp() throws IOException {
        FrontendUtils.deleteNodeModules(this.options.getNodeModulesFolder());
        if (this.jarResourcesFolder != null && this.jarResourcesFolder.exists()) {
            for (File file : this.jarResourcesFolder.listFiles()) {
                file.delete();
            }
        }
    }

    static String generatePackageJsonHash(JsonNode packageJson) {
        StringBuilder hashContent = new StringBuilder();
        if (packageJson.has("dependencies")) {
            JsonNode dependencies = packageJson.get("dependencies");
            hashContent.append("\"dependencies\": {");
            String sortedDependencies = JacksonUtils.getKeys(dependencies).stream().sorted(String::compareToIgnoreCase).map(key -> String.format("\"%s\": \"%s\"", key, dependencies.get(key).textValue())).collect(Collectors.joining(",\n  "));
            hashContent.append(sortedDependencies);
            hashContent.append("}");
        }
        if (packageJson.has("devDependencies")) {
            if (!hashContent.isEmpty()) {
                hashContent.append(",\n");
            }
            JsonNode devDependencies = packageJson.get("devDependencies");
            hashContent.append("\"devDependencies\": {");
            String sortedDevDependencies = JacksonUtils.getKeys(devDependencies).stream().sorted(String::compareToIgnoreCase).map(key -> String.format("\"%s\": \"%s\"", key, devDependencies.get(key).textValue())).collect(Collectors.joining(",\n  "));
            hashContent.append(sortedDevDependencies);
            hashContent.append("}");
        }
        return StringUtil.getHash(hashContent.toString());
    }
}

