/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.VersionsJsonConverter;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import elemental.json.Json;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class ExclusionFilter
implements Serializable {
    private final ClassFinder finder;
    private final boolean reactEnabled;

    public ExclusionFilter(ClassFinder finder, boolean reactEnabled) {
        this.finder = finder;
        this.reactEnabled = reactEnabled;
    }

    public Map<String, String> exclude(Map<String, String> dependencies) throws IOException {
        List<String> exclusions = this.getExclusions();
        return dependencies.entrySet().stream().filter(entry -> !exclusions.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private List<String> getExclusions() throws IOException {
        URL vaadinVersionsResource;
        ArrayList<String> exclusions = new ArrayList<String>();
        URL coreVersionsResource = this.finder.getResource("vaadin-core-versions.json");
        if (coreVersionsResource != null) {
            exclusions.addAll(this.getExclusions(coreVersionsResource));
        }
        if ((vaadinVersionsResource = this.finder.getResource("vaadin-versions.json")) != null) {
            exclusions.addAll(this.getExclusions(vaadinVersionsResource));
        }
        return exclusions;
    }

    private Set<String> getExclusions(URL versionsResource) throws IOException {
        try (InputStream content = versionsResource.openStream();){
            VersionsJsonConverter convert = new VersionsJsonConverter(Json.parse((String)IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8)), this.reactEnabled);
            Set<String> set = convert.getExclusions();
            return set;
        }
    }
}

