/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.menu.MenuRegistry;
import com.vaadin.flow.router.DefaultRoutePathProvider;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteBaseData;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RoutePathProvider;
import com.vaadin.flow.router.RoutePrefix;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.AbstractRouteRegistry;
import com.vaadin.flow.router.internal.ClientTarget;
import com.vaadin.flow.router.internal.HasUrlParameterFormat;
import com.vaadin.flow.router.internal.NavigationRouteTarget;
import com.vaadin.flow.router.internal.PathUtil;
import com.vaadin.flow.router.internal.RouteModel;
import com.vaadin.flow.router.internal.RouteTarget;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.AmbiguousRouteConfigurationException;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.SessionRouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.menu.AvailableViewInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteUtil {
    protected RouteUtil() {
    }

    public static List<Class<? extends RouterLayout>> getParentLayouts(VaadinContext context, Class<?> component, String path) {
        ArrayList<Class<? extends RouterLayout>> list = new ArrayList<Class<? extends RouterLayout>>();
        Optional<Route> route = AnnotationReader.getAnnotationFor(component, Route.class);
        if (route.isPresent() && path.equals(RouteUtil.getRoutePath(context, component)) && !route.get().layout().equals(UI.class)) {
            list.addAll(RouteUtil.collectRouteParentLayouts(route.get().layout()));
        } else {
            List<RouteAlias> routeAliases = AnnotationReader.getAnnotationsFor(component, RouteAlias.class);
            Optional<RouteAlias> matchingRoute = RouteUtil.getMatchingRouteAlias(component, path, routeAliases);
            if (matchingRoute.isPresent()) {
                list.addAll(RouteUtil.collectRouteParentLayouts(matchingRoute.get().layout()));
            }
        }
        return list;
    }

    public static List<Class<? extends RouterLayout>> getParentLayouts(RouteRegistry handledRegistry, Class<?> component, String path) {
        boolean hasRouteAndPathMatches;
        ArrayList<Class<? extends RouterLayout>> list = new ArrayList<Class<? extends RouterLayout>>();
        Optional<Route> route = AnnotationReader.getAnnotationFor(component, Route.class);
        boolean bl = hasRouteAndPathMatches = route.isPresent() && path.equals(RouteUtil.getRoutePath(handledRegistry.getContext(), component));
        if (hasRouteAndPathMatches && !route.get().layout().equals(UI.class)) {
            list.addAll(RouteUtil.collectRouteParentLayouts(route.get().layout()));
        } else {
            List<RouteAlias> routeAliases = AnnotationReader.getAnnotationsFor(component, RouteAlias.class);
            Optional<RouteAlias> matchingRoute = RouteUtil.getMatchingRouteAlias(component, path, routeAliases);
            if (matchingRoute.isPresent()) {
                list.addAll(RouteUtil.collectRouteParentLayouts(matchingRoute.get().layout()));
            }
        }
        return list;
    }

    public static String getRoutePath(VaadinContext context, Class<?> component) {
        Route route = component.getAnnotation(Route.class);
        String routePath = RouteUtil.resolve(context, component);
        if (route.absolute()) {
            return routePath;
        }
        List<String> parentRoutePrefixes = RouteUtil.getRoutePrefixes(component, route.layout(), routePath);
        return parentRoutePrefixes.stream().collect(Collectors.joining("/"));
    }

    public static String getRouteAliasPath(Class<?> component, RouteAlias alias) {
        if (alias.absolute()) {
            return alias.value();
        }
        List<String> parentRoutePrefixes = RouteUtil.getRoutePrefixes(component, alias.layout(), alias.value());
        return parentRoutePrefixes.stream().collect(Collectors.joining("/"));
    }

    private static List<String> getRoutePrefixes(Class<?> component, Class<? extends RouterLayout> layout, String value) {
        List<String> parentRoutePrefixes = RouteUtil.getParentRoutePrefixes(component, () -> layout);
        Collections.reverse(parentRoutePrefixes);
        if (value != null && !value.isEmpty()) {
            parentRoutePrefixes.add(value);
        }
        return parentRoutePrefixes;
    }

    private static List<String> getParentRoutePrefixes(Class<?> component, Supplier<Class<? extends RouterLayout>> routerLayoutSupplier) {
        ArrayList<String> list = new ArrayList<String>();
        Optional<ParentLayout> parentLayout = AnnotationReader.getAnnotationFor(component, ParentLayout.class);
        Optional<RoutePrefix> routePrefix = AnnotationReader.getAnnotationFor(component, RoutePrefix.class);
        routePrefix.ifPresent(prefix -> list.add(prefix.value()));
        if (routePrefix.isPresent() && routePrefix.get().absolute()) {
            return list;
        }
        Class<? extends RouterLayout> routerLayout = routerLayoutSupplier.get();
        if (routerLayout != null && !routerLayout.equals(UI.class)) {
            list.addAll(RouteUtil.getParentRoutePrefixes(routerLayout, () -> null));
        } else if (parentLayout.isPresent()) {
            list.addAll(RouteUtil.getParentRoutePrefixes(parentLayout.get().value(), () -> null));
        }
        return list;
    }

    static Optional<RouteAlias> getMatchingRouteAlias(Class<?> component, String path, List<RouteAlias> routeAliases) {
        return routeAliases.stream().filter(alias -> path.equals(RouteUtil.getRouteAliasPath(component, alias)) && !alias.layout().equals(UI.class)).findFirst();
    }

    public static List<Class<? extends RouterLayout>> collectRouteParentLayouts(Class<? extends RouterLayout> layout) {
        ArrayList<Class<? extends RouterLayout>> layouts = new ArrayList<Class<? extends RouterLayout>>();
        layouts.add(layout);
        Optional<ParentLayout> parentLayout = AnnotationReader.getAnnotationFor(layout, ParentLayout.class);
        if (parentLayout.isPresent()) {
            layouts.addAll(RouteUtil.collectRouteParentLayouts(parentLayout.get().value()));
        }
        return layouts;
    }

    public static List<Class<? extends RouterLayout>> getParentLayoutsForNonRouteTarget(Class<?> navigationTarget) {
        ArrayList<Class<? extends RouterLayout>> layouts = new ArrayList<Class<? extends RouterLayout>>();
        Optional<ParentLayout> parentLayout = AnnotationReader.getAnnotationFor(navigationTarget, ParentLayout.class);
        if (parentLayout.isPresent()) {
            layouts.addAll(RouteUtil.collectRouteParentLayouts(parentLayout.get().value()));
        }
        return layouts;
    }

    public static Class<? extends RouterLayout> getTopParentLayout(VaadinContext context, Class<?> component, String path) {
        if (path == null) {
            Optional<ParentLayout> parentLayout = AnnotationReader.getAnnotationFor(component, ParentLayout.class);
            if (parentLayout.isPresent()) {
                return RouteUtil.recurseToTopLayout(parentLayout.get().value());
            }
            return null;
        }
        Optional<Route> route = AnnotationReader.getAnnotationFor(component, Route.class);
        List<RouteAlias> routeAliases = AnnotationReader.getAnnotationsFor(component, RouteAlias.class);
        if (route.isPresent() && path.equals(RouteUtil.getRoutePath(context, component)) && !route.get().layout().equals(UI.class)) {
            return RouteUtil.recurseToTopLayout(route.get().layout());
        }
        Optional<RouteAlias> matchingRoute = RouteUtil.getMatchingRouteAlias(component, path, routeAliases);
        if (matchingRoute.isPresent()) {
            return RouteUtil.recurseToTopLayout(matchingRoute.get().layout());
        }
        return null;
    }

    private static Class<? extends RouterLayout> recurseToTopLayout(Class<? extends RouterLayout> layout) {
        Optional<ParentLayout> parentLayout = AnnotationReader.getAnnotationFor(layout, ParentLayout.class);
        if (parentLayout.isPresent()) {
            return RouteUtil.recurseToTopLayout(parentLayout.get().value());
        }
        return layout;
    }

    public static String resolve(VaadinContext context, Class<?> component) {
        RoutePathProvider provider = null;
        Lookup lookup = context.getAttribute(Lookup.class);
        if (lookup != null) {
            provider = lookup.lookup(RoutePathProvider.class);
            assert (provider != null);
        }
        if (provider == null) {
            provider = new DefaultRoutePathProvider();
        }
        return provider.getRoutePath(component);
    }

    public static void updateRouteRegistry(RouteRegistry registry, Set<Class<?>> addedClasses, Set<Class<?>> modifiedClasses, Set<Class<?>> deletedClasses) {
        if (!(addedClasses != null && !addedClasses.isEmpty() || modifiedClasses != null && !modifiedClasses.isEmpty() || deletedClasses != null && !deletedClasses.isEmpty())) {
            return;
        }
        Logger logger = LoggerFactory.getLogger(RouteUtil.class);
        modifiedClasses = modifiedClasses != null ? new HashSet(modifiedClasses) : new HashSet();
        addedClasses = addedClasses != null ? new HashSet(addedClasses) : new HashSet();
        Set<Class<Object>> set = deletedClasses = deletedClasses != null ? new HashSet(deletedClasses) : new HashSet();
        if (!modifiedClasses.isEmpty()) {
            addedClasses.removeIf(modifiedClasses::contains);
            deletedClasses.removeIf(modifiedClasses::contains);
        }
        RouteConfiguration routeConf = RouteConfiguration.forRegistry(registry);
        HashSet nonFlowComponentsToRemove = new HashSet();
        deletedClasses.stream().filter(clazz -> !Component.class.isAssignableFrom((Class<?>)clazz)).forEach(nonFlowComponentsToRemove::add);
        modifiedClasses.stream().filter(clazz -> !Component.class.isAssignableFrom((Class<?>)clazz)).forEach(nonFlowComponentsToRemove::add);
        HashSet layouts = new HashSet();
        boolean isSessionRegistry = registry instanceof SessionRouteRegistry;
        Predicate<Class> modifiedClassesRouteRemovalFilter = clazz -> !isSessionRegistry;
        if (registry instanceof AbstractRouteRegistry) {
            AbstractRouteRegistry abstractRouteRegistry = (AbstractRouteRegistry)registry;
            RouteUtil.filterLayoutClasses(deletedClasses).forEach(layouts::add);
            RouteUtil.filterLayoutClasses(modifiedClasses).forEach(layouts::add);
            RouteUtil.filterLayoutClasses(addedClasses).forEach(layouts::add);
            layouts.forEach(abstractRouteRegistry::updateLayout);
            if (!layouts.isEmpty()) {
                registry.getRegisteredRoutes().stream().filter(rd -> {
                    if (rd.getParentLayouts().isEmpty()) return true;
                    if (!rd.getParentLayouts().stream().anyMatch(layouts::contains)) return false;
                    return true;
                }).map(RouteBaseData::getNavigationTarget).forEach(modifiedClasses::add);
            }
            Map<String, RouteTarget> routesMap = abstractRouteRegistry.getConfiguration().getRoutesMap();
            Map routeTargets = registry.getRegisteredRoutes().stream().map(routeData -> (RouteTarget)routesMap.get(routeData.getTemplate())).filter(Objects::nonNull).collect(Collectors.toMap(RouteTarget::getTarget, Function.identity()));
            modifiedClassesRouteRemovalFilter = modifiedClassesRouteRemovalFilter.and(clazz -> {
                boolean isRegisteredAtStartup;
                RouteTarget routeTarget = (RouteTarget)routeTargets.get(clazz);
                if (routeTarget == null) {
                    return true;
                }
                boolean wasAnnotatedRoute = routeTarget.isAnnotatedRoute();
                boolean wasRegisteredAtStartup = routeTarget.isRegisteredAtStartup();
                boolean isAnnotatedRoute = clazz.isAnnotationPresent(Route.class);
                boolean bl = isRegisteredAtStartup = isAnnotatedRoute && clazz.getAnnotation(Route.class).registerAtStartup();
                if (!isAnnotatedRoute && !wasAnnotatedRoute) {
                    return false;
                }
                if (isAnnotatedRoute && wasAnnotatedRoute && !isRegisteredAtStartup && !wasRegisteredAtStartup) {
                    return false;
                }
                return !isAnnotatedRoute || !isRegisteredAtStartup;
            });
        }
        Stream<Class> toRemove = Stream.concat(RouteUtil.filterComponentClasses(deletedClasses), RouteUtil.filterComponentClasses(modifiedClasses).filter(modifiedClassesRouteRemovalFilter)).distinct();
        Stream<Object> toAdd = isSessionRegistry ? Stream.empty() : Stream.concat(RouteUtil.filterComponentClasses(addedClasses), RouteUtil.filterComponentClasses(modifiedClasses)).filter(clazz -> clazz.isAnnotationPresent(Route.class) && clazz.getAnnotation(Route.class).registerAtStartup()).distinct();
        registry.update(() -> {
            nonFlowComponentsToRemove.forEach(clazz -> routeConf.removeRoute((Class<? extends Component>)clazz));
            toRemove.forEach(componentClass -> {
                logger.debug("Removing route to {}", componentClass);
                routeConf.removeRoute((Class<? extends Component>)componentClass);
            });
            toAdd.forEach(componentClass -> {
                logger.debug("Updating route {} to {}", (Object)componentClass.getAnnotation(Route.class).value(), componentClass);
                routeConf.removeRoute((Class<? extends Component>)componentClass);
                routeConf.setAnnotatedRoute((Class<? extends Component>)componentClass);
            });
        });
    }

    private static Stream<Class<? extends RouterLayout>> filterLayoutClasses(Set<Class<?>> classes) {
        return RouteUtil.filterComponentClasses(classes).filter(RouterLayout.class::isAssignableFrom).map(clazz -> clazz);
    }

    private static Stream<Class<? extends Component>> filterComponentClasses(Set<Class<?>> classes) {
        return classes.stream().filter(Component.class::isAssignableFrom).map(clazz -> clazz);
    }

    public static boolean isAutolayoutEnabled(Class<?> target, String path) {
        if (target.isAnnotationPresent(RouteAlias.class) || target.isAnnotationPresent(RouteAlias.Container.class)) {
            for (RouteAlias alias : (RouteAlias[])target.getAnnotationsByType(RouteAlias.class)) {
                String aliasPath = RouteUtil.getRouteAliasPath(target, alias);
                String trimmedTemplate = PathUtil.trimPath(HasUrlParameterFormat.getTemplate(aliasPath, target));
                RouteModel routeModel = RouteModel.create(true);
                routeModel.addRoute(trimmedTemplate, new RouteTarget(target));
                NavigationRouteTarget navigationRouteTarget = routeModel.getNavigationRouteTarget(path);
                if (!navigationRouteTarget.hasTarget()) continue;
                return alias.autoLayout() && alias.layout().equals(UI.class);
            }
        }
        return target.isAnnotationPresent(Route.class) && target.getAnnotation(Route.class).autoLayout() && target.getAnnotation(Route.class).layout().equals(UI.class);
    }

    public static void checkForClientRouteCollisions(VaadinService service, List<RouteData> flowRoutes) throws InvalidRouteConfigurationException {
        RouteUtil.checkForClientRouteCollisions(service, (String[])flowRoutes.stream().map(RouteBaseData::getTemplate).toArray(String[]::new));
    }

    public static void checkForClientRouteCollisions(VaadinService service, String ... flowRouteTemplates) throws InvalidRouteConfigurationException {
        if (service == null || service.getDeploymentConfiguration().isProductionMode() || !FrontendUtils.isHillaUsed(service.getDeploymentConfiguration().getFrontendFolder())) {
            return;
        }
        List<String> collisions = MenuRegistry.collectClientMenuItems(false, service.getDeploymentConfiguration()).entrySet().stream().filter(entry -> ((AvailableViewInfo)entry.getValue()).children() == null).map(Map.Entry::getKey).map(PathUtil::trimPath).filter(clientRoute -> Arrays.stream(flowRouteTemplates).map(PathUtil::trimPath).anyMatch(clientRoute::equals)).toList();
        if (!collisions.isEmpty()) {
            String msg = String.format("Invalid route configuration. The following Hilla route(s) conflict with configured Flow routes: %s", String.join((CharSequence)", ", collisions));
            throw new InvalidRouteConfigurationException(msg);
        }
    }

    public static boolean hasAutoLayout(AbstractRouteRegistry registry) {
        return !registry.getLayouts().isEmpty();
    }

    public static boolean hasClientRouteWithAutoLayout(AbstractConfiguration configuration) {
        return MenuRegistry.collectClientMenuItems(false, configuration).values().stream().anyMatch(AvailableViewInfo::flowLayout);
    }

    public static boolean hasServerRouteWithAutoLayout(AbstractRouteRegistry registry) {
        Collection<Class<?>> layouts = registry.getLayouts();
        return registry.getRegisteredRoutes().stream().anyMatch(routeData -> {
            String path;
            if (routeData.getNavigationTarget().getAnnotation(Route.class) != null) {
                path = RouteUtil.getRoutePath(registry.getContext(), routeData.getNavigationTarget());
            } else {
                path = RouteUtil.resolve(registry.getContext(), routeData.getNavigationTarget());
                List<String> parentRoutePrefixes = RouteUtil.getRoutePrefixes(routeData.getNavigationTarget(), null, path);
                path = String.join((CharSequence)"/", parentRoutePrefixes);
            }
            if (!RouteUtil.isAutolayoutEnabled(routeData.getNavigationTarget(), path)) return false;
            if (!registry.hasLayout(path)) return false;
            if (!RouteUtil.collectRouteParentLayouts(registry.getLayout(path)).stream().anyMatch(layouts::contains)) return false;
            return true;
        });
    }

    public static Optional<String> getDynamicTitle(UI ui) {
        return Objects.requireNonNull(ui).getInternals().getActiveRouterTargetsChain().stream().filter(HasDynamicTitle.class::isInstance).map(element -> ((HasDynamicTitle)((Object)element)).getPageTitle()).filter(Objects::nonNull).findFirst();
    }

    public static Optional<String> getClientNavigationRouteTargetTemplate(String url) {
        if (url == null) {
            return Optional.empty();
        }
        RouteModel routeModel = RouteModel.create(true);
        MenuRegistry.getClientRoutes(false).forEach((key, value) -> {
            try {
                routeModel.addRoute((String)key, new ClientTarget((String)key));
            }
            catch (AmbiguousRouteConfigurationException ambiguousRouteConfigurationException) {
                // empty catch block
            }
        });
        url = url.isEmpty() ? url : (url.startsWith("/") ? url : "/" + url);
        return Optional.ofNullable(routeModel.getNavigationRouteTarget(url)).map(NavigationRouteTarget::getRouteTarget).map(ClientTarget.class::cast).map(ClientTarget::getTemplate);
    }
}

