/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.UsageStatistics;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.stream.Collectors;
import org.jsoup.nodes.Document;

public class UsageStatisticsExporter
implements Serializable {
    public static void exportUsageStatisticsToDocument(Document document) {
        String entries = UsageStatistics.getEntries().map(UsageStatisticsExporter::createUsageStatisticsJson).collect(Collectors.joining(","));
        if (!entries.isEmpty()) {
            String builder = "window.Vaadin = window.Vaadin || {};\nwindow.Vaadin.registrations = window.Vaadin.registrations || [];\nwindow.Vaadin.registrations.push(" + entries + ");";
            document.body().appendElement("script").text(builder);
        }
    }

    private static String createUsageStatisticsJson(UsageStatistics.UsageEntry entry) {
        JsonObject json = Json.createObject();
        json.put("is", entry.getName());
        json.put("version", entry.getVersion());
        return json.toJson();
    }
}

