/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FileIOUtils;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class TaskGenerateReactFiles
implements FallibleCommand {
    private final File frontendDirectory;
    protected static String NO_IMPORT = "Faulty configuration of serverSideRoutes.\nThe server route definition is missing from the '%1$s' file\n\nTo have working Flow routes add the following to the '%1$s' file:\n- import line 'import {serverSideRoutes} from 'Frontend/generated/flow/Flow';'\n- route '...serverSideRoutes' into the routes definition\nHybrid example with client main layout wrapper:\n\n    export const routes = [\n      {\n        element: <MainLayout />,\n        handle: { title: 'Main' },\n        children: [\n          { path: '/', element: <HelloWorldView />, handle: { title: 'Hello World' } },\n          ...serverSideRoutes\n        ],\n      },\n    ] as RouteObject[];\n";

    TaskGenerateReactFiles(Options options) {
        this.frontendDirectory = options.getFrontendDirectory();
    }

    @Override
    public void execute() throws ExecutionFailedException {
        File appTsx = new File(this.frontendDirectory, "App.tsx");
        File flowTsx = new File(new File(this.frontendDirectory, "generated/"), "flow/Flow.tsx");
        File routesTsx = new File(this.frontendDirectory, "routes.tsx");
        try {
            this.writeFile(flowTsx, this.getFileContent("Flow.tsx"));
            if (!appTsx.exists()) {
                this.writeFile(appTsx, this.getFileContent("App.tsx"));
            }
            if (!routesTsx.exists()) {
                this.writeFile(routesTsx, this.getFileContent("routes.tsx"));
            } else {
                String routesContent = FileUtils.readFileToString((File)routesTsx, (Charset)StandardCharsets.UTF_8);
                Pattern serverImport = Pattern.compile("import[\\s\\S]?\\{[\\s\\S]?serverSideRoutes[\\s\\S]?\\}[\\s\\S]?from[\\s\\S]?(\"|'|`)Frontend\\/generated\\/flow\\/Flow\\1;");
                if (!serverImport.matcher(routesContent).find()) {
                    throw new ExecutionFailedException(String.format(NO_IMPORT, routesTsx.getPath()));
                }
            }
        }
        catch (IOException e) {
            throw new ExecutionFailedException("Failed to read file content", e);
        }
    }

    private void writeFile(File target, String content) throws ExecutionFailedException {
        try {
            FileIOUtils.writeIfChanged(target, content);
        }
        catch (IOException exception) {
            String errorMessage = String.format("Error writing '%s'", target);
            throw new ExecutionFailedException(errorMessage, exception);
        }
    }

    protected String getFileContent(String fileName) throws IOException {
        String indexTemplate;
        try (InputStream indexTsStream = this.getClass().getResourceAsStream(fileName);){
            indexTemplate = IOUtils.toString((InputStream)indexTsStream, (Charset)StandardCharsets.UTF_8);
        }
        return indexTemplate;
    }
}

