/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.TaskRunDevBundleBuild;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevBundleUtils {
    private DevBundleUtils() {
    }

    public static URL findBundleFile(File projectDir, String filename) throws IOException {
        File bundleFile;
        File devBundleFolder = DevBundleUtils.getDevBundleFolder(projectDir);
        if (devBundleFolder.exists() && (bundleFile = new File(devBundleFolder, filename)).exists()) {
            return bundleFile.toURI().toURL();
        }
        return TaskRunDevBundleBuild.class.getClassLoader().getResource("vaadin-dev-bundle/" + filename);
    }

    public static File getDevBundleFolder(File projectDir) {
        return new File(projectDir, "src/main/dev-bundle");
    }

    public static String findBundleStatsJson(File projectDir) throws IOException {
        URL statsJson = DevBundleUtils.findBundleFile(projectDir, "config/stats.json");
        if (statsJson == null) {
            DevBundleUtils.getLogger().warn("There is no dev-bundle in the project or on the classpath nor is there a default bundle included.");
            return null;
        }
        return IOUtils.toString((URL)statsJson, (Charset)StandardCharsets.UTF_8);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(DevBundleUtils.class);
    }
}

