/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.Version;
import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;

public class TaskGenerateIndexTs
extends AbstractTaskClientGenerator {
    private final Options options;
    private final File frontendDirectory;
    private final File generatedImports;

    TaskGenerateIndexTs(Options options) {
        this.options = options;
        this.generatedImports = new File(options.getGeneratedFolder(), "generated-flow-imports.js");
        this.frontendDirectory = options.getFrontendDirectory();
    }

    @Override
    protected File getGeneratedFile() {
        return new File(new File(this.frontendDirectory, "generated/"), "index.ts");
    }

    @Override
    protected boolean shouldGenerate() {
        return Arrays.asList("index.tsx", "index.ts", "index.js").stream().map(type -> new File(this.frontendDirectory, (String)type)).filter(File::exists).peek(this::compareActualIndexWithIndexTemplate).findAny().isEmpty();
    }

    @Override
    protected String getFileContent() throws IOException {
        String indexTemplate;
        try (InputStream indexTsStream = this.getClass().getResourceAsStream("index.ts");){
            indexTemplate = IOUtils.toString((InputStream)indexTsStream, (Charset)StandardCharsets.UTF_8);
        }
        String relativizedImport = TaskGenerateIndexTs.ensureValidRelativePath(FrontendUtils.getUnixRelativePath(this.options.getBuildDirectory().toPath(), this.generatedImports.toPath()));
        String generatedDirRelativePathToBuildDir = FrontendUtils.getUnixRelativePath(this.getGeneratedFile().getParentFile().toPath(), this.options.getBuildDirectory().toPath());
        relativizedImport = relativizedImport.replaceFirst("^./", generatedDirRelativePathToBuildDir + "/");
        return indexTemplate.replace("[to-be-generated-by-flow]", relativizedImport);
    }

    static String ensureValidRelativePath(String relativePath) {
        if (!((String)relativePath).startsWith(".")) {
            relativePath = "./" + (String)relativePath;
        }
        return relativePath;
    }

    private void compareActualIndexWithIndexTemplate(File indexFileExist) {
        String indexContent = null;
        String indexTemplate = null;
        try {
            indexContent = IOUtils.toString((URI)indexFileExist.toURI(), (Charset)StandardCharsets.UTF_8);
            indexTemplate = this.getFileContent();
        }
        catch (IOException e) {
            TaskGenerateIndexTs.log().warn("Failed to read file content", (Throwable)e);
        }
        if (indexContent != null && !indexContent.equals(indexTemplate)) {
            UsageStatistics.markAsUsed("routing/client", Version.getFullVersion());
        }
    }
}

