/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.AbstractUpdateImports;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.ThemeDefinition;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class GenerateMainImports
extends AbstractUpdateImports {
    private final ClassFinder finder;
    private List<String> lines;
    private FrontendDependenciesScanner frontendDepScanner;
    private JsonObject statsJson;

    public GenerateMainImports(ClassFinder classFinder, FrontendDependenciesScanner frontendDepScanner, Options options, JsonObject statsJson) {
        super(options);
        this.finder = classFinder;
        this.frontendDepScanner = frontendDepScanner;
        this.statsJson = statsJson;
    }

    public List<String> getLines() {
        if (this.lines == null) {
            return Collections.emptyList();
        }
        return this.lines;
    }

    @Override
    protected boolean addCssLines(Collection<String> lines, CssData cssData, int i) {
        super.addCssLines(lines, cssData, i);
        return true;
    }

    @Override
    protected void writeImportLines(List<String> lines) {
        this.lines = lines;
    }

    @Override
    protected List<String> getModules() {
        return this.frontendDepScanner.getModules();
    }

    @Override
    protected Set<String> getScripts() {
        return this.frontendDepScanner.getScripts();
    }

    @Override
    protected URL getResource(String name) {
        return this.finder.getResource(name);
    }

    @Override
    protected Collection<String> getGeneratedModules() {
        if (this.options.getGeneratedFolder() == null) {
            return Collections.emptySet();
        }
        return NodeUpdater.getGeneratedModules(this.options.getGeneratedFolder(), Stream.of(new File(this.options.getGeneratedFolder(), "generated-flow-imports.js").getName(), new File(this.options.getGeneratedFolder(), "generated-flow-imports-fallback.js").getName()).collect(Collectors.toSet()));
    }

    @Override
    protected ThemeDefinition getThemeDefinition() {
        return this.frontendDepScanner.getThemeDefinition();
    }

    @Override
    protected AbstractTheme getTheme() {
        return this.frontendDepScanner.getTheme();
    }

    @Override
    protected Set<CssData> getCss() {
        return this.frontendDepScanner.getCss();
    }

    @Override
    protected Collection<String> getThemeLines() {
        return Collections.emptyList();
    }

    @Override
    protected Logger getLogger() {
        return NOPLogger.NOP_LOGGER;
    }

    @Override
    protected boolean inMemoryCollection() {
        return true;
    }

    @Override
    protected String getImportsNotFoundMessage() {
        return "";
    }

    @Override
    protected boolean importedFileExists(String importName) {
        if (super.importedFileExists(importName)) {
            return true;
        }
        JsonArray statsBundle = this.statsJson.hasKey("bundleImports") ? this.statsJson.getArray("bundleImports") : Json.createArray();
        importName = importName.replace("Frontend/", "./");
        for (int i = 0; i < statsBundle.length(); ++i) {
            if (!importName.equals(statsBundle.getString(i).replace("Frontend/", "./"))) continue;
            return true;
        }
        return false;
    }
}

