/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.DefaultDeploymentConfiguration;
import com.vaadin.flow.server.PropertyDeploymentConfiguration;
import com.vaadin.flow.server.VaadinConfig;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.frontend.FallbackChunk;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.startup.AbstractConfigurationFactory;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import elemental.json.JsonObject;
import elemental.json.impl.JsonUtil;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class DeploymentConfigurationFactory
extends AbstractConfigurationFactory
implements Serializable {
    public static final Object FALLBACK_CHUNK = new Serializable(){};

    public DeploymentConfiguration createDeploymentConfiguration(Class<?> systemPropertyBaseClass, VaadinConfig vaadinConfig) {
        return new DefaultDeploymentConfiguration(ApplicationConfiguration.get(vaadinConfig.getVaadinContext()), systemPropertyBaseClass, this.createInitParameters(systemPropertyBaseClass, vaadinConfig));
    }

    public DeploymentConfiguration createPropertyDeploymentConfiguration(Class<?> systemPropertyBaseClass, VaadinConfig vaadinConfig) {
        return new PropertyDeploymentConfiguration(ApplicationConfiguration.get(vaadinConfig.getVaadinContext()), systemPropertyBaseClass, this.createInitParameters(systemPropertyBaseClass, vaadinConfig));
    }

    protected Properties createInitParameters(Class<?> systemPropertyBaseClass, VaadinConfig vaadinConfig) {
        Properties initParameters = new Properties();
        DeploymentConfigurationFactory.readUiFromEnclosingClass(systemPropertyBaseClass, initParameters);
        Enumeration<String> e = vaadinConfig.getConfigParameterNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            initParameters.setProperty(name, vaadinConfig.getConfigParameter(name));
        }
        this.readBuildInfo(initParameters, vaadinConfig.getVaadinContext());
        return initParameters;
    }

    private void readBuildInfo(Properties initParameters, VaadinContext context) {
        String json = this.getTokenFileContent(initParameters::getProperty);
        FallbackChunk fallbackChunk = null;
        if (json != null) {
            JsonObject buildInfo = (JsonObject)JsonUtil.parse((String)json);
            Map<String, String> properties = this.getConfigParametersUsingTokenData(buildInfo);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if (initParameters.containsKey(entry.getKey())) continue;
                initParameters.put(entry.getKey(), entry.getValue());
            }
            fallbackChunk = FrontendUtils.readFallbackChunk(buildInfo);
        }
        if (fallbackChunk == null) {
            fallbackChunk = ApplicationConfiguration.get(context).getFallbackChunk();
        }
        if (fallbackChunk != null) {
            initParameters.put(FALLBACK_CHUNK, fallbackChunk);
        }
    }

    private static void readUiFromEnclosingClass(Class<?> systemPropertyBaseClass, Properties initParameters) {
        Class<?> enclosingClass = systemPropertyBaseClass.getEnclosingClass();
        if (enclosingClass != null && UI.class.isAssignableFrom(enclosingClass)) {
            initParameters.put("UI", enclosingClass.getName());
        }
    }
}

