/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.FrontendDependencies;
import com.vaadin.flow.server.frontend.scanner.FullDependenciesScanner;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface FrontendDependenciesScanner
extends Serializable {
    public Map<String, String> getPackages();

    public List<String> getModules();

    public Set<String> getScripts();

    public Set<CssData> getCss();

    public ThemeDefinition getThemeDefinition();

    public AbstractTheme getTheme();

    public Set<String> getClasses();

    public PwaConfiguration getPwaConfiguration();

    public static class FrontendDependenciesScannerFactory {
        public FrontendDependenciesScanner createScanner(boolean allDependenciesScan, ClassFinder finder, boolean generateEmbeddableWebComponents) {
            return this.createScanner(allDependenciesScan, finder, generateEmbeddableWebComponents, false, null);
        }

        public FrontendDependenciesScanner createScanner(boolean allDependenciesScan, ClassFinder finder, boolean generateEmbeddableWebComponents, boolean useV14Bootstrap, FeatureFlags featureFlags) {
            return this.createScanner(allDependenciesScan, finder, generateEmbeddableWebComponents, useV14Bootstrap, featureFlags, false);
        }

        public FrontendDependenciesScanner createScanner(boolean allDependenciesScan, ClassFinder finder, boolean generateEmbeddableWebComponents, boolean useV14Bootstrap, FeatureFlags featureFlags, boolean fallback) {
            if (allDependenciesScan) {
                return new FullDependenciesScanner(finder, useV14Bootstrap, featureFlags, fallback);
            }
            return new FrontendDependencies(finder, generateEmbeddableWebComponents, useV14Bootstrap, featureFlags);
        }
    }
}

