/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.OptionalParameter;
import com.vaadin.flow.router.WildcardParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

public final class ParameterDeserializer {
    public static final Set<Class<?>> supportedTypes = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Long.class, Integer.class, String.class, Boolean.class)));

    private ParameterDeserializer() {
    }

    public static <T> T deserializeParameter(Class<T> parameterType, String parameter, String targetClass) {
        if (parameterType.isAssignableFrom(String.class)) {
            return (T)parameter;
        }
        if (parameterType.isAssignableFrom(Integer.class)) {
            return (T)Integer.valueOf(parameter);
        }
        if (parameterType.isAssignableFrom(Long.class)) {
            try {
                return (T)Long.valueOf(parameter);
            }
            catch (NumberFormatException nfe) {
                String error = String.format("Received faulty Long value '%s' for class %s.", parameter, targetClass);
                LoggerFactory.getLogger(ParameterDeserializer.class).error(error);
                throw new IllegalArgumentException(error);
            }
        }
        if (parameterType.isAssignableFrom(Boolean.class)) {
            return (T)Boolean.valueOf(parameter);
        }
        throw new IllegalArgumentException(String.format("Unsupported parameter type '%s' for class %s.", parameterType, targetClass));
    }

    public static Object deserializeRouteParameters(Class<?> navigationTarget, List<String> parameters) {
        if (parameters.isEmpty()) {
            return ParameterDeserializer.isAnnotatedParameter(navigationTarget, WildcardParameter.class) ? "" : null;
        }
        Class<?> parameterType = ParameterDeserializer.getClassType(navigationTarget);
        if (ParameterDeserializer.isAnnotatedParameter(navigationTarget, WildcardParameter.class)) {
            ParameterDeserializer.validateWildcardType(navigationTarget, parameterType);
            return parameters.stream().collect(Collectors.joining("/"));
        }
        String parameter = parameters.get(0);
        return ParameterDeserializer.deserializeParameter(parameterType, parameter, navigationTarget.getName());
    }

    public static void validateWildcardType(Class<?> navigationTarget, Class<?> parameterType) {
        if (!parameterType.isAssignableFrom(String.class)) {
            throw new UnsupportedOperationException("Invalid wildcard parameter in class " + navigationTarget.getName() + ". Only String is supported for wildcard parameters.");
        }
    }

    public static boolean verifyParameters(Class<?> navigationTarget, List<String> parameters) {
        if (!HasUrlParameter.class.isAssignableFrom(navigationTarget)) {
            throw new IllegalArgumentException(String.format("Given navigationTarget '%s' does not implement HasUrlParameter.", navigationTarget.getName()));
        }
        Class<?> parameterType = ParameterDeserializer.getClassType(navigationTarget);
        if (supportedTypes.contains(parameterType)) {
            if (ParameterDeserializer.isAnnotatedParameter(navigationTarget, WildcardParameter.class)) {
                return true;
            }
            if (ParameterDeserializer.isAnnotatedParameter(navigationTarget, OptionalParameter.class)) {
                return parameters.size() <= 1;
            }
            return parameters.size() == 1;
        }
        throw new UnsupportedOperationException(String.format("Currently HasUrlParameter only supports the following parameter types: %s.", supportedTypes.stream().map(Class::getName).collect(Collectors.joining(", "))));
    }

    public static Class<?> getClassType(Class<?> navigationTarget) {
        Type type = GenericTypeReflector.getTypeParameter(navigationTarget, HasUrlParameter.class.getTypeParameters()[0]);
        if (!(type instanceof Class)) {
            throw new IllegalArgumentException(String.format("Parameter type of the given navigationTarget '%s' could not be resolved.", navigationTarget.getName()));
        }
        return GenericTypeReflector.erase((Type)type);
    }

    public static boolean isAnnotatedParameter(Class<?> navigationTarget, Class<? extends Annotation> parameterAnnotation) {
        if (!HasUrlParameter.class.isAssignableFrom(navigationTarget)) {
            return false;
        }
        String methodName = "setParameter";
        assert (methodName.equals(ReflectTools.getFunctionalMethod(HasUrlParameter.class).getName()));
        Type parameterType = GenericTypeReflector.getTypeParameter(navigationTarget, HasUrlParameter.class.getTypeParameters()[0]);
        if (parameterType == null) {
            parameterType = GenericTypeReflector.getTypeParameter((Type)navigationTarget.getGenericSuperclass(), HasUrlParameter.class.getTypeParameters()[0]);
        }
        if (parameterType == null) {
            Type iface;
            Type[] typeArray = navigationTarget.getGenericInterfaces();
            int n = typeArray.length;
            for (int i = 0; i < n && (parameterType = GenericTypeReflector.getTypeParameter((Type)(iface = typeArray[i]), HasUrlParameter.class.getTypeParameters()[0])) == null; ++i) {
            }
        }
        Class parameterClass = GenericTypeReflector.erase((Type)parameterType);
        return Stream.of(navigationTarget.getMethods()).filter(method -> methodName.equals(method.getName())).filter(method -> ParameterDeserializer.hasValidParameterTypes(method, parameterClass)).anyMatch(method -> method.getParameters()[1].isAnnotationPresent(parameterAnnotation));
    }

    private static boolean hasValidParameterTypes(Method method, Class<?> parameterClass) {
        return method.getParameterCount() == 2 && method.getParameterTypes()[0] == BeforeEvent.class && method.getParameterTypes()[1].isAssignableFrom(parameterClass);
    }
}

