/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationHandler;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationStateBuilder;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.ErrorStateRenderer;
import com.vaadin.flow.router.internal.ErrorTargetEntry;
import com.vaadin.flow.router.internal.HasUrlParameterFormat;
import com.vaadin.flow.router.internal.NavigationStateRenderer;
import com.vaadin.flow.router.internal.PathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class BeforeEvent
extends EventObject {
    private final Location location;
    private final NavigationTrigger trigger;
    private final UI ui;
    private NavigationHandler forwardTarget;
    private NavigationHandler rerouteTarget;
    private final Class<?> navigationTarget;
    private final RouteParameters parameters;
    private QueryParameters redirectQueryParameters;
    private final List<Class<? extends RouterLayout>> layouts;
    private NavigationState forwardTargetState;
    private NavigationState rerouteTargetState;
    private ErrorParameter<?> errorParameter;
    private String unknownForward = null;
    private String unknownReroute = null;
    private String externalForwardUrl = null;

    public BeforeEvent(NavigationEvent event, Class<?> navigationTarget, List<Class<? extends RouterLayout>> layouts) {
        this(event.getSource(), event.getTrigger(), event.getLocation(), navigationTarget, event.getUI(), layouts);
    }

    public BeforeEvent(NavigationEvent event, Class<?> navigationTarget, RouteParameters parameters, List<Class<? extends RouterLayout>> layouts) {
        this(event.getSource(), event.getTrigger(), event.getLocation(), navigationTarget, parameters, event.getUI(), layouts);
    }

    public BeforeEvent(Router router, NavigationTrigger trigger, Location location, Class<?> navigationTarget, UI ui, List<Class<? extends RouterLayout>> layouts) {
        this(router, trigger, location, navigationTarget, RouteParameters.empty(), ui, layouts);
    }

    public BeforeEvent(Router router, NavigationTrigger trigger, Location location, Class<?> navigationTarget, RouteParameters parameters, UI ui, List<Class<? extends RouterLayout>> layouts) {
        super(router);
        assert (trigger != null);
        assert (location != null);
        assert (navigationTarget != null);
        assert (parameters != null);
        assert (ui != null);
        assert (layouts != null);
        this.trigger = trigger;
        this.location = location;
        this.navigationTarget = navigationTarget;
        this.parameters = parameters;
        this.ui = ui;
        this.layouts = Collections.unmodifiableList(new ArrayList<Class<? extends RouterLayout>>(layouts));
    }

    public boolean hasUnknownForward() {
        return this.unknownForward != null;
    }

    public boolean hasUnknownReroute() {
        return this.unknownReroute != null;
    }

    public String getUnknownForward() {
        return this.unknownForward;
    }

    public String getUnknownReroute() {
        return this.unknownReroute;
    }

    public String getExternalForwardUrl() {
        return this.externalForwardUrl;
    }

    public Location getLocation() {
        return this.location;
    }

    public NavigationTrigger getTrigger() {
        return this.trigger;
    }

    @Override
    public Router getSource() {
        return (Router)super.getSource();
    }

    public boolean hasForwardTarget() {
        return this.forwardTarget != null;
    }

    public boolean hasExternalForwardUrl() {
        return this.externalForwardUrl != null;
    }

    public boolean hasRerouteTarget() {
        return this.rerouteTarget != null;
    }

    public NavigationHandler getForwardTarget() {
        return this.forwardTarget;
    }

    public NavigationHandler getRerouteTarget() {
        return this.rerouteTarget;
    }

    public void forwardTo(NavigationHandler forwardTarget, NavigationState targetState) {
        this.forwardTargetState = targetState;
        this.forwardTarget = forwardTarget;
    }

    public void forwardTo(NavigationState targetState) {
        Objects.requireNonNull(targetState, "targetState cannot be null");
        this.forwardTo(new NavigationStateRenderer(targetState), targetState);
    }

    public void forwardTo(Class<? extends Component> forwardTargetComponent) {
        Objects.requireNonNull(forwardTargetComponent, "forwardTargetComponent cannot be null");
        this.forwardTo(this.getNavigationState(forwardTargetComponent, RouteParameters.empty(), null));
    }

    public <T, C extends Component> void forwardTo(Class<? extends C> forwardTargetComponent, T routeParameter) {
        this.forwardTo(forwardTargetComponent, Collections.singletonList(routeParameter));
    }

    public <T, C extends Component> void forwardTo(Class<? extends C> forwardTargetComponent, List<T> routeParameters) {
        this.forwardTo(this.getNavigationState(forwardTargetComponent, HasUrlParameterFormat.getParameters(routeParameters), null));
    }

    public void forwardTo(Class<? extends Component> forwardTargetComponent, RouteParameters parameters) {
        Objects.requireNonNull(forwardTargetComponent, "forwardTargetComponent cannot be null");
        this.forwardTo(this.getNavigationState(forwardTargetComponent, parameters, null));
    }

    public <T, C extends Component> void forwardTo(Class<? extends C> forwardTargetComponent, T routeParameter, QueryParameters queryParameters) {
        Objects.requireNonNull(forwardTargetComponent, "forwardTargetComponent cannot be null");
        this.redirectQueryParameters = queryParameters;
        this.forwardTo(this.getNavigationState(forwardTargetComponent, HasUrlParameterFormat.getParameters(routeParameter), null));
    }

    public <C extends Component> void forwardTo(Class<? extends C> forwardTargetComponent, RouteParameters routeParameters, QueryParameters queryParameters) {
        Objects.requireNonNull(forwardTargetComponent, "forwardTargetComponent cannot be null");
        this.redirectQueryParameters = queryParameters;
        this.forwardTo(this.getNavigationState(forwardTargetComponent, routeParameters, null));
    }

    public <C extends Component> void forwardTo(Class<? extends C> forwardTargetComponent, QueryParameters queryParameters) {
        Objects.requireNonNull(forwardTargetComponent, "forwardTargetComponent cannot be null");
        this.redirectQueryParameters = queryParameters;
        this.forwardTo(this.getNavigationState(forwardTargetComponent, RouteParameters.empty(), null));
    }

    public void forwardTo(String location) {
        Optional<NavigationState> navigationState = this.getSource().resolveNavigationTarget(new Location(location));
        if (navigationState.isPresent()) {
            this.forwardTo(navigationState.get());
        } else {
            this.unknownForward = PathUtil.trimPath(location);
        }
    }

    public void forwardToUrl(String externalForwardUrl) {
        this.externalForwardUrl = externalForwardUrl;
    }

    public <T> void forwardTo(String location, T locationParam) {
        this.forwardTo(location, Collections.singletonList(locationParam));
    }

    public <T> void forwardTo(String location, List<T> locationParams) {
        this.forwardTo(this.getNavigationState(location, locationParams));
    }

    public void forwardTo(String locationString, QueryParameters queryParameters) {
        Optional<NavigationState> navigationState = this.getSource().resolveNavigationTarget(new Location(locationString));
        this.redirectQueryParameters = queryParameters;
        if (navigationState.isPresent()) {
            this.forwardTo(navigationState.get());
        } else {
            this.unknownForward = PathUtil.trimPath(locationString);
        }
    }

    public void rerouteTo(NavigationHandler rerouteTarget, NavigationState targetState) {
        this.rerouteTargetState = targetState;
        this.rerouteTarget = rerouteTarget;
    }

    public void rerouteTo(NavigationState targetState) {
        Objects.requireNonNull(targetState, "targetState cannot be null");
        this.rerouteTo(new NavigationStateRenderer(targetState), targetState);
    }

    public void rerouteTo(Class<? extends Component> routeTargetType) {
        Objects.requireNonNull(routeTargetType, "routeTargetType cannot be null");
        this.rerouteTo(this.getNavigationState(routeTargetType, RouteParameters.empty(), null));
    }

    public <T, C extends Component> void rerouteTo(Class<? extends C> routeTargetType, T routeParameter) {
        this.rerouteTo(routeTargetType, Collections.singletonList(routeParameter));
    }

    public <T, C extends Component> void rerouteTo(Class<? extends C> routeTargetType, List<T> routeParameters) {
        this.rerouteTo(this.getNavigationState(routeTargetType, HasUrlParameterFormat.getParameters(routeParameters), null));
    }

    public void rerouteTo(Class<? extends Component> routeTargetType, RouteParameters parameters) {
        Objects.requireNonNull(routeTargetType, "routeTargetType cannot be null");
        this.rerouteTo(this.getNavigationState(routeTargetType, parameters, null));
    }

    public <T, C extends Component> void rerouteTo(Class<? extends C> routeTargetType, T routeParameter, QueryParameters queryParameters) {
        Objects.requireNonNull(routeTargetType, "routeTargetType cannot be null");
        this.redirectQueryParameters = queryParameters;
        this.rerouteTo(this.getNavigationState(routeTargetType, HasUrlParameterFormat.getParameters(routeParameter), null));
    }

    public <C extends Component> void rerouteTo(Class<? extends C> routeTargetType, RouteParameters routeParameters, QueryParameters queryParameters) {
        Objects.requireNonNull(routeTargetType, "routeTargetComponent cannot be null");
        this.redirectQueryParameters = queryParameters;
        this.rerouteTo(this.getNavigationState(routeTargetType, routeParameters, null));
    }

    public <C extends Component> void rerouteTo(Class<? extends C> routeTargetType, QueryParameters queryParameters) {
        Objects.requireNonNull(routeTargetType, "routeTargetComponent cannot be null");
        this.redirectQueryParameters = queryParameters;
        this.rerouteTo(this.getNavigationState(routeTargetType, RouteParameters.empty(), null));
    }

    public void rerouteTo(String route) {
        Optional<NavigationState> navigationState = this.getSource().resolveNavigationTarget(new Location(route));
        if (navigationState.isPresent()) {
            this.rerouteTo(navigationState.get());
        } else {
            this.unknownReroute = PathUtil.trimPath(route);
        }
    }

    public <T> void rerouteTo(String route, T routeParam) {
        this.rerouteTo(route, Collections.singletonList(routeParam));
    }

    public <T> void rerouteTo(String route, List<T> routeParams) {
        this.rerouteTo(this.getNavigationState(route, routeParams));
    }

    public void rerouteTo(String route, QueryParameters queryParameters) {
        Optional<NavigationState> navigationState = this.getSource().resolveNavigationTarget(new Location(route));
        this.redirectQueryParameters = queryParameters;
        if (navigationState.isPresent()) {
            this.rerouteTo(navigationState.get());
        } else {
            this.unknownReroute = PathUtil.trimPath(route);
        }
    }

    private Class<? extends Component> getTargetOrThrow(String route, List<String> segments) {
        Optional<Class<? extends Component>> target = this.getSource().getRegistry().getNavigationTarget(route, segments);
        if (!target.isPresent()) {
            throw new IllegalArgumentException(String.format("No route '%s' accepting the parameters %s was found.", route, segments));
        }
        return target.get();
    }

    private <T> void checkUrlParameterType(T routeParam, Class<? extends Component> target) {
        Class<?> genericInterfaceType = ReflectTools.getGenericInterfaceType(target, HasUrlParameter.class);
        if (!genericInterfaceType.isAssignableFrom(routeParam.getClass())) {
            throw new IllegalArgumentException(String.format("Given route parameter '%s' is of the wrong type. Required '%s'.", routeParam.getClass(), genericInterfaceType));
        }
    }

    private <T> NavigationState getNavigationState(String url, List<T> routeParams) {
        List<String> segments = routeParams.stream().map(Object::toString).collect(Collectors.toList());
        Class<? extends Component> target = this.getTargetOrThrow(url, segments);
        if (!routeParams.isEmpty()) {
            this.checkUrlParameterType(routeParams.get(0), target);
        }
        return this.getNavigationState(target, HasUrlParameterFormat.getParameters(segments), HasUrlParameterFormat.getUrl(url, routeParams));
    }

    private NavigationState getNavigationState(Class<? extends Component> target, RouteParameters parameters, String resolvedUrl) {
        return new NavigationStateBuilder(this.ui.getInternals().getRouter()).withTarget(target, parameters).withPath(resolvedUrl).build();
    }

    public Class<? extends Component> getForwardTargetType() {
        return this.forwardTargetState.getNavigationTarget();
    }

    @Deprecated
    public List<String> getForwardTargetParameters() {
        return this.forwardTargetState.getUrlParameters().orElse(Collections.emptyList());
    }

    public RouteParameters getForwardTargetRouteParameters() {
        return this.forwardTargetState.getRouteParameters();
    }

    public String getForwardUrl() {
        return this.forwardTargetState.getResolvedPath();
    }

    @Deprecated
    public Class<? extends Component> getRouteTargetType() {
        return this.getRerouteTargetType();
    }

    public Class<? extends Component> getRerouteTargetType() {
        return this.rerouteTargetState.getNavigationTarget();
    }

    @Deprecated
    public List<String> getRerouteTargetParameters() {
        return this.rerouteTargetState.getUrlParameters().orElse(Collections.emptyList());
    }

    public RouteParameters getRerouteTargetRouteParameters() {
        return this.rerouteTargetState.getRouteParameters();
    }

    public String getRerouteUrl() {
        return this.rerouteTargetState.getResolvedPath();
    }

    public Class<?> getNavigationTarget() {
        return this.navigationTarget;
    }

    public RouteParameters getRouteParameters() {
        return this.parameters;
    }

    public boolean hasRedirectQueryParameters() {
        return this.redirectQueryParameters != null;
    }

    public QueryParameters getRedirectQueryParameters() {
        return this.redirectQueryParameters;
    }

    public List<Class<? extends RouterLayout>> getLayouts() {
        return this.layouts;
    }

    public void rerouteToError(Class<? extends Exception> exception) {
        this.rerouteToError(exception, "");
    }

    public void rerouteToError(Class<? extends Exception> exception, String customMessage) {
        Exception instance = ReflectTools.createInstance(exception);
        this.rerouteToError(instance, customMessage);
    }

    public void rerouteToError(Exception exception, String customMessage) {
        Optional<ErrorTargetEntry> maybeLookupResult = this.getSource().getErrorNavigationTarget(exception);
        if (!maybeLookupResult.isPresent()) {
            throw new RuntimeException(customMessage, exception);
        }
        ErrorTargetEntry lookupResult = maybeLookupResult.get();
        this.rerouteTargetState = new NavigationStateBuilder(this.ui.getInternals().getRouter()).withTarget(lookupResult.getNavigationTarget()).build();
        this.rerouteTarget = new ErrorStateRenderer(this.rerouteTargetState);
        this.errorParameter = new ErrorParameter<Exception>(lookupResult.getHandledExceptionType(), exception, customMessage);
    }

    public boolean hasErrorParameter() {
        return this.errorParameter != null;
    }

    public ErrorParameter<?> getErrorParameter() {
        return this.errorParameter;
    }

    public UI getUI() {
        return this.ui;
    }
}

