/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Direction;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HeartbeatListener;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.PollNotifier;
import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.PushConfigurationImpl;
import com.vaadin.flow.component.ReconnectDialogConfiguration;
import com.vaadin.flow.component.ShortcutEventListener;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.UIDetachedException;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.internal.UIInternalUpdater;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.page.LoadingIndicatorConfiguration;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.ExecutionContext;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.LoadingIndicatorConfigurationMap;
import com.vaadin.flow.internal.nodefeature.PollConfigurationMap;
import com.vaadin.flow.internal.nodefeature.ReconnectDialogConfigurationMap;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.BeforeLeaveListener;
import com.vaadin.flow.router.EventUtil;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.HasUrlParameterFormat;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.ErrorHandlingCommand;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.PushConnection;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsModule(value="@vaadin/common-frontend/ConnectionIndicator.js")
public class UI
extends Component
implements PollNotifier,
HasComponents,
RouterLayout {
    private static final String NULL_LISTENER = "Listener can not be 'null'";
    private static final Pattern APP_ID_REPLACE_PATTERN = Pattern.compile("-\\d+$");
    private int uiId = -1;
    private boolean closing = false;
    private PushConfiguration pushConfiguration;
    private Locale locale = Locale.getDefault();
    private final UIInternals internals;
    private final Page page = new Page(this);
    private final String csrfToken = UUID.randomUUID().toString();

    public UI() {
        this(new UIInternalUpdater(){});
    }

    protected UI(UIInternalUpdater internalsHandler) {
        super(null);
        this.internals = new UIInternals(this, internalsHandler);
        this.getNode().getFeature(ElementData.class).setTag("body");
        Component.setElement(this, Element.get(this.getNode()));
        this.pushConfiguration = new PushConfigurationImpl(this);
    }

    public VaadinSession getSession() {
        return this.internals.getSession();
    }

    public int getUIId() {
        return this.uiId;
    }

    @Deprecated
    public void doInit(VaadinRequest request, int uiId) {
        this.doInit(request, uiId, this.getSession().getService().getMainDivId(this.getSession(), request));
    }

    public void doInit(VaadinRequest request, int uiId, String appId) {
        if (this.uiId != -1) {
            String message = "This UI instance is already initialized (as UI id " + this.uiId + ") and can therefore not be initialized again (as UI id " + uiId + "). ";
            if (this.getSession() != null && !this.getSession().equals(VaadinSession.getCurrent())) {
                message = message + "Furthermore, it is already attached to another VaadinSession. ";
            }
            message = message + "Please make sure you are not accidentally reusing an old UI instance.";
            throw new IllegalStateException(message);
        }
        this.uiId = uiId;
        appId = APP_ID_REPLACE_PATTERN.matcher(appId).replaceAll("");
        this.getInternals().setAppId(appId);
        this.getInternals().addComponentDependencies(this.getClass());
        this.init(request);
    }

    protected void init(VaadinRequest request) {
    }

    public static void setCurrent(UI ui) {
        CurrentInstance.set(UI.class, ui);
    }

    public static UI getCurrent() {
        return CurrentInstance.get(UI.class);
    }

    public void close() {
        this.closing = true;
        PushConnection pushConnection = this.getInternals().getPushConnection();
        if (pushConnection != null) {
            if (this.getSession() != null) {
                this.getSession().getService().runPendingAccessTasks(this.getSession());
            }
            pushConnection.push();
        }
    }

    public boolean isClosing() {
        return this.closing;
    }

    @Override
    protected void onAttach(AttachEvent attachEvent) {
    }

    @Override
    protected void onDetach(DetachEvent detachEvent) {
    }

    public void accessSynchronously(Command command) throws UIDetachedException {
        this.accessSynchronously(command, null);
    }

    private static void handleAccessDetach(SerializableRunnable detachHandler) {
        if (detachHandler == null) {
            throw new UIDetachedException();
        }
        detachHandler.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accessSynchronously(Command command, SerializableRunnable detachHandler) {
        Map<Class<?>, CurrentInstance> old = null;
        VaadinSession session = this.getSession();
        if (session == null) {
            UI.handleAccessDetach(detachHandler);
            return;
        }
        VaadinService.verifyNoOtherSessionLocked(session);
        session.lock();
        try {
            if (this.getSession() == null) {
                UI.handleAccessDetach(detachHandler);
                return;
            }
            old = CurrentInstance.setCurrent(this);
            command.execute();
        }
        finally {
            session.unlock();
            if (old != null) {
                CurrentInstance.restoreInstances(old);
            }
        }
    }

    public Future<Void> access(Command command) {
        return this.access(command, null);
    }

    private Future<Void> access(final Command command, final SerializableRunnable detachHandler) {
        VaadinSession session = this.getSession();
        if (session == null) {
            UI.handleAccessDetach(detachHandler);
            return null;
        }
        return session.access(new ErrorHandlingCommand(){

            @Override
            public void execute() {
                UI.this.accessSynchronously(command, detachHandler);
            }

            @Override
            public void handleError(Exception exception) {
                try {
                    if (command instanceof ErrorHandlingCommand) {
                        ErrorHandlingCommand errorHandlingCommand = (ErrorHandlingCommand)command;
                        errorHandlingCommand.handleError(exception);
                    } else if (UI.this.getSession() != null) {
                        UI.this.getSession().getErrorHandler().error(new ErrorEvent(exception));
                    } else if (exception instanceof ExecutionException && ((ExecutionException)exception).getCause() instanceof UIDetachedException) {
                        UI.this.getLogger().debug(exception.getMessage(), (Throwable)exception);
                    } else {
                        UI.this.getLogger().error(exception.getMessage(), (Throwable)exception);
                    }
                }
                catch (Exception e) {
                    UI.this.getLogger().error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public SerializableRunnable accessLater(SerializableRunnable accessTask, SerializableRunnable detachHandler) {
        Objects.requireNonNull(accessTask, "Access task cannot be null");
        return () -> this.access(accessTask::run, detachHandler);
    }

    public <T> SerializableConsumer<T> accessLater(SerializableConsumer<T> accessTask, SerializableRunnable detachHandler) {
        Objects.requireNonNull(accessTask, "Access task cannot be null");
        return value -> this.access(() -> accessTask.accept(value), detachHandler);
    }

    public void setPollInterval(int intervalInMillis) {
        this.getNode().getFeature(PollConfigurationMap.class).setPollInterval(intervalInMillis);
    }

    public int getPollInterval() {
        return this.getNode().getFeature(PollConfigurationMap.class).getPollInterval();
    }

    public LoadingIndicatorConfiguration getLoadingIndicatorConfiguration() {
        return this.getNode().getFeature(LoadingIndicatorConfigurationMap.class);
    }

    public void push() {
        VaadinSession session = this.getSession();
        if (session == null) {
            throw new UIDetachedException("Cannot push a detached UI");
        }
        session.checkHasLock();
        if (!this.getPushConfiguration().getPushMode().isEnabled()) {
            throw new IllegalStateException("Push not enabled");
        }
        PushConnection pushConnection = this.getInternals().getPushConnection();
        assert (pushConnection != null);
        session.getService().runPendingAccessTasks(session);
        if (!this.getInternals().isDirty()) {
            return;
        }
        pushConnection.push();
    }

    public PushConfiguration getPushConfiguration() {
        return this.pushConfiguration;
    }

    public ReconnectDialogConfiguration getReconnectDialogConfiguration() {
        return this.getNode().getFeature(ReconnectDialogConfigurationMap.class);
    }

    Logger getLogger() {
        return LoggerFactory.getLogger((String)UI.class.getName());
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        assert (locale != null) : "Null locale is not supported!";
        if (!this.locale.equals(locale)) {
            this.locale = locale;
            EventUtil.informLocaleChangeObservers(this);
        }
    }

    public void setDirection(Direction direction) {
        Objects.requireNonNull(direction, "Direction cannot be null");
        this.getPage().executeJs("document.dir = $0", new Serializable[]{direction.getClientName()});
    }

    @Override
    public Element getElement() {
        return Element.get(this.getNode());
    }

    private StateNode getNode() {
        return this.getInternals().getStateTree().getRootNode();
    }

    public UIInternals getInternals() {
        return this.internals;
    }

    public Page getPage() {
        return this.page;
    }

    public <T extends Component> Optional<T> navigate(Class<T> navigationTarget) {
        return this.navigate(navigationTarget, RouteParameters.empty());
    }

    private <T extends Component> Optional<T> findCurrentNavigationTarget(Class<T> navigationTarget) {
        List<HasElement> activeRouterTargetsChain = this.getInternals().getActiveRouterTargetsChain();
        for (HasElement element : activeRouterTargetsChain) {
            if (!navigationTarget.isAssignableFrom(element.getClass())) continue;
            return Optional.of((Component)element);
        }
        return Optional.empty();
    }

    public <T, C extends Component> Optional<C> navigate(Class<? extends C> navigationTarget, T parameter) {
        this.navigate((Class<T>)navigationTarget, HasUrlParameterFormat.getParameters(parameter));
        return this.findCurrentNavigationTarget(navigationTarget);
    }

    public <T extends Component> Optional<T> navigate(Class<T> navigationTarget, RouteParameters parameters) {
        RouteConfiguration configuration = RouteConfiguration.forRegistry(this.getInternals().getRouter().getRegistry());
        this.navigate(configuration.getUrl(navigationTarget, parameters));
        return this.findCurrentNavigationTarget(navigationTarget);
    }

    public <T, C extends Component> Optional<C> navigate(Class<? extends C> navigationTarget, T parameter, QueryParameters queryParameters) {
        RouteConfiguration configuration = RouteConfiguration.forRegistry(this.getInternals().getRouter().getRegistry());
        RouteParameters parameters = HasUrlParameterFormat.getParameters(parameter);
        String url = configuration.getUrl(navigationTarget, parameters);
        this.getInternals().getRouter().navigate(this, new Location(url, queryParameters), NavigationTrigger.UI_NAVIGATE);
        return this.findCurrentNavigationTarget(navigationTarget);
    }

    public <T extends Component> Optional<T> navigate(Class<? extends T> navigationTarget, QueryParameters queryParameters) {
        RouteConfiguration configuration = RouteConfiguration.forRegistry(this.getInternals().getRouter().getRegistry());
        String url = configuration.getUrl(navigationTarget, RouteParameters.empty());
        this.getInternals().getRouter().navigate(this, new Location(url, queryParameters), NavigationTrigger.UI_NAVIGATE);
        return this.findCurrentNavigationTarget(navigationTarget);
    }

    public void navigate(String location) {
        this.navigate(location, QueryParameters.empty());
    }

    public void navigate(String location, QueryParameters queryParameters) {
        Objects.requireNonNull(location, "Location must not be null");
        Objects.requireNonNull(queryParameters, "Query parameters must not be null");
        this.getInternals().getRouter().navigate(this, new Location(location, queryParameters), NavigationTrigger.UI_NAVIGATE);
    }

    public boolean isNavigationSupported() {
        return true;
    }

    @Deprecated
    public Router getRouter() {
        return this.internals.getRouter();
    }

    public StateTree.ExecutionRegistration beforeClientResponse(Component component, SerializableConsumer<ExecutionContext> execution) throws IllegalArgumentException {
        if (component == null) {
            throw new IllegalArgumentException("The 'component' parameter may not be null");
        }
        if (execution == null) {
            throw new IllegalArgumentException("The 'execution' parameter may not be null");
        }
        if (component.getUI().isPresent() && component.getUI().get() != this) {
            throw new IllegalArgumentException("The given component doesn't belong to the UI the task to be executed on");
        }
        return this.internals.getStateTree().beforeClientResponse(component.getElement().getNode(), execution);
    }

    @Override
    public void add(Component ... components) {
        HasComponents.super.add(components);
    }

    @Override
    public Optional<UI> getUI() {
        return Optional.of(this);
    }

    public Registration addBeforeEnterListener(BeforeEnterListener listener) {
        Objects.requireNonNull(listener, NULL_LISTENER);
        return this.internals.addBeforeEnterListener(listener);
    }

    public Registration addBeforeLeaveListener(BeforeLeaveListener listener) {
        Objects.requireNonNull(listener, NULL_LISTENER);
        return this.internals.addBeforeLeaveListener(listener);
    }

    public Registration addAfterNavigationListener(AfterNavigationListener listener) {
        Objects.requireNonNull(listener, NULL_LISTENER);
        return this.internals.addAfterNavigationListener(listener);
    }

    public <E> List<E> getNavigationListeners(Class<E> navigationHandler) {
        return this.internals.getListeners(navigationHandler);
    }

    public ShortcutRegistration addShortcutListener(Command command, Key key, KeyModifier ... keyModifiers) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be null!", "command"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be null!", "key"));
        }
        return new ShortcutRegistration(this, () -> new Component[]{this}, event -> command.execute(), key).withModifiers(keyModifiers);
    }

    public ShortcutRegistration addShortcutListener(ShortcutEventListener listener, Key key, KeyModifier ... keyModifiers) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be null!", "listener"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be null!", "key"));
        }
        return new ShortcutRegistration(this, () -> new Component[]{this}, listener, key).withModifiers(keyModifiers);
    }

    public Registration addHeartbeatListener(HeartbeatListener listener) {
        Objects.requireNonNull(listener, NULL_LISTENER);
        return this.internals.addHeartbeatListener(listener);
    }

    public Component getActiveDragSourceComponent() {
        return this.getInternals().getActiveDragSourceComponent();
    }

    public String getCsrfToken() {
        return this.csrfToken;
    }

    public void addModal(Component component) {
        this.add(component);
        this.getInternals().setChildModal(component);
    }

    public void setChildComponentModal(Component childComponent, boolean modal) {
        Objects.requireNonNull(childComponent, "Given child component may not be null");
        Optional<UI> ui = childComponent.getUI();
        if (ui.isPresent() && !ui.get().equals(this)) {
            throw new IllegalStateException("Given component is not a child in this UI. Add it first as a child of the UI so it is attached or just use addModal(component).");
        }
        if (modal) {
            this.getInternals().setChildModal(childComponent);
        } else {
            this.getInternals().setChildModeless(childComponent);
        }
    }

    public boolean hasModalComponent() {
        return this.getInternals().hasModalComponent();
    }

    public void addToModalComponent(Component component) {
        if (this.hasModalComponent()) {
            Component activeModalComponent = this.getInternals().getActiveModalComponent();
            if (activeModalComponent instanceof HasComponents) {
                ((HasComponents)((Object)activeModalComponent)).add(component);
            } else {
                activeModalComponent.getElement().appendChild(component.getElement());
            }
        } else {
            this.add(component);
        }
    }
}

