/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.frontend.EndpointGeneratorTaskFactory;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendWebComponentGenerator;
import com.vaadin.flow.server.frontend.TaskCopyFrontendFiles;
import com.vaadin.flow.server.frontend.TaskCopyLocalFrontendFiles;
import com.vaadin.flow.server.frontend.TaskCopyTemplateFiles;
import com.vaadin.flow.server.frontend.TaskGenerateBootstrap;
import com.vaadin.flow.server.frontend.TaskGenerateEndpoint;
import com.vaadin.flow.server.frontend.TaskGenerateFeatureFlags;
import com.vaadin.flow.server.frontend.TaskGenerateHilla;
import com.vaadin.flow.server.frontend.TaskGenerateIndexHtml;
import com.vaadin.flow.server.frontend.TaskGenerateIndexTs;
import com.vaadin.flow.server.frontend.TaskGenerateOpenAPI;
import com.vaadin.flow.server.frontend.TaskGeneratePackageJson;
import com.vaadin.flow.server.frontend.TaskGenerateServiceWorker;
import com.vaadin.flow.server.frontend.TaskGenerateTsConfig;
import com.vaadin.flow.server.frontend.TaskGenerateTsDefinitions;
import com.vaadin.flow.server.frontend.TaskGenerateViteDevMode;
import com.vaadin.flow.server.frontend.TaskInstallWebpackPlugins;
import com.vaadin.flow.server.frontend.TaskRunNpmInstall;
import com.vaadin.flow.server.frontend.TaskUpdateImports;
import com.vaadin.flow.server.frontend.TaskUpdatePackages;
import com.vaadin.flow.server.frontend.TaskUpdateSettingsFile;
import com.vaadin.flow.server.frontend.TaskUpdateThemeImport;
import com.vaadin.flow.server.frontend.TaskUpdateVite;
import com.vaadin.flow.server.frontend.TaskUpdateWebpack;
import com.vaadin.flow.server.frontend.UnknownTaskException;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import elemental.json.JsonObject;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;

public class NodeTasks
implements FallibleCommand {
    private static final List<Class<? extends FallibleCommand>> commandOrder = Collections.unmodifiableList(Arrays.asList(TaskGeneratePackageJson.class, TaskGenerateIndexHtml.class, TaskGenerateIndexTs.class, TaskGenerateViteDevMode.class, TaskGenerateTsConfig.class, TaskGenerateTsDefinitions.class, TaskGenerateServiceWorker.class, TaskGenerateHilla.class, TaskGenerateOpenAPI.class, TaskGenerateEndpoint.class, TaskGenerateBootstrap.class, TaskGenerateFeatureFlags.class, TaskInstallWebpackPlugins.class, TaskUpdatePackages.class, TaskRunNpmInstall.class, TaskCopyFrontendFiles.class, TaskCopyLocalFrontendFiles.class, TaskUpdateSettingsFile.class, TaskUpdateWebpack.class, TaskUpdateVite.class, TaskUpdateImports.class, TaskUpdateThemeImport.class, TaskCopyTemplateFiles.class));
    private final List<FallibleCommand> commands = new ArrayList<FallibleCommand>();

    private NodeTasks(Builder builder) {
        ClassFinder.CachedClassFinder classFinder = new ClassFinder.CachedClassFinder(builder.classFinder);
        FrontendDependenciesScanner frontendDependencies = null;
        FeatureFlags featureFlags = builder.getFeatureFlags();
        if (builder.enablePackagesUpdate || builder.enableImportsUpdate || builder.enableWebpackConfigUpdate) {
            frontendDependencies = new FrontendDependenciesScanner.FrontendDependenciesScannerFactory().createScanner(!builder.useByteCodeScanner, classFinder, builder.generateEmbeddableWebComponents, builder.useLegacyV14Bootstrap, featureFlags);
            if (builder.generateEmbeddableWebComponents) {
                FrontendWebComponentGenerator generator = new FrontendWebComponentGenerator(classFinder);
                generator.generateWebComponents(builder.generatedFolder, frontendDependencies.getThemeDefinition());
            }
            TaskUpdatePackages packageUpdater = null;
            if (builder.enablePackagesUpdate && builder.flowResourcesFolder != null) {
                packageUpdater = new TaskUpdatePackages(classFinder, frontendDependencies, builder.npmFolder, builder.generatedFolder, builder.flowResourcesFolder, builder.cleanNpmFiles, builder.enablePnpm, builder.buildDirectory, featureFlags);
                this.commands.add(packageUpdater);
            }
            if (packageUpdater != null && builder.runNpmInstall) {
                this.commands.add(new TaskRunNpmInstall(packageUpdater, builder.enablePnpm, builder.requireHomeNodeExec, builder.nodeVersion, builder.nodeDownloadRoot, builder.useGlobalPnpm, builder.nodeAutoUpdate, builder.postinstallPackages));
                this.commands.add(new TaskInstallWebpackPlugins(new File(builder.npmFolder, builder.buildDirectory)));
            }
        }
        if (builder.createMissingPackageJson) {
            TaskGeneratePackageJson packageCreator = new TaskGeneratePackageJson(builder.npmFolder, builder.generatedFolder, builder.flowResourcesFolder, builder.buildDirectory, featureFlags);
            this.commands.add(packageCreator);
        }
        if (frontendDependencies != null) {
            this.addGenerateServiceWorkerTask(builder, frontendDependencies.getPwaConfiguration());
            this.addGenerateTsConfigTask(builder);
        }
        if (!builder.useLegacyV14Bootstrap) {
            this.addBootstrapTasks(builder);
            TaskGenerateHilla hillaTask = builder.lookup.lookup(TaskGenerateHilla.class);
            if (hillaTask != null) {
                this.commands.add(hillaTask);
            } else if (builder.endpointSourceFolder != null && builder.endpointSourceFolder.exists() && builder.endpointGeneratedOpenAPIFile != null) {
                this.addEndpointServicesTasks(builder);
            }
            this.commands.add(new TaskGenerateBootstrap(frontendDependencies, builder.frontendDirectory, builder.productionMode));
            this.commands.add(new TaskGenerateFeatureFlags(builder.frontendDirectory, featureFlags));
        }
        if (builder.jarFiles != null && builder.flowResourcesFolder != null) {
            this.commands.add(new TaskCopyFrontendFiles(builder.flowResourcesFolder, builder.jarFiles));
        }
        if (builder.localResourcesFolder != null && builder.flowResourcesFolder != null) {
            this.commands.add(new TaskCopyLocalFrontendFiles(builder.flowResourcesFolder, builder.localResourcesFolder));
        }
        if (featureFlags.isEnabled(FeatureFlags.VITE)) {
            PwaConfiguration pwa;
            String themeName = "";
            if (frontendDependencies != null) {
                if (frontendDependencies.getThemeDefinition() != null) {
                    themeName = frontendDependencies.getThemeDefinition().getName();
                }
                pwa = frontendDependencies.getPwaConfiguration();
            } else {
                pwa = new PwaConfiguration();
            }
            this.commands.add(new TaskUpdateSettingsFile(builder, themeName, pwa));
            this.commands.add(new TaskUpdateVite(builder.npmFolder, builder.buildDirectory));
        } else if (builder.enableWebpackConfigUpdate) {
            PwaConfiguration pwaConfiguration = frontendDependencies.getPwaConfiguration();
            this.commands.add(new TaskUpdateWebpack(builder.frontendDirectory, builder.npmFolder, builder.webappResourcesDirectory, builder.resourceOutputDirectory, new File(builder.generatedFolder, "generated-flow-imports.js"), builder.useLegacyV14Bootstrap, builder.flowResourcesFolder, pwaConfiguration, builder.frontendGeneratedFolder, builder.buildDirectory));
        }
        if (builder.enableImportsUpdate) {
            this.commands.add(new TaskUpdateImports(classFinder, frontendDependencies, finder -> this.getFallbackScanner(builder, (ClassFinder)finder, featureFlags), builder.npmFolder, builder.generatedFolder, builder.frontendDirectory, builder.tokenFile, builder.tokenFileData, builder.enablePnpm, builder.buildDirectory, builder.productionMode, builder.useLegacyV14Bootstrap, featureFlags));
            this.commands.add(new TaskUpdateThemeImport(builder.npmFolder, frontendDependencies.getThemeDefinition(), builder.frontendDirectory, builder.frontendGeneratedFolder));
        }
        if (builder.copyTemplates) {
            this.commands.add(new TaskCopyTemplateFiles(classFinder, builder.npmFolder, builder.resourceOutputDirectory));
        }
    }

    private void addBootstrapTasks(Builder builder) {
        TaskGenerateIndexHtml taskGenerateIndexHtml = new TaskGenerateIndexHtml(builder.frontendDirectory);
        this.commands.add(taskGenerateIndexHtml);
        File buildDirectory = new File(builder.npmFolder, builder.buildDirectory);
        TaskGenerateIndexTs taskGenerateIndexTs = new TaskGenerateIndexTs(builder.frontendDirectory, new File(builder.generatedFolder, "generated-flow-imports.js"), buildDirectory);
        this.commands.add(taskGenerateIndexTs);
        if (builder.getFeatureFlags().isEnabled(FeatureFlags.VITE) && !builder.productionMode) {
            this.commands.add(new TaskGenerateViteDevMode(builder.frontendDirectory));
        }
    }

    private void addGenerateTsConfigTask(Builder builder) {
        TaskGenerateTsConfig taskGenerateTsConfig = new TaskGenerateTsConfig(builder.npmFolder);
        this.commands.add(taskGenerateTsConfig);
        TaskGenerateTsDefinitions taskGenerateTsDefinitions = new TaskGenerateTsDefinitions(builder.npmFolder);
        this.commands.add(taskGenerateTsDefinitions);
    }

    private void addGenerateServiceWorkerTask(Builder builder, PwaConfiguration pwaConfiguration) {
        File outputDirectory = new File(builder.npmFolder, builder.buildDirectory);
        if (pwaConfiguration.isEnabled()) {
            this.commands.add(new TaskGenerateServiceWorker(builder.frontendDirectory, outputDirectory));
        }
    }

    private void addEndpointServicesTasks(Builder builder) {
        Lookup lookup = builder.lookup;
        EndpointGeneratorTaskFactory endpointGeneratorTaskFactory = lookup.lookup(EndpointGeneratorTaskFactory.class);
        if (endpointGeneratorTaskFactory != null) {
            TaskGenerateOpenAPI taskGenerateOpenAPI = endpointGeneratorTaskFactory.createTaskGenerateOpenAPI(builder.applicationProperties, builder.endpointSourceFolder, builder.classFinder.getClassLoader(), builder.endpointGeneratedOpenAPIFile);
            this.commands.add(taskGenerateOpenAPI);
            if (builder.frontendGeneratedFolder != null) {
                TaskGenerateEndpoint taskGenerateEndpoint = endpointGeneratorTaskFactory.createTaskGenerateEndpoint(builder.applicationProperties, builder.endpointGeneratedOpenAPIFile, builder.frontendGeneratedFolder, builder.frontendDirectory);
                this.commands.add(taskGenerateEndpoint);
            }
        }
    }

    private FrontendDependenciesScanner getFallbackScanner(Builder builder, ClassFinder finder, FeatureFlags featureFlags) {
        if (builder.useByteCodeScanner) {
            return new FrontendDependenciesScanner.FrontendDependenciesScannerFactory().createScanner(true, finder, builder.generateEmbeddableWebComponents, builder.useLegacyV14Bootstrap, featureFlags, true);
        }
        return null;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        this.sortCommands(this.commands);
        for (FallibleCommand command : this.commands) {
            command.execute();
        }
    }

    private void sortCommands(List<FallibleCommand> commandList) {
        commandList.sort((c1, c2) -> {
            int indexOf1 = this.getIndex((FallibleCommand)c1);
            int indexOf2 = this.getIndex((FallibleCommand)c2);
            if (indexOf1 == -1 || indexOf2 == -1) {
                return 0;
            }
            return indexOf1 - indexOf2;
        });
    }

    private int getIndex(FallibleCommand command) {
        return IntStream.range(0, commandOrder.size()).filter(i -> commandOrder.get(i).isAssignableFrom(command.getClass())).findFirst().orElseThrow(() -> new UnknownTaskException(command));
    }

    public static class Builder
    implements Serializable {
        private final String buildDirectory;
        private final ClassFinder classFinder;
        private final File frontendDirectory;
        private File webappResourcesDirectory = null;
        private File resourceOutputDirectory = null;
        private boolean enablePackagesUpdate = false;
        private boolean createMissingPackageJson = false;
        private boolean enableImportsUpdate = false;
        private boolean enableWebpackConfigUpdate = false;
        private boolean runNpmInstall = false;
        private Set<File> jarFiles = null;
        private boolean generateEmbeddableWebComponents = true;
        private boolean cleanNpmFiles = false;
        private File flowResourcesFolder = null;
        private File localResourcesFolder = null;
        private boolean useByteCodeScanner = false;
        private JsonObject tokenFileData;
        private File tokenFile;
        private boolean enablePnpm = false;
        private boolean useGlobalPnpm = false;
        private File endpointSourceFolder;
        private File endpointGeneratedOpenAPIFile;
        private File applicationProperties;
        private File frontendGeneratedFolder;
        private boolean requireHomeNodeExec;
        private boolean copyTemplates = false;
        private final File npmFolder;
        private final File generatedFolder;
        private boolean useLegacyV14Bootstrap;
        private String nodeVersion = "v16.14.2";
        private URI nodeDownloadRoot = URI.create("https://nodejs.org/dist/");
        private boolean nodeAutoUpdate = false;
        private Lookup lookup;
        private boolean productionMode = true;
        private File javaResourceFolder;
        private List<String> postinstallPackages;

        public Builder(Lookup lookup, File npmFolder, String buildDirectory) {
            this(lookup, npmFolder, new File(npmFolder, System.getProperty("vaadin.frontend.generated.folder", Paths.get(buildDirectory, "frontend/").toString())), buildDirectory);
        }

        public Builder(Lookup lookup, File npmFolder, File generatedPath, String buildDirectory) {
            this(lookup, npmFolder, generatedPath, new File(npmFolder, System.getProperty("vaadin.frontend.frontend.folder", "./frontend/")), buildDirectory);
        }

        public Builder(Lookup lookup, File npmFolder, File generatedPath, File frontendDirectory, String buildDirectory) {
            this.lookup = lookup;
            this.classFinder = lookup.lookup(ClassFinder.class);
            this.npmFolder = npmFolder;
            this.generatedFolder = generatedPath.isAbsolute() ? generatedPath : new File(npmFolder, generatedPath.getPath());
            this.frontendDirectory = frontendDirectory.isAbsolute() ? frontendDirectory : new File(npmFolder, frontendDirectory.getPath());
            this.buildDirectory = buildDirectory;
        }

        public NodeTasks build() {
            return new NodeTasks(this);
        }

        public Builder withWebpack(File webappResourcesDirectory, File resourceOutputDirectory) {
            this.enableWebpackConfigUpdate = true;
            this.webappResourcesDirectory = webappResourcesDirectory;
            this.resourceOutputDirectory = resourceOutputDirectory;
            return this;
        }

        public Builder enablePackagesUpdate(boolean enablePackagesUpdate) {
            this.enablePackagesUpdate = enablePackagesUpdate;
            return this;
        }

        Builder enableNpmFileCleaning(boolean forceClean) {
            this.cleanNpmFiles = forceClean;
            return this;
        }

        public Builder enableImportsUpdate(boolean enableImportsUpdate) {
            this.enableImportsUpdate = enableImportsUpdate;
            this.createMissingPackageJson = enableImportsUpdate || this.createMissingPackageJson;
            return this;
        }

        public Builder runNpmInstall(boolean runNpmInstall) {
            this.runNpmInstall = runNpmInstall;
            return this;
        }

        public Builder withFlowResourcesFolder(File flowResourcesFolder) {
            this.flowResourcesFolder = flowResourcesFolder.isAbsolute() ? flowResourcesFolder : new File(this.npmFolder, flowResourcesFolder.getPath());
            return this;
        }

        public Builder copyResources(Set<File> jars) {
            Objects.requireNonNull(jars, "Parameter 'jars' must not be null!");
            this.jarFiles = jars;
            return this;
        }

        public Builder copyTemplates(boolean copyTemplates) {
            this.copyTemplates = copyTemplates;
            return this;
        }

        public Builder withEmbeddableWebComponents(boolean generateEmbeddableWebComponents) {
            this.generateEmbeddableWebComponents = generateEmbeddableWebComponents;
            return this;
        }

        public Builder createMissingPackageJson(boolean create) {
            this.createMissingPackageJson = create;
            return this;
        }

        public Builder copyLocalResources(File localResourcesFolder) {
            this.localResourcesFolder = localResourcesFolder;
            return this;
        }

        public Builder useV14Bootstrap(boolean useDeprecatedV14Bootstrapping) {
            this.useLegacyV14Bootstrap = useDeprecatedV14Bootstrapping;
            return this;
        }

        public Builder withFrontendGeneratedFolder(File frontendGeneratedFolder) {
            this.frontendGeneratedFolder = frontendGeneratedFolder;
            return this;
        }

        public Builder withApplicationProperties(File applicationProperties) {
            this.applicationProperties = applicationProperties;
            return this;
        }

        public Builder withEndpointGeneratedOpenAPIFile(File endpointGeneratedOpenAPIFile) {
            this.endpointGeneratedOpenAPIFile = endpointGeneratedOpenAPIFile;
            return this;
        }

        public Builder withEndpointSourceFolder(File endpointSourceFolder) {
            this.endpointSourceFolder = endpointSourceFolder;
            return this;
        }

        public Builder useByteCodeScanner(boolean byteCodeScanner) {
            this.useByteCodeScanner = byteCodeScanner;
            return this;
        }

        public Builder populateTokenFileData(JsonObject object) {
            this.tokenFileData = object;
            return this;
        }

        public Builder withTokenFile(File tokenFile) {
            this.tokenFile = tokenFile;
            return this;
        }

        public Builder enablePnpm(boolean enable) {
            this.enablePnpm = enable;
            return this;
        }

        public Builder useGlobalPnpm(boolean useGlobalPnpm) {
            this.useGlobalPnpm = useGlobalPnpm;
            return this;
        }

        public Builder withHomeNodeExecRequired(boolean requireHomeNodeExec) {
            this.requireHomeNodeExec = requireHomeNodeExec;
            return this;
        }

        public Builder withNodeVersion(String nodeVersion) {
            this.nodeVersion = Objects.requireNonNull(nodeVersion);
            return this;
        }

        public Builder withNodeDownloadRoot(URI nodeDownloadRoot) {
            this.nodeDownloadRoot = Objects.requireNonNull(nodeDownloadRoot);
            return this;
        }

        public Builder withProductionMode(boolean productionMode) {
            this.productionMode = productionMode;
            return this;
        }

        public Builder setNodeAutoUpdate(boolean update) {
            this.nodeAutoUpdate = update;
            return this;
        }

        public File getNpmFolder() {
            return this.npmFolder;
        }

        public File getGeneratedFolder() {
            return this.generatedFolder;
        }

        public File getWebappResourcesDirectory() {
            return this.webappResourcesDirectory;
        }

        public File getFrontendDirectory() {
            return this.frontendDirectory;
        }

        public String getBuildDirectory() {
            return this.buildDirectory;
        }

        public Builder setJavaResourceFolder(File javaResourceFolder) {
            this.javaResourceFolder = javaResourceFolder;
            return this;
        }

        protected FeatureFlags getFeatureFlags() {
            FeatureFlags featureFlags = new FeatureFlags(this.lookup);
            if (this.javaResourceFolder != null) {
                featureFlags.setPropertiesLocation(this.javaResourceFolder);
            }
            return featureFlags;
        }

        public Builder withPostinstallPackages(List<String> postinstallPackages) {
            this.postinstallPackages = postinstallPackages;
            return this;
        }
    }
}

