/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.server.communication.rpc.RpcInvocationHandler;
import elemental.json.JsonObject;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRpcInvocationHandler
implements RpcInvocationHandler {
    @Override
    public Optional<Runnable> handle(UI ui, JsonObject invocationJson) {
        assert (invocationJson.hasKey("node"));
        StateNode node = ui.getInternals().getStateTree().getNodeById(AbstractRpcInvocationHandler.getNodeId(invocationJson));
        if (node == null) {
            AbstractRpcInvocationHandler.getLogger().warn("Ignoring RPC for non-existent node: {}", (Object)AbstractRpcInvocationHandler.getNodeId(invocationJson));
            return Optional.empty();
        }
        if (!node.isAttached()) {
            AbstractRpcInvocationHandler.getLogger().warn("Ignoring RPC for detached node: {}", (Object)AbstractRpcInvocationHandler.getNodeId(invocationJson));
            return Optional.empty();
        }
        if (node.isInactive()) {
            AbstractRpcInvocationHandler.getLogger().trace("Ignored RPC for invocation handler '{}' from the client side for an inactive (disabled or invisible) node id='{}'", (Object)this.getClass().getName(), (Object)node.getId());
            return Optional.empty();
        }
        if (!this.allowInert(node) && node.isInert()) {
            AbstractRpcInvocationHandler.getLogger().trace("Ignored RPC for invocation handler '{}' from the client side for an inert node id='{}'", (Object)this.getClass().getName(), (Object)node.getId());
            return Optional.empty();
        }
        return this.handleNode(node, invocationJson);
    }

    protected boolean allowInert(StateNode node) {
        return false;
    }

    protected abstract Optional<Runnable> handleNode(StateNode var1, JsonObject var2);

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)AbstractRpcInvocationHandler.class.getName());
    }

    private static int getNodeId(JsonObject invocationJson) {
        return (int)invocationJson.getNumber("node");
    }
}

