/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.MessageDigestUtil;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.communication.ReturnChannelHandler;
import com.vaadin.flow.server.communication.rpc.AttachExistingElementRpcHandler;
import com.vaadin.flow.server.communication.rpc.AttachTemplateChildRpcHandler;
import com.vaadin.flow.server.communication.rpc.EventRpcHandler;
import com.vaadin.flow.server.communication.rpc.MapSyncRpcHandler;
import com.vaadin.flow.server.communication.rpc.NavigationRpcHandler;
import com.vaadin.flow.server.communication.rpc.PublishedServerEventHandlerRpcHandler;
import com.vaadin.flow.server.communication.rpc.RpcInvocationHandler;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRpcHandler
implements Serializable {
    private static final int MAX_BUFFER_SIZE = 65536;

    /*
     * Enabled aggressive block sorting
     */
    public void handleRpc(UI ui, Reader reader, VaadinRequest request) throws IOException, InvalidUIDLSecurityKeyException {
        RpcRequest rpcRequest;
        block7: {
            ui.getSession().setLastRequestTimestamp(System.currentTimeMillis());
            String changeMessage = this.getMessage(reader);
            if (changeMessage == null || changeMessage.equals("")) {
                return;
            }
            rpcRequest = new RpcRequest(changeMessage, request);
            if (!VaadinService.isCsrfTokenValid(ui, rpcRequest.getCsrfToken())) {
                throw new InvalidUIDLSecurityKeyException();
            }
            String hashMessage = changeMessage;
            if (hashMessage.length() > 65536) {
                hashMessage = changeMessage.substring(0, 65536);
            }
            byte[] messageHash = MessageDigestUtil.sha256(hashMessage);
            int expectedId = ui.getInternals().getLastProcessedClientToServerId() + 1;
            int requestId = rpcRequest.getClientToServerId();
            if (requestId != -1 && requestId != expectedId) {
                if (requestId == expectedId - 1 && Arrays.equals(messageHash, ui.getInternals().getLastProcessedMessageHash())) {
                    ServerRpcHandler.getLogger().info("Ignoring old duplicate message from the client. Expected: " + expectedId + ", got: " + requestId);
                    break block7;
                } else {
                    String messageDetails = this.getMessageDetails(rpcRequest);
                    ServerRpcHandler.getLogger().debug("Unexpected message id from the client. Expected sync id: " + expectedId + ", got " + requestId + ". Message start: " + messageDetails);
                    throw new UnsupportedOperationException("Unexpected message id from the client. Expected sync id: " + expectedId + ", got " + requestId + ". more details logged on DEBUG level.");
                }
            }
            ui.getInternals().setLastProcessedClientToServerId(expectedId, messageHash);
            this.handleInvocations(ui, rpcRequest.getRpcInvocationsData());
        }
        if (rpcRequest.isResynchronize()) {
            ServerRpcHandler.getLogger().warn("Resynchronizing UI by client's request. A network message was lost before reaching the client and the client is reloading the full UI state. This typically happens because of a bad network connection with packet loss or because of some part of the network infrastructure (load balancer, proxy) terminating a push (websocket or long-polling) connection. If you are using push with a proxy, make sure the push timeout is set to be smaller than the proxy connection timeout");
            ui.getInternals().getStateTree().prepareForResync();
            ui.getInternals().getDependencyList().clearPendingSendToClient();
            throw new ResynchronizationRequiredException();
        }
    }

    private String getMessageDetails(RpcRequest rpcRequest) {
        StringBuilder messageDetails = new StringBuilder();
        JsonArray rpcArray = rpcRequest.getRpcInvocationsData();
        if (rpcArray == null) {
            return "{ no data }";
        }
        for (int i = 0; i < rpcArray.length(); ++i) {
            JsonObject json = (JsonObject)rpcArray.get(i);
            String type = json.hasKey("type") ? json.getString("type") : "";
            Double node = json.hasKey("node") ? Double.valueOf(json.getNumber("node")) : null;
            Double feature = json.hasKey("feature") ? Double.valueOf(json.getNumber("feature")) : null;
            ServerRpcHandler.appendAll(messageDetails, "{ type: ", type, " node: ", String.valueOf(node), " feature: ", String.valueOf(feature), " } ");
        }
        return messageDetails.toString();
    }

    private static void appendAll(StringBuilder builder, String ... strings) {
        for (String string : strings) {
            builder.append(string);
        }
    }

    protected Map<String, RpcInvocationHandler> getInvocationHandlers() {
        return Collections.unmodifiableMap(LazyInvocationHandlers.HANDLERS);
    }

    private void handleInvocations(UI ui, JsonArray invocationsData) {
        ArrayList<JsonObject> data = new ArrayList<JsonObject>(invocationsData.length());
        ArrayList pendingChangeEvents = new ArrayList();
        RpcInvocationHandler mapSyncHandler = this.getInvocationHandlers().get("mSync");
        for (int i = 0; i < invocationsData.length(); ++i) {
            JsonObject invocationJson = invocationsData.getObject(i);
            String type = invocationJson.getString("type");
            assert (type != null);
            if ("mSync".equals(type)) {
                mapSyncHandler.handle(ui, invocationJson).ifPresent(pendingChangeEvents::add);
                continue;
            }
            data.add(invocationJson);
        }
        pendingChangeEvents.forEach(runnable -> this.runMapSyncTask(ui, (Runnable)runnable));
        data.forEach(json -> this.handleInvocationData(ui, (JsonObject)json));
    }

    private void runMapSyncTask(UI ui, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            ui.getSession().getErrorHandler().error(new ErrorEvent(throwable));
        }
    }

    private void handleInvocationData(UI ui, JsonObject invocationJson) {
        String type = invocationJson.getString("type");
        RpcInvocationHandler handler = this.getInvocationHandlers().get(type);
        if (handler == null) {
            throw new IllegalArgumentException("Unsupported event type: " + type);
        }
        try {
            Optional<Runnable> handle = handler.handle(ui, invocationJson);
            assert (!handle.isPresent()) : "RPC handler " + handler.getClass().getName() + " returned a Runnable even though it shouldn't";
        }
        catch (Throwable throwable) {
            ui.getSession().getErrorHandler().error(new ErrorEvent(throwable));
        }
    }

    protected String getMessage(Reader reader) throws IOException {
        int read;
        StringBuilder sb = new StringBuilder(65536);
        char[] buffer = new char[65536];
        while ((read = reader.read(buffer)) != -1) {
            sb.append(buffer, 0, read);
        }
        return sb.toString();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)ServerRpcHandler.class.getName());
    }

    private static RpcInvocationHandler resolveHandlerConflicts(RpcInvocationHandler handler1, RpcInvocationHandler handler2) {
        String msg = String.format("There are two Rpc invocation handlers for the same type '%s' : '%s and %s", handler1.getRpcType(), handler1.getClass().getName(), handler2.getClass().getName());
        throw new IllegalStateException(msg);
    }

    private static class LazyInvocationHandlers {
        private static final Map<String, RpcInvocationHandler> HANDLERS = LazyInvocationHandlers.loadHandlers().stream().collect(Collectors.toMap(RpcInvocationHandler::getRpcType, Function.identity(), (x$0, x$1) -> ServerRpcHandler.access$200(x$0, x$1), HashMap::new));

        private LazyInvocationHandlers() {
        }

        private static List<RpcInvocationHandler> loadHandlers() {
            ArrayList<RpcInvocationHandler> list = new ArrayList<RpcInvocationHandler>();
            list.add(new EventRpcHandler());
            list.add(new NavigationRpcHandler());
            list.add(new MapSyncRpcHandler());
            list.add(new PublishedServerEventHandlerRpcHandler());
            list.add(new AttachExistingElementRpcHandler());
            list.add(new AttachTemplateChildRpcHandler());
            list.add(new ReturnChannelHandler());
            return list;
        }
    }

    public static class ResynchronizationRequiredException
    extends RuntimeException {
    }

    public static class InvalidUIDLSecurityKeyException
    extends GeneralSecurityException {
    }

    public static class RpcRequest
    implements Serializable {
        private final String csrfToken;
        private final JsonArray invocations;
        private final int syncId;
        private final JsonObject json;
        private final boolean resynchronize;
        private final int clientToServerMessageId;

        public RpcRequest(String jsonString, VaadinRequest request) {
            this.json = (JsonObject)JsonUtil.parse((String)jsonString);
            JsonValue token = this.json.get("csrfToken");
            if (token == null) {
                this.csrfToken = "init";
            } else {
                String csrfToken = token.asString();
                if (csrfToken.equals("")) {
                    csrfToken = "init";
                }
                this.csrfToken = csrfToken;
            }
            this.syncId = request.getService().getDeploymentConfiguration().isSyncIdCheckEnabled() ? (int)this.json.getNumber("syncId") : -1;
            this.resynchronize = this.json.hasKey("resynchronize") ? this.json.getBoolean("resynchronize") : false;
            if (this.json.hasKey("clientId")) {
                this.clientToServerMessageId = (int)this.json.getNumber("clientId");
            } else {
                ServerRpcHandler.getLogger().warn("Server message without client id received");
                this.clientToServerMessageId = -1;
            }
            this.invocations = this.json.getArray("rpc");
        }

        public String getCsrfToken() {
            return this.csrfToken;
        }

        public JsonArray getRpcInvocationsData() {
            return this.invocations;
        }

        public int getSyncId() {
            return this.syncId;
        }

        public boolean isResynchronize() {
            return this.resynchronize;
        }

        public int getClientToServerId() {
            return this.clientToServerMessageId;
        }

        public JsonObject getRawJson() {
            return this.json;
        }
    }
}

