/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.router.InvalidLocationException;
import com.vaadin.flow.router.LocationUtil;
import com.vaadin.flow.router.QueryParameters;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class Location
implements Serializable {
    static final String QUERY_SEPARATOR = "?";
    private final List<String> segments;
    private final QueryParameters queryParameters;
    private String fragment;

    public Location(String location) throws InvalidLocationException {
        this(LocationUtil.parsePathToSegments(LocationUtil.ensureRelativeNonNull(location)), LocationUtil.parseQueryParameters(location));
        int fragmentIndex;
        int n = fragmentIndex = location == null ? -1 : location.indexOf(35);
        if (fragmentIndex > -1) {
            this.fragment = location.substring(fragmentIndex);
        }
    }

    public Location(String location, QueryParameters queryParameters) throws InvalidLocationException {
        this(LocationUtil.parsePathToSegments(LocationUtil.ensureRelativeNonNull(location)), queryParameters);
        if (location != null && location.contains(QUERY_SEPARATOR)) {
            throw new InvalidLocationException("Location string can not contain query parameters in this constructor");
        }
    }

    public Location(List<String> segments) {
        this(segments, QueryParameters.empty());
    }

    public Location(List<String> segments, QueryParameters queryParameters) {
        if (segments == null) {
            throw new IllegalArgumentException("Segments cannot be null");
        }
        if (segments.isEmpty()) {
            throw new IllegalArgumentException("There must be at least one segment");
        }
        if (queryParameters == null) {
            throw new IllegalArgumentException("Query parameters cannot be null");
        }
        this.segments = segments;
        this.queryParameters = queryParameters;
    }

    public List<String> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public QueryParameters getQueryParameters() {
        return this.queryParameters;
    }

    public String getFirstSegment() {
        return this.segments.get(0);
    }

    public Optional<Location> getSubLocation() {
        List<String> subSegments = this.segments.subList(1, this.segments.size());
        if (subSegments.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new Location(subSegments, this.queryParameters));
    }

    public String getPath() {
        return this.segments.stream().collect(Collectors.joining("/"));
    }

    public String getPathWithQueryParameters() {
        String path;
        String basePath = this.getPath();
        assert (!basePath.contains(QUERY_SEPARATOR)) : "Base path can not contain query separator=?";
        assert (!basePath.contains("#")) : "Base path can not contain fragment #";
        StringBuilder pathBuilder = new StringBuilder(basePath);
        String params = this.queryParameters.getQueryString();
        if (!params.isEmpty()) {
            pathBuilder.append(QUERY_SEPARATOR).append(params);
        }
        if (this.fragment != null) {
            pathBuilder.append(this.fragment);
        }
        return (path = pathBuilder.toString()).isEmpty() ? "." : path;
    }

    public Location toggleTrailingSlash() {
        assert (!this.segments.isEmpty());
        String lastSegment = this.segments.get(this.segments.size() - 1);
        if (this.segments.size() == 1 && "".equals(lastSegment)) {
            throw new IllegalArgumentException("Can't toggle ending slash for the \"\" location");
        }
        if (lastSegment.isEmpty()) {
            return new Location(this.segments.subList(0, this.segments.size() - 1), this.queryParameters);
        }
        ArrayList<String> newSegments = new ArrayList<String>(this.segments);
        newSegments.add("");
        return new Location(newSegments, this.queryParameters);
    }
}

