/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.RouteAliasData;
import com.vaadin.flow.router.RouteBaseData;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RoutesChangedEvent;
import com.vaadin.flow.router.RoutesChangedListener;
import com.vaadin.flow.router.internal.ConfigureRoutes;
import com.vaadin.flow.router.internal.ConfiguredRoutes;
import com.vaadin.flow.router.internal.DefaultErrorHandler;
import com.vaadin.flow.router.internal.ErrorTargetEntry;
import com.vaadin.flow.router.internal.HasUrlParameterFormat;
import com.vaadin.flow.router.internal.NavigationRouteTarget;
import com.vaadin.flow.router.internal.PathUtil;
import com.vaadin.flow.router.internal.RouteTarget;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractRouteRegistry
implements RouteRegistry {
    private static final String TARGET_MUST_NOT_BE_NULL = "Target must not be null.";
    private final ReentrantLock configurationLock = new ReentrantLock(true);
    private volatile ConfiguredRoutes configuredRoutes = new ConfiguredRoutes();
    private volatile ConfigureRoutes editing = null;
    private CopyOnWriteArrayList<RoutesChangedListener> routesChangedListeners = new CopyOnWriteArrayList();

    protected void configure(Configuration command) {
        this.lock();
        try {
            if (this.editing == null) {
                this.editing = new ConfigureRoutes(this.configuredRoutes);
            }
            command.configure(this.editing);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void update(Command command) {
        this.lock();
        try {
            command.execute();
        }
        finally {
            this.unlock();
        }
    }

    private void lock() {
        this.configurationLock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unlock() {
        if (this.configurationLock.getHoldCount() == 1 && this.editing != null) {
            try {
                ConfiguredRoutes oldConfiguration = this.configuredRoutes;
                this.configuredRoutes = new ConfiguredRoutes(this.editing);
                if (this.routesChangedListeners.isEmpty()) return;
                List<RouteBaseData<?>> oldRoutes = this.flattenRoutes(this.getRegisteredRoutes(oldConfiguration));
                List<RouteBaseData<?>> newRoutes = this.flattenRoutes(this.getRegisteredRoutes(this.configuredRoutes));
                ArrayList added = new ArrayList();
                ArrayList removed = new ArrayList();
                oldRoutes.stream().filter(route -> !newRoutes.contains(route)).forEach(removed::add);
                newRoutes.stream().filter(route -> !oldRoutes.contains(route)).forEach(added::add);
                this.fireEvent(new RoutesChangedEvent(this, added, removed));
                return;
            }
            finally {
                this.editing = null;
                this.configurationLock.unlock();
            }
        } else {
            this.configurationLock.unlock();
        }
    }

    protected void fireEvent(RoutesChangedEvent routeChangedEvent) {
        this.routesChangedListeners.forEach(listener -> listener.routesChanged(routeChangedEvent));
    }

    @Override
    public Registration addRoutesChangeListener(RoutesChangedListener listener) {
        return Registration.addAndRemove(this.routesChangedListeners, listener);
    }

    protected boolean hasLock() {
        return this.configurationLock.isHeldByCurrentThread();
    }

    public ConfiguredRoutes getConfiguration() {
        if (this.configurationLock.isHeldByCurrentThread() && this.editing != null) {
            return this.editing;
        }
        return this.configuredRoutes;
    }

    @Override
    public List<RouteData> getRegisteredRoutes() {
        return this.getRegisteredRoutes(this.getConfiguration());
    }

    private List<RouteData> getRegisteredRoutes(ConfiguredRoutes configuration) {
        ArrayList registeredRoutes = new ArrayList();
        configuration.getTargetRoutes().forEach((target, template) -> this.populateRegisteredRoutes(configuration, registeredRoutes, (Class<? extends Component>)target, (String)template));
        Collections.sort(registeredRoutes);
        return Collections.unmodifiableList(registeredRoutes);
    }

    private void populateRegisteredRoutes(ConfiguredRoutes configuration, List<RouteData> registeredRoutes, Class<? extends Component> target, String template) {
        ArrayList<RouteAliasData> routeAliases = new ArrayList<RouteAliasData>();
        configuration.getRoutePaths(target).stream().filter(routePathTemplate -> !routePathTemplate.equals(template)).forEach(aliasRoutePathTemplate -> routeAliases.add(new RouteAliasData(this.getParentLayouts(configuration, (String)aliasRoutePathTemplate), (String)aliasRoutePathTemplate, configuration.getParameters((String)aliasRoutePathTemplate), target)));
        List<Class<? extends RouterLayout>> parentLayouts = this.getParentLayouts(configuration, template);
        RouteData route = new RouteData(parentLayouts, template, configuration.getParameters(template), target, routeAliases);
        registeredRoutes.add(route);
    }

    private List<RouteBaseData<?>> flattenRoutes(List<RouteData> routeData) {
        ArrayList flatRoutes = new ArrayList();
        for (RouteData route : routeData) {
            RouteData nonAliasCollection = new RouteData(route.getParentLayouts(), route.getTemplate(), route.getRouteParameters(), route.getNavigationTarget(), Collections.emptyList());
            flatRoutes.add(nonAliasCollection);
            route.getRouteAliases().forEach(flatRoutes::add);
        }
        return flatRoutes;
    }

    private List<Class<? extends RouterLayout>> getParentLayouts(ConfiguredRoutes configuration, String template) {
        RouteTarget routeTarget = configuration.getRouteTarget(template);
        if (routeTarget != null) {
            return routeTarget.getParentLayouts();
        }
        return Collections.emptyList();
    }

    @Override
    @Deprecated
    public List<Class<? extends RouterLayout>> getRouteLayouts(String path, Class<? extends Component> navigationTarget) {
        return this.getConfiguration().getParentLayouts(path, navigationTarget);
    }

    @Override
    public Optional<String> getTargetUrl(Class<? extends Component> navigationTarget) {
        Objects.requireNonNull(navigationTarget, TARGET_MUST_NOT_BE_NULL);
        HasUrlParameterFormat.checkMandatoryParameter(navigationTarget, null);
        return Optional.ofNullable(this.getConfiguration().getTargetUrl(navigationTarget));
    }

    @Override
    public Optional<String> getTargetUrl(Class<? extends Component> navigationTarget, RouteParameters parameters) {
        Objects.requireNonNull(navigationTarget, TARGET_MUST_NOT_BE_NULL);
        HasUrlParameterFormat.checkMandatoryParameter(navigationTarget, parameters);
        return Optional.ofNullable(this.getConfiguration().getTargetUrl(navigationTarget, parameters));
    }

    @Override
    public Optional<String> getTemplate(Class<? extends Component> navigationTarget) {
        Objects.requireNonNull(navigationTarget, TARGET_MUST_NOT_BE_NULL);
        return Optional.ofNullable(this.getConfiguration().getTemplate(navigationTarget));
    }

    @Override
    public void setRoute(String path, Class<? extends Component> navigationTarget, List<Class<? extends RouterLayout>> parentChain) {
        this.configureWithFullTemplate(path, navigationTarget, (configuration, fullTemplate) -> configuration.setRoute((String)fullTemplate, navigationTarget, parentChain));
    }

    @Override
    public void removeRoute(Class<? extends Component> navigationTarget) {
        if (!this.getConfiguration().hasRouteTarget(navigationTarget)) {
            return;
        }
        this.configure(configuration -> configuration.removeRoute(navigationTarget));
    }

    @Override
    public void removeRoute(String path) {
        if (!this.getConfiguration().hasTemplate(path)) {
            return;
        }
        this.configure(configuration -> configuration.removeRoute(path));
    }

    @Override
    public void removeRoute(String path, Class<? extends Component> navigationTarget) {
        if (!this.getConfiguration().hasTemplate(path)) {
            return;
        }
        this.configureWithFullTemplate(path, navigationTarget, (configuration, fullTemplate) -> configuration.removeRoute((String)fullTemplate, navigationTarget));
    }

    @Override
    public void clean() {
        this.configure(ConfigureRoutes::clear);
    }

    private void configureWithFullTemplate(String path, Class<? extends Component> navigationTarget, SerializableBiConsumer<ConfigureRoutes, String> templateConfiguration) {
        this.configure(configuration -> templateConfiguration.accept(configuration, HasUrlParameterFormat.getTemplate(path, navigationTarget)));
    }

    @Override
    public NavigationRouteTarget getNavigationRouteTarget(String url) {
        return this.getConfiguration().getNavigationRouteTarget(url);
    }

    @Override
    public RouteTarget getRouteTarget(Class<? extends Component> target, RouteParameters parameters) {
        return this.getConfiguration().getRouteTarget(target, parameters);
    }

    @Override
    public Optional<Class<? extends Component>> getNavigationTarget(String url) {
        Objects.requireNonNull(url, "url must not be null.");
        return this.getConfiguration().getTarget(url);
    }

    @Override
    public Optional<Class<? extends Component>> getNavigationTarget(String url, List<String> segments) {
        return this.getNavigationTarget(PathUtil.getPath(url, segments));
    }

    protected void addErrorTarget(Class<? extends Component> target, Map<Class<? extends Exception>, Class<? extends Component>> exceptionTargetsMap) {
        Class<Exception> exceptionType = ReflectTools.getGenericInterfaceType(target, HasErrorParameter.class).asSubclass(Exception.class);
        if (exceptionTargetsMap.containsKey(exceptionType)) {
            this.handleRegisteredExceptionType(exceptionTargetsMap, target, exceptionType);
        } else {
            exceptionTargetsMap.put(exceptionType, target);
        }
    }

    private void handleRegisteredExceptionType(Map<Class<? extends Exception>, Class<? extends Component>> exceptionTargetsMap, Class<? extends Component> target, Class<? extends Exception> exceptionType) {
        Class<? extends Component> registered = exceptionTargetsMap.get(exceptionType);
        if (registered.isAssignableFrom(target)) {
            exceptionTargetsMap.put(exceptionType, target);
        } else if (!target.isAssignableFrom(registered)) {
            if (registered.isAnnotationPresent(DefaultErrorHandler.class)) {
                exceptionTargetsMap.put(exceptionType, target);
            } else if (!target.isAnnotationPresent(DefaultErrorHandler.class)) {
                String msg = String.format("Only one target for an exception should be defined. Found '%s' and '%s' for exception '%s'", target.getName(), registered.getName(), exceptionType.getName());
                throw new InvalidRouteConfigurationException(msg);
            }
        }
    }

    protected Optional<ErrorTargetEntry> searchByCause(Exception exception) {
        Class<? extends Component> targetClass = this.getConfiguration().getExceptionHandlerByClass(exception.getClass());
        if (targetClass != null) {
            return Optional.of(new ErrorTargetEntry(targetClass, exception.getClass()));
        }
        Throwable cause = exception.getCause();
        if (cause instanceof Exception) {
            return this.searchByCause((Exception)cause);
        }
        return Optional.empty();
    }

    protected Optional<ErrorTargetEntry> searchBySuperType(Throwable exception) {
        for (Class<?> superClass = exception.getClass().getSuperclass(); superClass != null && Exception.class.isAssignableFrom(superClass); superClass = superClass.getSuperclass()) {
            Class<? extends Component> targetClass = this.getConfiguration().getExceptionHandlerByClass(superClass);
            if (targetClass == null) continue;
            return Optional.of(new ErrorTargetEntry(targetClass, superClass.asSubclass(Exception.class)));
        }
        return Optional.empty();
    }

    @FunctionalInterface
    public static interface Configuration
    extends Serializable {
        public void configure(ConfigureRoutes var1);
    }
}

