/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendVersion;
import elemental.json.Json;
import elemental.json.JsonObject;
import org.slf4j.LoggerFactory;

class VersionsJsonFilter {
    private final JsonObject userManagedDependencies;
    private final JsonObject vaadinVersions;
    private final String dependenciesKey;
    private static final String OLDER_VERSION_WARNING = "Using user (package.json) pinned version '{}' of '{}' which is older than the current platform version '{}'";

    VersionsJsonFilter(JsonObject packageJson, String dependenciesKey) {
        this.dependenciesKey = dependenciesKey;
        this.userManagedDependencies = this.collectUserManagedDependencies(packageJson);
        this.vaadinVersions = this.collectFrameworkVersions(packageJson);
    }

    JsonObject getFilteredVersions(JsonObject versions) {
        JsonObject json = Json.createObject();
        for (String key : versions.keys()) {
            FrontendVersion version = FrontendUtils.getPackageVersionFromJson(versions, key, "vaadin_version.json");
            if (version == null || version.getFullVersion().contains("SNAPSHOT")) continue;
            FrontendVersion userManagedVersion = FrontendUtils.getPackageVersionFromJson(this.userManagedDependencies, key, "/package.json -> { dependencies }");
            FrontendVersion vaadinDepsVersion = FrontendUtils.getPackageVersionFromJson(this.vaadinVersions, key, "/package.json -> { vaadin { dependencies }}");
            if (userManagedVersion != null) {
                if (version.isNewerThan(userManagedVersion)) {
                    LoggerFactory.getLogger((String)"Versions").warn(OLDER_VERSION_WARNING, new Object[]{this.userManagedDependencies.getString(key), key, versions.getString(key)});
                }
                json.put(key, this.userManagedDependencies.getString(key));
                continue;
            }
            if (vaadinDepsVersion != null && vaadinDepsVersion.isNewerThan(version)) {
                json.put(key, this.vaadinVersions.getString(key));
                continue;
            }
            json.put(key, versions.getString(key));
        }
        return json;
    }

    private JsonObject collectUserManagedDependencies(JsonObject packageJson) {
        JsonObject json = Json.createObject();
        JsonObject vaadinDep = this.collectFrameworkVersions(packageJson);
        if (packageJson.hasKey(this.dependenciesKey)) {
            JsonObject dependencies = packageJson.getObject(this.dependenciesKey);
            for (String key : dependencies.keys()) {
                if (!this.isUserChanged(key, vaadinDep, dependencies)) continue;
                json.put(key, dependencies.getString(key));
            }
        }
        return json;
    }

    private boolean isUserChanged(String key, JsonObject vaadinDep, JsonObject dependencies) {
        if (vaadinDep.hasKey(key)) {
            FrontendVersion dep;
            FrontendVersion vaadin = new FrontendVersion(key, vaadinDep.getString(key));
            return !vaadin.isEqualTo(dep = new FrontendVersion(key, dependencies.getString(key)));
        }
        return true;
    }

    private JsonObject collectFrameworkVersions(JsonObject packageJson) {
        if (packageJson.hasKey("vaadin") && packageJson.getObject("vaadin").hasKey(this.dependenciesKey)) {
            return packageJson.getObject("vaadin").getObject(this.dependenciesKey);
        }
        return Json.createObject();
    }
}

