/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.DevServerWatchDog;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DevModeHandler {
    private static final AtomicReference<DevModeHandler> atomicHandler = new AtomicReference();
    private static final String DEFAULT_OUTPUT_PATTERN = ": Compiled.";
    private static final String DEFAULT_ERROR_PATTERN = ": Failed to compile.";
    private static final String FAILED_MSG = "\n------------------ Frontend compilation failed. -----------------";
    private static final String SUCCEED_MSG = "\n----------------- Frontend compiled successfully. -----------------";
    private static final String START = "\n------------------ Starting Frontend compilation. ------------------\n";
    private static final String END = "\n------------------------- Webpack stopped  -------------------------\n";
    private static final String LOG_START = "Running webpack to compile frontend resources. This may take a moment, please stand by...";
    private static final String LOG_END = "Started webpack-dev-server. Time: {}ms";
    private static final String DEFAULT_TIMEOUT_FOR_PATTERN = "60000";
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static final int DEFAULT_TIMEOUT = 120000;
    private static final String WEBPACK_HOST = "http://localhost";
    private boolean notified = false;
    private String failedOutput;
    public static final String WEBPACK_SERVER = "node_modules/webpack-dev-server/bin/webpack-dev-server.js";
    private int port;
    private Process webpackProcess;
    private final boolean reuseDevServer;
    private DevServerWatchDog watchDog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DevModeHandler(DeploymentConfiguration config, int runningPort, File npmFolder, File webpack, File webpackConfig) {
        this.port = runningPort;
        this.reuseDevServer = config.reuseDevServer();
        if (this.port > 0) {
            if (this.checkWebpackConnection()) {
                DevModeHandler.getLogger().info("Reusing webpack-dev-server running at {}:{}", (Object)WEBPACK_HOST, (Object)this.port);
                this.saveRunningDevServerPort();
                this.watchDog = null;
                return;
            }
            throw new IllegalStateException(String.format("webpack-dev-server port '%d' is defined but it's not working properly", this.port));
        }
        this.watchDog = new DevServerWatchDog();
        this.port = DevModeHandler.getFreePort();
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).directory(npmFolder);
        FrontendTools tools = new FrontendTools(npmFolder.getAbsolutePath(), () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
        tools.validateNodeAndNpmVersion();
        boolean useHomeNodeExec = config.getBooleanProperty("require.home.node", false);
        String nodeExec = null;
        nodeExec = useHomeNodeExec ? tools.forceAlternativeNodeExecutable() : tools.getNodeExecutable();
        ArrayList<String> command = new ArrayList<String>();
        command.add(nodeExec);
        command.add(webpack.getAbsolutePath());
        command.add("--config");
        command.add(webpackConfig.getAbsolutePath());
        command.add("--port");
        command.add(String.valueOf(this.port));
        command.add("--watchDogPort=" + this.watchDog.getWatchDogPort());
        if (config.getBooleanProperty("devmode.transpile", false)) {
            command.add("--transpile-es5");
        }
        command.addAll(Arrays.asList(config.getStringProperty("devmode.webpack.options", "-d --inline=false").split(" +")));
        FrontendUtils.console("\u001b[38;5;35m%s\u001b[0m", START);
        if (DevModeHandler.getLogger().isDebugEnabled()) {
            DevModeHandler.getLogger().debug(FrontendUtils.commandToString(npmFolder.getAbsolutePath(), command));
        }
        long start = System.nanoTime();
        processBuilder.command(command);
        try {
            this.webpackProcess = processBuilder.redirectError(ProcessBuilder.Redirect.PIPE).redirectErrorStream(true).start();
            Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
            Pattern succeed = Pattern.compile(config.getStringProperty("devmode.webpack.output.success.pattern", DEFAULT_OUTPUT_PATTERN));
            Pattern failure = Pattern.compile(config.getStringProperty("devmode.webpack.output.error.pattern", DEFAULT_ERROR_PATTERN));
            this.logStream(this.webpackProcess.getInputStream(), succeed, failure);
            DevModeHandler.getLogger().info(LOG_START);
            DevModeHandler devModeHandler = this;
            synchronized (devModeHandler) {
                this.wait(Integer.parseInt(config.getStringProperty("devmode.webpack.output.pattern.timeout", DEFAULT_TIMEOUT_FOR_PATTERN)));
            }
            if (!this.webpackProcess.isAlive()) {
                throw new IllegalStateException("Webpack exited prematurely");
            }
            long ms = (System.nanoTime() - start) / 1000000L;
            DevModeHandler.getLogger().info(LOG_END, (Object)ms);
        }
        catch (IOException | InterruptedException e) {
            DevModeHandler.getLogger().error("Failed to start the webpack process", (Throwable)e);
        }
        this.saveRunningDevServerPort();
    }

    public static DevModeHandler start(DeploymentConfiguration configuration, File npmFolder) {
        return DevModeHandler.start(0, configuration, npmFolder);
    }

    public static DevModeHandler start(int runningPort, DeploymentConfiguration configuration, File npmFolder) {
        if (configuration.isProductionMode() || configuration.isCompatibilityMode() || !configuration.enableDevServer()) {
            return null;
        }
        atomicHandler.compareAndSet(null, DevModeHandler.createInstance(runningPort, configuration, npmFolder));
        return DevModeHandler.getDevModeHandler();
    }

    public static DevModeHandler getDevModeHandler() {
        return atomicHandler.get();
    }

    private static DevModeHandler createInstance(int runningPort, DeploymentConfiguration configuration, File npmFolder) {
        File webpack = null;
        File webpackConfig = null;
        if (runningPort == 0) {
            runningPort = DevModeHandler.getRunningDevServerPort();
        }
        if (runningPort == 0) {
            webpack = new File(npmFolder, WEBPACK_SERVER);
            webpackConfig = new File(npmFolder, "webpack.config.js");
            if (!npmFolder.exists()) {
                DevModeHandler.getLogger().warn("Instance not created because cannot change to '{}'", (Object)npmFolder);
                return null;
            }
            if (!webpack.canExecute()) {
                DevModeHandler.getLogger().warn("Instance not created because cannot execute '{}'. Did you run `npm install`", (Object)webpack);
                return null;
            }
            if (!webpack.exists()) {
                DevModeHandler.getLogger().warn("Instance not created because file '{}' doesn't exist. Did you run `npm install`", (Object)webpack);
                return null;
            }
            if (!webpackConfig.canRead()) {
                DevModeHandler.getLogger().warn("Instance not created because there is not webpack configuration '{}'", (Object)webpackConfig);
                return null;
            }
        }
        return new DevModeHandler(configuration, runningPort, npmFolder, webpack, webpackConfig);
    }

    public boolean isDevModeRequest(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        return pathInfo != null && pathInfo.matches(".+\\.js") && !pathInfo.startsWith("/VAADIN/dynamic/resource/");
    }

    public boolean serveDevModeRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requestFilename = request.getPathInfo();
        HttpURLConnection connection = this.prepareConnection(requestFilename, request.getMethod());
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header2;
            connection.setRequestProperty(header2, "Connect".equals(header2 = (String)headerNames.nextElement()) ? "close" : request.getHeader(header2));
        }
        DevModeHandler.getLogger().debug("Requesting resource to webpack {}", (Object)connection.getURL());
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            DevModeHandler.getLogger().debug("Resource not served by webpack {}", (Object)requestFilename);
            return false;
        }
        DevModeHandler.getLogger().debug("Served resource by webpack: {} {}", (Object)responseCode, (Object)requestFilename);
        connection.getHeaderFields().forEach((header, values) -> {
            if (header != null) {
                response.addHeader(header, (String)values.get(0));
            }
        });
        if (responseCode == 200) {
            this.writeStream(response.getOutputStream(), connection.getInputStream());
        } else if (responseCode < 400) {
            response.setStatus(responseCode);
        } else {
            response.sendError(responseCode);
        }
        response.getOutputStream().close();
        return true;
    }

    private boolean checkWebpackConnection() {
        try {
            this.prepareConnection("/", "GET").getResponseCode();
            return true;
        }
        catch (IOException e) {
            DevModeHandler.getLogger().debug("Error checking webpack dev server connection", (Throwable)e);
            return false;
        }
    }

    public HttpURLConnection prepareConnection(String path, String method) throws IOException {
        URL uri = new URL("http://localhost:" + this.port + path);
        HttpURLConnection connection = (HttpURLConnection)uri.openConnection();
        connection.setRequestMethod(method);
        connection.setReadTimeout(120000);
        connection.setConnectTimeout(120000);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotify() {
        if (!this.notified) {
            this.notified = true;
            DevModeHandler devModeHandler = this;
            synchronized (devModeHandler) {
                this.notify();
            }
        }
    }

    private void logStream(InputStream input, Pattern success, Pattern failure) {
        Thread thread = new Thread(() -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            try {
                this.readLinesLoop(success, failure, reader);
            }
            catch (IOException e) {
                if ("Stream closed".equals(e.getMessage())) {
                    FrontendUtils.console("\u001b[38;5;35m%s\u001b[0m", END);
                    DevModeHandler.getLogger().debug("Exception when reading webpack output.", (Throwable)e);
                }
                DevModeHandler.getLogger().error("Exception when reading webpack output.", (Throwable)e);
            }
            this.doNotify();
        });
        thread.setDaemon(true);
        thread.setName("webpack");
        thread.start();
    }

    private void readLinesLoop(Pattern success, Pattern failure, BufferedReader reader) throws IOException {
        String line;
        StringBuilder output = this.getOutputBuilder();
        Consumer<String> info = s -> DevModeHandler.getLogger().debug(String.format("\u001b[38;5;35m%s\u001b[0m", "{}"), s);
        Consumer<String> error = s -> DevModeHandler.getLogger().error(String.format("\u001b[38;5;196m%s\u001b[0m", "{}"), s);
        Consumer<String> warn = s -> DevModeHandler.getLogger().debug(String.format("\u001b[38;5;111m%s\u001b[0m", "{}"), s);
        Consumer<String> log = info;
        while ((line = reader.readLine()) != null) {
            String cleanLine = line.replaceAll("\u001b\\[[;\\d]*m", "").replaceAll("\\?babel-target=[\\w\\d]+", "");
            log = line.contains("WARNING") ? warn : (line.contains("ERROR") ? error : (this.isInfo(line, cleanLine) ? info : log));
            log.accept(cleanLine);
            if (log.equals(error)) {
                output.append(cleanLine).append(System.lineSeparator());
            }
            boolean succeed = success.matcher(line).find();
            boolean failed = failure.matcher(line).find();
            if (!succeed && !failed) continue;
            log.accept(succeed ? SUCCEED_MSG : FAILED_MSG);
            this.failedOutput = failed ? output.toString() : null;
            output = this.getOutputBuilder();
            log = info;
            this.doNotify();
        }
    }

    private boolean isInfo(String line, String cleanLine) {
        return line.trim().isEmpty() || cleanLine.trim().startsWith("i");
    }

    private StringBuilder getOutputBuilder() {
        StringBuilder output = new StringBuilder();
        output.append(String.format("Webpack build failed with errors:%n", new Object[0]));
        return output;
    }

    private void writeStream(ServletOutputStream outputStream, InputStream inputStream) throws IOException {
        int bytes;
        byte[] buffer = new byte[32768];
        while ((bytes = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, bytes);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)"dev-webpack");
    }

    public String getFailedOutput() {
        return this.failedOutput;
    }

    public void removeRunningDevServerPort() {
        FileUtils.deleteQuietly((File)LazyDevServerPortFileInit.DEV_SERVER_PORT_FILE);
    }

    private void saveRunningDevServerPort() {
        File portFile = LazyDevServerPortFileInit.DEV_SERVER_PORT_FILE;
        try {
            FileUtils.writeStringToFile((File)portFile, (String)String.valueOf(this.port), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static int getRunningDevServerPort() {
        int port = 0;
        File portFile = LazyDevServerPortFileInit.DEV_SERVER_PORT_FILE;
        if (portFile.canRead()) {
            try {
                String portString = FileUtils.readFileToString((File)portFile, (Charset)StandardCharsets.UTF_8).trim();
                if (!portString.isEmpty()) {
                    port = Integer.parseInt(portString);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return port;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getFreePort() {
        try (ServerSocket s = new ServerSocket(0);){
            s.setReuseAddress(true);
            int n = s.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to find a free port for running webpack", e);
        }
    }

    public int getPort() {
        return this.port;
    }

    public boolean reuseDevServer() {
        return this.reuseDevServer;
    }

    public void stop() {
        if (atomicHandler.get() == null) {
            return;
        }
        try {
            this.prepareConnection("/stop", "GET").getResponseCode();
        }
        catch (IOException e) {
            DevModeHandler.getLogger().debug("webpack-dev-server does not support the `/stop` command.", (Throwable)e);
        }
        if (this.watchDog != null) {
            this.watchDog.stop();
        }
        if (this.webpackProcess != null && this.webpackProcess.isAlive()) {
            this.webpackProcess.destroy();
        }
        atomicHandler.set(null);
        this.removeRunningDevServerPort();
    }

    private static final class LazyDevServerPortFileInit {
        private static final File DEV_SERVER_PORT_FILE = LazyDevServerPortFileInit.createDevServerPortFile();

        private LazyDevServerPortFileInit() {
        }

        private static File createDevServerPortFile() {
            try {
                return File.createTempFile("flow-dev-server", "port");
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        }
    }
}

