/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.InternalServerError;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouteNotFoundError;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RoutesChangedEvent;
import com.vaadin.flow.router.internal.AbstractRouteRegistry;
import com.vaadin.flow.router.internal.ErrorTargetEntry;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.osgi.OSGiAccess;
import com.vaadin.flow.server.startup.NavigationTargetFilter;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import org.slf4j.LoggerFactory;

public class ApplicationRouteRegistry
extends AbstractRouteRegistry {
    private AtomicReference<Class<?>> pwaConfigurationClass = new AtomicReference();
    private static final Set<Class<? extends Component>> defaultErrorHandlers = Stream.of(RouteNotFoundError.class, InternalServerError.class).collect(Collectors.toSet());
    private final ArrayList<NavigationTargetFilter> routeFilters = new ArrayList();

    protected ApplicationRouteRegistry() {
        ServiceLoader.load(NavigationTargetFilter.class).forEach(this.routeFilters::add);
    }

    @Deprecated
    public static ApplicationRouteRegistry getInstance(ServletContext context) {
        return ApplicationRouteRegistry.getInstance(new VaadinServletContext(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationRouteRegistry getInstance(VaadinContext context) {
        ApplicationRouteRegistryWrapper attribute;
        assert (context != null);
        VaadinContext vaadinContext = context;
        synchronized (vaadinContext) {
            attribute = context.getAttribute(ApplicationRouteRegistryWrapper.class);
            if (attribute == null) {
                attribute = new ApplicationRouteRegistryWrapper(ApplicationRouteRegistry.createRegistry(context));
                context.setAttribute(attribute);
            }
        }
        return attribute.getRegistry();
    }

    @Override
    public void setRoute(String path, Class<? extends Component> navigationTarget, List<Class<? extends RouterLayout>> parentChain) {
        if (this.routeFilters.stream().allMatch(filter -> filter.testNavigationTarget(navigationTarget))) {
            super.setRoute(path, navigationTarget, parentChain);
        } else {
            LoggerFactory.getLogger(ApplicationRouteRegistry.class).info("Not registering route {} because it's not valid for all registered routeFilters.", (Object)navigationTarget.getName());
        }
    }

    public void setErrorNavigationTargets(Set<Class<? extends Component>> errorNavigationTargets) {
        HashMap<Class<? extends Exception>, Class<? extends Component>> exceptionTargetsMap = new HashMap<Class<? extends Exception>, Class<? extends Component>>();
        exceptionTargetsMap.putAll(this.getConfiguration().getExceptionHandlers());
        errorNavigationTargets.stream().filter(target -> !defaultErrorHandlers.contains(target)).filter(this::allErrorFiltersMatch).filter(handler -> !Modifier.isAbstract(handler.getModifiers())).forEach(target -> this.addErrorTarget((Class<? extends Component>)target, (Map<Class<? extends Exception>, Class<? extends Component>>)exceptionTargetsMap));
        this.initErrorTargets(exceptionTargetsMap);
    }

    private boolean allErrorFiltersMatch(Class<? extends Component> target) {
        return this.routeFilters.stream().allMatch(filter -> filter.testErrorNavigationTarget(target));
    }

    public Optional<ErrorTargetEntry> getErrorNavigationTarget(Exception exception) {
        Optional<ErrorTargetEntry> result;
        if (this.getConfiguration().getExceptionHandlers().isEmpty()) {
            this.initErrorTargets(new HashMap<Class<? extends Exception>, Class<? extends Component>>());
        }
        if (!(result = this.searchByCause(exception)).isPresent()) {
            result = this.searchBySuperType(exception);
        }
        return result;
    }

    @Override
    public Optional<Class<? extends Component>> getNavigationTarget(String pathString) {
        Objects.requireNonNull(pathString, "pathString must not be null.");
        return this.getNavigationTarget(pathString, Collections.emptyList());
    }

    @Override
    public Optional<Class<? extends Component>> getNavigationTarget(String pathString, List<String> segments) {
        if (this.getConfiguration().hasRoute(pathString, segments)) {
            return this.getConfiguration().getRoute(pathString, segments);
        }
        return Optional.empty();
    }

    public boolean hasNavigationTargets() {
        return !this.getConfiguration().getRoutes().isEmpty();
    }

    public Class<?> getPwaConfigurationClass() {
        return this.pwaConfigurationClass.get();
    }

    public void setPwaConfigurationClass(Class<?> pwaClass) {
        if (pwaClass != null && pwaClass.isAnnotationPresent(PWA.class)) {
            this.pwaConfigurationClass.set(pwaClass);
        }
    }

    protected void handleInitializedRegistry() {
        throw new IllegalStateException("Route registry has been already initialized");
    }

    private void initErrorTargets(Map<Class<? extends Exception>, Class<? extends Component>> map) {
        if (!map.containsKey(NotFoundException.class)) {
            map.put(NotFoundException.class, RouteNotFoundError.class);
        }
        if (!map.containsKey(Exception.class)) {
            map.put(Exception.class, InternalServerError.class);
        }
        this.configure(configuration -> map.forEach(configuration::setErrorRoute));
    }

    private static ApplicationRouteRegistry createRegistry(VaadinContext context) {
        if (context != null && ((VaadinServletContext)context).getContext() == OSGiAccess.getInstance().getOsgiServletContext()) {
            return new OSGiDataCollector();
        }
        if (OSGiAccess.getInstance().getOsgiServletContext() == null) {
            return new ApplicationRouteRegistry();
        }
        OSGiRouteRegistry osgiRouteRegistry = new OSGiRouteRegistry();
        OSGiDataCollector osgiDataCollector = (OSGiDataCollector)ApplicationRouteRegistry.getInstance(new VaadinServletContext(OSGiAccess.getInstance().getOsgiServletContext()));
        osgiRouteRegistry.setRoutes(osgiDataCollector.getRegisteredRoutes());
        osgiRouteRegistry.subscribeToChanges(osgiDataCollector);
        return osgiRouteRegistry;
    }

    protected static class ApplicationRouteRegistryWrapper
    implements Serializable {
        private final ApplicationRouteRegistry registry;

        public ApplicationRouteRegistryWrapper(ApplicationRouteRegistry registry) {
            this.registry = registry;
        }

        public ApplicationRouteRegistry getRegistry() {
            return this.registry;
        }
    }

    private static class OSGiDataCollector
    extends ApplicationRouteRegistry {
        private static final String REMOVE_ROUTE_IS_NOT_SUPPORTED_MESSAGE = "removeRoute is not supported in OSGiDataCollector";
        private AtomicReference<Set<Class<? extends Component>>> errorNavigationTargets = new AtomicReference();

        private OSGiDataCollector() {
        }

        @Override
        protected void handleInitializedRegistry() {
        }

        @Override
        public void setErrorNavigationTargets(Set<Class<? extends Component>> errorNavigationTargets) {
            if (errorNavigationTargets.isEmpty() && this.errorNavigationTargets.get() == null) {
                return;
            }
            this.errorNavigationTargets.set(errorNavigationTargets);
        }

        @Override
        public void removeRoute(Class<? extends Component> routeTarget) {
            throw new UnsupportedOperationException(REMOVE_ROUTE_IS_NOT_SUPPORTED_MESSAGE);
        }

        @Override
        public void removeRoute(String path) {
            throw new UnsupportedOperationException(REMOVE_ROUTE_IS_NOT_SUPPORTED_MESSAGE);
        }

        @Override
        public void removeRoute(String path, Class<? extends Component> navigationTarget) {
            throw new UnsupportedOperationException(REMOVE_ROUTE_IS_NOT_SUPPORTED_MESSAGE);
        }
    }

    private static class OSGiRouteRegistry
    extends ApplicationRouteRegistry {
        private List<Registration> subscribingRegistrations = new CopyOnWriteArrayList<Registration>();

        private OSGiRouteRegistry() {
        }

        @Override
        public Class<?> getPwaConfigurationClass() {
            this.initPwa();
            return super.getPwaConfigurationClass();
        }

        @Override
        public Optional<ErrorTargetEntry> getErrorNavigationTarget(Exception exception) {
            this.initErrorTargets();
            return super.getErrorNavigationTarget(exception);
        }

        private void initErrorTargets() {
            if (!this.getConfiguration().getExceptionHandlers().isEmpty()) {
                return;
            }
            ServletContext osgiServletContext = OSGiAccess.getInstance().getOsgiServletContext();
            if (osgiServletContext == null || !OSGiAccess.getInstance().hasInitializers()) {
                return;
            }
            OSGiDataCollector registry = (OSGiDataCollector)OSGiRouteRegistry.getInstance(new VaadinServletContext(osgiServletContext));
            if (registry.errorNavigationTargets.get() != null) {
                this.setErrorNavigationTargets((Set)registry.errorNavigationTargets.get());
            }
        }

        private void initPwa() {
            if (this.getConfiguration().getRoutes().isEmpty()) {
                return;
            }
            if (OSGiAccess.getInstance().hasInitializers()) {
                OSGiDataCollector registry = (OSGiDataCollector)OSGiRouteRegistry.getInstance(new VaadinServletContext(OSGiAccess.getInstance().getOsgiServletContext()));
                this.setPwaConfigurationClass(registry.getPwaConfigurationClass());
            }
        }

        private void subscribeToChanges(RouteRegistry routeRegistry) {
            this.subscribingRegistrations.add(routeRegistry.addRoutesChangeListener(event -> this.update(() -> this.applyChange(event))));
        }

        private void applyChange(RoutesChangedEvent event) {
            RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry(this);
            event.getRemovedRoutes().forEach(routeBaseData -> routeConfiguration.removeRoute(routeBaseData.getUrl(), routeBaseData.getNavigationTarget()));
            event.getAddedRoutes().forEach(routeBaseData -> routeConfiguration.setRoute(routeBaseData.getUrl(), routeBaseData.getNavigationTarget(), routeBaseData.getParentLayouts()));
        }

        private void setRoutes(List<RouteData> routes) {
            routes.forEach(routeData -> {
                this.setRoute(routeData.getUrl(), routeData.getNavigationTarget(), routeData.getParentLayouts());
                routeData.getRouteAliases().forEach(routeAliasData -> this.setRoute(routeAliasData.getUrl(), routeAliasData.getNavigationTarget(), routeAliasData.getParentLayouts()));
            });
        }
    }
}

