/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.server.frontend.FrontendToolsLocator;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.frontend.installer.InstallationException;
import com.vaadin.flow.server.frontend.installer.NodeInstaller;
import com.vaadin.flow.server.frontend.installer.ProxyConfig;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendTools {
    private static final String DEFAULT_NODE_VERSION = "v12.16.0";
    public static final String DEFAULT_PNPM_VERSION = "4.5.0";
    public static final String INSTALL_NODE_LOCALLY = "%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v12.14.0\" ";
    private static final String MSG_PREFIX = "%n%n======================================================================================================";
    private static final String MSG_SUFFIX = "%n======================================================================================================%n";
    private static final String NODE_NOT_FOUND = "%n%n======================================================================================================%nVaadin requires node.js & npm to be installed. Please install the latest LTS version of node.js (with npm) either by:%n  1) following the https://nodejs.org/en/download/ guide to install it globally. This is the recommended way.%n  2) running the following Maven plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v12.14.0\" %n%nNote that in case you don't install it globally, you'll need to install it again for another Vaadin project.%nIn case you have just installed node.js globally, it was not discovered, so you need to restart your system to get the path variables updated.%n======================================================================================================%n";
    private static final String LOCAL_NODE_NOT_FOUND = "%n%n======================================================================================================%nVaadin requires node.js & npm to be installed. The %s directory already contains 'node' but it's either not a file or not a 'node' executable. Please check %s directory and clean up it: remove '%s'.%n then please run the app or maven goal again.%n======================================================================================================%n";
    private static final String BAD_VERSION = "%n%n======================================================================================================%nYour installed '%s' version (%s) is known to have problems.%nPlease update to a new one either:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%s%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v12.14.0\" %n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    private static final List<FrontendVersion> NPM_BLACKLISTED_VERSIONS = Arrays.asList(new FrontendVersion("6.11.0"), new FrontendVersion("6.11.1"), new FrontendVersion("6.11.2"));
    private static final String PNMP_INSTALLED_BY_NPM_FOLDER = "node_modules/pnpm/";
    private static final String PNMP_INSTALLED_BY_NPM = "node_modules/pnpm/bin/pnpm.js";
    private static final int SUPPORTED_NODE_MAJOR_VERSION = 10;
    private static final int SUPPORTED_NODE_MINOR_VERSION = 0;
    private static final int SUPPORTED_NPM_MAJOR_VERSION = 5;
    private static final int SUPPORTED_NPM_MINOR_VERSION = 6;
    private static final int SHOULD_WORK_NODE_MAJOR_VERSION = 8;
    private static final int SHOULD_WORK_NODE_MINOR_VERSION = 9;
    private static final int SHOULD_WORK_NPM_MAJOR_VERSION = 5;
    private static final int SHOULD_WORK_NPM_MINOR_VERSION = 5;
    public static final int SUPPORTED_PNPM_MAJOR_VERSION = 4;
    public static final int SUPPORTED_PNPM_MINOR_VERSION = 4;
    private static final int BREAKING_PNPM_MAJOR_VERSION = 4;
    private static final int BREAKING_PNPM_MINOR_VERSION = 6;
    private static final FrontendVersion SUPPORTED_NODE_VERSION = new FrontendVersion(10, 0);
    private static final FrontendVersion SHOULD_WORK_NODE_VERSION = new FrontendVersion(8, 9);
    private static final FrontendVersion SUPPORTED_NPM_VERSION = new FrontendVersion(5, 6);
    private static final FrontendVersion SHOULD_WORK_NPM_VERSION = new FrontendVersion(5, 5);
    static final String NPMRC_NOPROXY_PROPERTY_KEY = "noproxy";
    static final String NPMRC_HTTPS_PROXY_PROPERTY_KEY = "https-proxy";
    static final String NPMRC_PROXY_PROPERTY_KEY = "proxy";
    static final String SYSTEM_NOPROXY_PROPERTY_KEY = "NOPROXY";
    static final String SYSTEM_HTTPS_PROXY_PROPERTY_KEY = "HTTPS_PROXY";
    static final String SYSTEM_HTTP_PROXY_PROPERTY_KEY = "HTTP_PROXY";
    private static final FrontendVersion SUPPORTED_PNPM_VERSION = new FrontendVersion(4, 4);
    private static final FrontendVersion BREAKING_PNPM_VERSION = new FrontendVersion(4, 6);
    private final String baseDir;
    private final Supplier<String> alternativeDirGetter;
    private final FrontendToolsLocator frontendToolsLocator = new FrontendToolsLocator();

    public FrontendTools(String baseDir, Supplier<String> alternativeDirGetter) {
        this.baseDir = Objects.requireNonNull(baseDir);
        this.alternativeDirGetter = alternativeDirGetter;
    }

    public String getNodeExecutable() {
        Pair<String, String> nodeCommands = this.getNodeCommands();
        return this.getExecutable(nodeCommands.getFirst(), nodeCommands.getSecond(), this.alternativeDirGetter != null).getAbsolutePath();
    }

    public String forceAlternativeNodeExecutable() {
        Pair<String, String> nodeCommands = this.getNodeCommands();
        String dir = this.getAlternativeDir();
        File file = new File(dir, nodeCommands.getSecond());
        if (file.exists()) {
            if (!this.frontendToolsLocator.verifyTool(file)) {
                throw new IllegalStateException(String.format(LOCAL_NODE_NOT_FOUND, dir, dir, file.getAbsolutePath()));
            }
            return file.getAbsolutePath();
        }
        this.getLogger().info("Node not found in {}. Installing node {}.", (Object)dir, (Object)DEFAULT_NODE_VERSION);
        return this.installNode(DEFAULT_NODE_VERSION, null);
    }

    public List<String> getNpmExecutable() {
        return this.getNpmExecutable(true);
    }

    public List<String> getPnpmExecutable() {
        Supplier<List<String>> result = this.doEnsurePnpm();
        List<String> pnpmCommand = result.get();
        if (!pnpmCommand.isEmpty()) {
            pnpmCommand.add("--shamefully-hoist=true");
        }
        return pnpmCommand;
    }

    public void ensurePnpm() {
        this.doEnsurePnpm();
    }

    public void validateNodeAndNpmVersion() {
        try {
            ArrayList<String> nodeVersionCommand = new ArrayList<String>();
            nodeVersionCommand.add(this.getNodeExecutable());
            nodeVersionCommand.add("--version");
            FrontendVersion nodeVersion = FrontendUtils.getVersion("node", nodeVersionCommand);
            FrontendUtils.validateToolVersion("node", nodeVersion, SUPPORTED_NODE_VERSION, SHOULD_WORK_NODE_VERSION);
        }
        catch (FrontendUtils.UnknownVersionException e) {
            this.getLogger().warn("Error checking if node is new enough", (Throwable)e);
        }
        try {
            ArrayList<String> npmVersionCommand = new ArrayList<String>(this.getNpmExecutable(false));
            npmVersionCommand.add("--version");
            FrontendVersion npmVersion = FrontendUtils.getVersion("npm", npmVersionCommand);
            FrontendUtils.validateToolVersion("npm", npmVersion, SUPPORTED_NPM_VERSION, SHOULD_WORK_NPM_VERSION);
            this.checkForFaultyNpmVersion(npmVersion);
        }
        catch (FrontendUtils.UnknownVersionException e) {
            this.getLogger().warn("Error checking if npm is new enough", (Throwable)e);
        }
    }

    public List<String> getBowerExecutable() {
        File file = new File(this.baseDir, "node_modules/bower/bin/bower");
        if (file.canRead()) {
            return Arrays.asList(this.getNodeExecutable(), file.getAbsolutePath());
        }
        String command = FrontendUtils.isWindows() ? "bower.cmd" : "bower";
        return this.frontendToolsLocator.tryLocateTool(command).map(File::getPath).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    protected List<String> getPnpmExecutable(String dir, boolean failOnAbsence) {
        ArrayList<String> returnCommand = new ArrayList<String>();
        Optional<File> localPnpmScript = this.getLocalPnpmScript(dir);
        if (localPnpmScript.isPresent()) {
            returnCommand.add(this.getNodeExecutable());
            returnCommand.add(localPnpmScript.get().getAbsolutePath());
        } else {
            String command;
            String string = command = FrontendUtils.isWindows() ? "pnpm.cmd" : "pnpm";
            if (failOnAbsence) {
                returnCommand.add(this.getExecutable(command, null, false).getAbsolutePath());
            } else {
                returnCommand.addAll(this.frontendToolsLocator.tryLocateTool(command).map(File::getPath).map(Collections::singletonList).orElse(Collections.emptyList()));
            }
        }
        return returnCommand;
    }

    protected String installNode(String nodeVersion, URI downloadRoot) {
        NodeInstaller nodeInstaller = new NodeInstaller(new File(this.getAlternativeDir()), this.getProxies()).setNodeVersion(nodeVersion);
        if (downloadRoot != null) {
            nodeInstaller.setNodeDownloadRoot(downloadRoot);
        }
        try {
            nodeInstaller.install();
        }
        catch (InstallationException e) {
            throw new IllegalStateException("Failed to install Node", e);
        }
        return new File(nodeInstaller.getInstallDirectory(), this.getNodeCommands().getFirst()).toString();
    }

    protected List<ProxyConfig.Proxy> getProxies() {
        File projectNpmrc = new File(this.baseDir, ".npmrc");
        File userNpmrc = new File(FileUtils.getUserDirectory(), ".npmrc");
        ArrayList<ProxyConfig.Proxy> proxyList = new ArrayList<ProxyConfig.Proxy>();
        proxyList.addAll(this.readProxySettingsFromSystemProperties());
        proxyList.addAll(this.readProxySettingsFromNpmrcFile("project .npmrc", projectNpmrc));
        proxyList.addAll(this.readProxySettingsFromNpmrcFile("user .npmrc", userNpmrc));
        proxyList.addAll(this.readProxySettingsFromEnvironmentVariables());
        return proxyList;
    }

    void checkForFaultyNpmVersion(FrontendVersion npmVersion) {
        if (NPM_BLACKLISTED_VERSIONS.contains(npmVersion)) {
            String badNpmVersion = this.buildBadVersionString("npm", npmVersion.getFullVersion(), "by updating your global npm installation with `npm install -g npm@latest`");
            throw new IllegalStateException(badNpmVersion);
        }
    }

    private List<String> ensurePnpm(String dir) {
        List<String> pnpm = this.getSuitablePnpm(dir);
        if (pnpm.isEmpty()) {
            File packageJson = new File(dir, "package.json");
            File tempFile = null;
            boolean packageJsonExists = packageJson.canRead();
            if (packageJsonExists) {
                try {
                    tempFile = File.createTempFile("package", "json");
                    FileUtils.copyFile((File)packageJson, (File)tempFile);
                }
                catch (IOException exception) {
                    throw new IllegalStateException("Couldn't make a copy of package.json file", exception);
                }
                packageJson.delete();
            }
            try {
                JsonObject pkgJson = Json.createObject();
                pkgJson.put("name", "temp");
                pkgJson.put("license", "UNLICENSED");
                pkgJson.put("repository", "npm/npm");
                pkgJson.put("description", "Temporary package for pnpm installation");
                FileUtils.writeLines((File)packageJson, Collections.singletonList(pkgJson.toJson()));
                JsonObject lockJson = Json.createObject();
                lockJson.put("lockfileVersion", 1.0);
                FileUtils.writeLines((File)new File(dir, "package-lock.json"), Collections.singletonList(lockJson.toJson()));
            }
            catch (IOException e) {
                this.getLogger().warn("Couldn't create temporary package.json");
            }
            this.installPnpm(dir, this.getNpmExecutable(false));
            new File(dir, "package-lock.json").delete();
            if (packageJsonExists && tempFile != null) {
                try {
                    FileUtils.copyFile((File)tempFile, (File)packageJson);
                }
                catch (IOException exception) {
                    throw new IllegalStateException("Couldn't restore package.json file back", exception);
                }
                tempFile.delete();
            }
            return Collections.emptyList();
        }
        return pnpm;
    }

    private File getExecutable(String cmd, String defaultLocation, boolean installNode) {
        File file = null;
        file = defaultLocation == null ? (File)this.frontendToolsLocator.tryLocateTool(cmd).orElse(null) : Arrays.asList(() -> this.baseDir, this.alternativeDirGetter).stream().map(Supplier::get).map(dir -> new File((String)dir, defaultLocation)).filter(this.frontendToolsLocator::verifyTool).findFirst().orElseGet(() -> this.frontendToolsLocator.tryLocateTool(cmd).orElse(null));
        if (file == null && installNode) {
            this.getLogger().info("Couldn't find {}. Installing Node and NPM to {}.", (Object)cmd, (Object)this.getAlternativeDir());
            return new File(this.installNode(DEFAULT_NODE_VERSION, null));
        }
        if (file == null) {
            throw new IllegalStateException(String.format(NODE_NOT_FOUND, new Object[0]));
        }
        return file;
    }

    private Pair<String, String> getNodeCommands() {
        if (FrontendUtils.isWindows()) {
            return new Pair<String, String>("node.exe", "node/node.exe");
        }
        return new Pair<String, String>("node", "node/node");
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(FrontendTools.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ProxyConfig.Proxy> readProxySettingsFromNpmrcFile(String fileDescription, File npmrc) {
        if (!npmrc.exists()) {
            return Collections.emptyList();
        }
        try (FileReader fileReader = new FileReader(npmrc);){
            String proxyUrl;
            String httpsProxyUrl;
            ArrayList<ProxyConfig.Proxy> proxyList = new ArrayList<ProxyConfig.Proxy>(2);
            Properties properties = new Properties();
            properties.load(fileReader);
            String noproxy = properties.getProperty(NPMRC_NOPROXY_PROPERTY_KEY);
            if (noproxy != null) {
                noproxy = noproxy.replaceAll(",", "|");
            }
            if ((httpsProxyUrl = properties.getProperty(NPMRC_HTTPS_PROXY_PROPERTY_KEY)) != null) {
                proxyList.add(new ProxyConfig.Proxy("https-proxy - " + fileDescription, httpsProxyUrl, noproxy));
            }
            if ((proxyUrl = properties.getProperty(NPMRC_PROXY_PROPERTY_KEY)) != null) {
                proxyList.add(new ProxyConfig.Proxy("proxy - " + fileDescription, proxyUrl, noproxy));
            }
            ArrayList<ProxyConfig.Proxy> arrayList = proxyList;
            return arrayList;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private List<ProxyConfig.Proxy> readProxySettingsFromSystemProperties() {
        String proxyUrl;
        String httpsProxyUrl;
        ArrayList<ProxyConfig.Proxy> proxyList = new ArrayList<ProxyConfig.Proxy>(2);
        String noproxy = this.getNonNull(System.getProperty(SYSTEM_NOPROXY_PROPERTY_KEY), System.getProperty(SYSTEM_NOPROXY_PROPERTY_KEY.toLowerCase()));
        if (noproxy != null) {
            noproxy = noproxy.replaceAll(",", "|");
        }
        if ((httpsProxyUrl = this.getNonNull(System.getProperty(SYSTEM_HTTPS_PROXY_PROPERTY_KEY), System.getProperty(SYSTEM_HTTPS_PROXY_PROPERTY_KEY.toLowerCase()))) != null) {
            proxyList.add(new ProxyConfig.Proxy("https-proxy - system", httpsProxyUrl, noproxy));
        }
        if ((proxyUrl = this.getNonNull(System.getProperty(SYSTEM_HTTP_PROXY_PROPERTY_KEY), System.getProperty(SYSTEM_HTTP_PROXY_PROPERTY_KEY.toLowerCase()))) != null) {
            proxyList.add(new ProxyConfig.Proxy("proxy - system", proxyUrl, noproxy));
        }
        return proxyList;
    }

    private List<ProxyConfig.Proxy> readProxySettingsFromEnvironmentVariables() {
        String proxyUrl;
        String httpsProxyUrl;
        ArrayList<ProxyConfig.Proxy> proxyList = new ArrayList<ProxyConfig.Proxy>(2);
        String noproxy = this.getNonNull(System.getenv(SYSTEM_NOPROXY_PROPERTY_KEY), System.getenv(SYSTEM_NOPROXY_PROPERTY_KEY.toLowerCase()));
        if (noproxy != null) {
            noproxy = noproxy.replaceAll(",", "|");
        }
        if ((httpsProxyUrl = this.getNonNull(System.getenv(SYSTEM_HTTPS_PROXY_PROPERTY_KEY), System.getenv(SYSTEM_HTTPS_PROXY_PROPERTY_KEY.toLowerCase()))) != null) {
            proxyList.add(new ProxyConfig.Proxy("https-proxy - env", httpsProxyUrl, noproxy));
        }
        if ((proxyUrl = this.getNonNull(System.getenv(SYSTEM_HTTP_PROXY_PROPERTY_KEY), System.getenv(SYSTEM_HTTP_PROXY_PROPERTY_KEY.toLowerCase()))) != null) {
            proxyList.add(new ProxyConfig.Proxy("proxy - env", proxyUrl, noproxy));
        }
        return proxyList;
    }

    private String getNonNull(String ... valueArray) {
        for (String value : valueArray) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private Supplier<List<String>> doEnsurePnpm() {
        List<String> path = this.getSuitablePnpm(this.baseDir);
        if (!path.isEmpty()) {
            return () -> path;
        }
        String alternativeDir = this.getAlternativeDir();
        List<String> pnpm = this.ensurePnpm(alternativeDir);
        if (pnpm.isEmpty()) {
            return () -> this.getPnpmExecutable(alternativeDir, true);
        }
        return () -> pnpm;
    }

    private List<String> getNpmExecutable(boolean removePnpmLock) {
        List<String> returnCommand = this.getNpmScriptCommand(this.baseDir);
        if (returnCommand.isEmpty()) {
            returnCommand = this.getNpmScriptCommand(this.getAlternativeDir());
        }
        if (returnCommand.isEmpty()) {
            String command = FrontendUtils.isWindows() ? "npm.cmd" : "npm";
            returnCommand.add(this.getExecutable(command, null, true).getAbsolutePath());
        }
        returnCommand.add("--no-update-notifier");
        returnCommand.add("--no-audit");
        if (removePnpmLock && new File(this.baseDir, "pnpm-lock.yaml").delete()) {
            this.getLogger().debug("pnpm-lock.yaml file is removed from " + this.baseDir);
        }
        return returnCommand;
    }

    private List<String> getNpmScriptCommand(String dir) {
        File file = new File(dir, "node/node_modules/npm/bin/npm-cli.js");
        ArrayList<String> returnCommand = new ArrayList<String>();
        if (file.canRead()) {
            returnCommand.add(this.getNodeExecutable());
            returnCommand.add(file.getAbsolutePath());
        }
        return returnCommand;
    }

    private List<String> getSuitablePnpm(String dir) {
        List<String> pnpmCommand = this.getPnpmExecutable(dir, false);
        if (!pnpmCommand.isEmpty()) {
            try {
                ArrayList<String> versionCmd = new ArrayList<String>(pnpmCommand);
                versionCmd.add("--version");
                FrontendVersion pnpmVersion = FrontendUtils.getVersion("pnpm", versionCmd);
                if (FrontendUtils.isVersionAtLeast(pnpmVersion, SUPPORTED_PNPM_VERSION) && pnpmVersion.isOlderThan(BREAKING_PNPM_VERSION)) {
                    return pnpmCommand;
                }
                this.getLogger().warn(String.format("installed pnpm ('%s', version %s) is not in the compatible versions range (>=%s, <%s), installing supported version locally", String.join((CharSequence)" ", pnpmCommand), pnpmVersion.getFullVersion(), SUPPORTED_PNPM_VERSION.getFullVersion(), BREAKING_PNPM_VERSION.getFullVersion()));
            }
            catch (FrontendUtils.UnknownVersionException e) {
                this.getLogger().warn("Error checking pnpm version, installing pnpm locally", (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installPnpm(String dir, List<String> installCommand) {
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(installCommand);
        command.add("install");
        command.add("pnpm@4.5.0");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(FrontendUtils.commandToString(this.baseDir, command));
        }
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        builder.environment().put("ADBLOCK", "1");
        builder.directory(new File(dir));
        builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        Process process = null;
        try {
            process = builder.start();
            this.getLogger().debug("Output of `{}`:", (Object)command.stream().collect(Collectors.joining(" ")));
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String stdoutLine;
                while ((stdoutLine = reader.readLine()) != null) {
                    this.getLogger().debug(stdoutLine);
                }
            }
            int errorCode = process.waitFor();
            if (errorCode != 0) {
                this.getLogger().error("Couldn't install 'pnpm'");
            } else {
                this.getLogger().debug("Pnpm is successfully installed");
            }
        }
        catch (IOException | InterruptedException e) {
            this.getLogger().error("Error when running `npm install`", (Throwable)e);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }

    private Optional<File> getLocalPnpmScript(String dir) {
        File npmInstalled = new File(dir, PNMP_INSTALLED_BY_NPM);
        if (npmInstalled.canRead()) {
            return Optional.of(npmInstalled);
        }
        File movedPnpmScript = new File(dir, "node_modules/.ignored_pnpm/bin/pnpm.js");
        if (movedPnpmScript.canRead()) {
            return Optional.of(movedPnpmScript);
        }
        movedPnpmScript = new File(dir, "node_modules/.ignored/pnpm/bin/pnpm.js");
        if (movedPnpmScript.canRead()) {
            return Optional.of(movedPnpmScript);
        }
        return Optional.empty();
    }

    private String buildBadVersionString(String tool, String version, String ... extraUpdateInstructions) {
        StringBuilder extraInstructions = new StringBuilder();
        for (String instruction : extraUpdateInstructions) {
            extraInstructions.append("%n  - or ").append(instruction);
        }
        return String.format(BAD_VERSION, tool, version, extraInstructions.toString(), "vaadin.ignoreVersionChecks");
    }

    private String getAlternativeDir() {
        return this.alternativeDirGetter.get();
    }
}

