/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.change;

import com.vaadin.flow.internal.ConstantPool;
import com.vaadin.flow.internal.JsonCodec;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.AbstractListChange;
import com.vaadin.flow.internal.nodefeature.NodeList;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class ListAddChange<T extends Serializable>
extends AbstractListChange<T> {
    private final List<? extends T> newItems;
    private final boolean nodeValues;

    public ListAddChange(NodeList<T> list, boolean nodeValues, int index, List<? extends T> newItems) {
        super(list, index);
        this.newItems = newItems;
        this.nodeValues = nodeValues;
    }

    public List<T> getNewItems() {
        return Collections.unmodifiableList(this.newItems);
    }

    public boolean isEmpty() {
        return this.newItems.isEmpty();
    }

    public ListAddChange<T> copy(List<? extends T> items) {
        return new ListAddChange<T>(this.getNodeList(), this.nodeValues, this.getIndex(), items);
    }

    @Override
    public ListAddChange<T> copy(int indx) {
        return new ListAddChange<T>(this.getNodeList(), this.nodeValues, indx, this.newItems);
    }

    @Override
    protected void populateJson(JsonObject json, ConstantPool constantPool) {
        Function<Object, JsonValue> mapper;
        String addKey;
        json.put("type", "splice");
        super.populateJson(json, constantPool);
        json.put("index", (double)this.getIndex());
        if (this.nodeValues) {
            addKey = "addNodes";
            mapper = item -> Json.create((double)((StateNode)item).getId());
        } else {
            addKey = "add";
            mapper = item -> JsonCodec.encodeWithConstantPool(item, constantPool);
        }
        JsonArray newItemsJson = this.newItems.stream().map(mapper).collect(JsonUtils.asArray());
        json.put(addKey, (JsonValue)newItemsJson);
    }
}

