/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.installer;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyConfig {
    private final List<Proxy> proxies;

    public ProxyConfig(List<Proxy> proxies) {
        this.proxies = proxies;
    }

    public boolean isEmpty() {
        return this.proxies.isEmpty();
    }

    public Proxy getProxyForUrl(String requestUrl) {
        if (this.proxies.isEmpty()) {
            ProxyConfig.getLogger().info("No proxies configured");
            return null;
        }
        URI uri = URI.create(requestUrl);
        for (Proxy proxy : this.proxies) {
            if (proxy.isNonProxyHost(uri.getHost())) continue;
            return proxy;
        }
        ProxyConfig.getLogger().info("Could not find matching proxy for host: {}", (Object)uri.getHost());
        return null;
    }

    public Proxy getSecureProxy() {
        for (Proxy proxy : this.proxies) {
            if (!proxy.isSecure()) continue;
            return proxy;
        }
        return null;
    }

    public Proxy getInsecureProxy() {
        for (Proxy proxy : this.proxies) {
            if (proxy.isSecure()) continue;
            return proxy;
        }
        return null;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)"ProxyConfig");
    }

    private static class ProxyConfigException
    extends RuntimeException {
        private ProxyConfigException(String message, Exception cause) {
            super(message, cause);
        }
    }

    public static class Proxy
    implements Serializable {
        private static final Pattern PROXY_URL_REGEX = Pattern.compile("(\\w+)://(([^:]+):(.*)@)?([^:]+)(:(\\d*))?(/)?");
        public final String id;
        public final String protocol;
        public final String host;
        public final int port;
        public final String username;
        public final String password;
        public final String nonProxyHosts;

        public Proxy(String id, String protocol, String host, int port, String username, String password, String nonProxyHosts) {
            this.host = host;
            this.id = id;
            this.protocol = protocol;
            this.port = port;
            this.username = username;
            this.password = password;
            this.nonProxyHosts = nonProxyHosts;
        }

        public Proxy(String id, String proxyUrl, String nonProxyHosts) {
            Matcher matcher = PROXY_URL_REGEX.matcher(proxyUrl);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Provided proxyUrl does not match the format protocol://user:password@server:port nor protocol://server:port");
            }
            this.id = id;
            this.protocol = matcher.group(1);
            this.username = matcher.group(3);
            this.password = matcher.group(4);
            this.host = matcher.group(5);
            this.port = Integer.parseInt(matcher.group(7));
            this.nonProxyHosts = nonProxyHosts;
        }

        public boolean useAuthentication() {
            return this.username != null && !this.username.isEmpty();
        }

        public URI getUri() {
            String authentication = this.useAuthentication() ? this.username + ":" + this.password : null;
            try {
                return new URI("http", authentication, this.host, this.port, null, null, null);
            }
            catch (URISyntaxException e) {
                throw new ProxyConfigException("Invalid proxy settings", e);
            }
        }

        public boolean isSecure() {
            return "https".equals(this.protocol);
        }

        public boolean isNonProxyHost(String host) {
            if (host != null && this.nonProxyHosts != null && this.nonProxyHosts.length() > 0) {
                StringTokenizer tokenizer = new StringTokenizer(this.nonProxyHosts, "|");
                while (tokenizer.hasMoreTokens()) {
                    String pattern = tokenizer.nextToken();
                    if (!host.matches(pattern = pattern.replace(".", "\\.").replace("*", ".*"))) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.id + "{protocol='" + this.protocol + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + (this.useAuthentication() ? ", with username/passport authentication" : "") + '}';
        }
    }
}

