/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.osgi;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.server.startup.ClassLoaderAwareServletContainerInitializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.LoggerFactory;

public final class OSGiAccess {
    private static final OSGiAccess INSTANCE = new OSGiAccess();
    private final ServletContext context = LazyOSGiDetector.access$000() ? this.createOSGiServletContext() : null;
    private final AtomicReference<Collection<Class<? extends ServletContainerInitializer>>> initializerClasses = LazyOSGiDetector.access$000() ? new AtomicReference() : null;
    private final Map<Long, Collection<Class<?>>> cachedClasses = LazyOSGiDetector.access$000() ? new ConcurrentHashMap() : null;

    private OSGiAccess() {
    }

    public static OSGiAccess getInstance() {
        return INSTANCE;
    }

    public ServletContext getOsgiServletContext() {
        return this.context;
    }

    public void setServletContainerInitializers(Collection<Class<? extends ServletContainerInitializer>> contextInitializers) {
        assert (contextInitializers != null);
        this.initializerClasses.set(new ArrayList<Class<? extends ServletContainerInitializer>>(contextInitializers));
    }

    public boolean hasInitializers() {
        return this.initializerClasses.get() != null;
    }

    public void addScannedClasses(Map<Long, Collection<Class<?>>> extenderClasses) {
        this.cachedClasses.putAll(extenderClasses);
        this.resetContextInitializers();
    }

    public void removeScannedClasses(Long bundleId) {
        this.cachedClasses.remove(bundleId);
        this.resetContextInitializers();
    }

    private void resetContextInitializers() {
        this.initializerClasses.get().stream().map(ReflectTools::createInstance).forEach(this::handleTypes);
    }

    private void handleTypes(ServletContainerInitializer initializer) {
        Optional<HandlesTypes> handleTypes = AnnotationReader.getAnnotationFor(initializer.getClass(), HandlesTypes.class);
        assert (initializer instanceof ClassLoaderAwareServletContainerInitializer);
        try {
            ((ClassLoaderAwareServletContainerInitializer)initializer).process(this.filterClasses(handleTypes.orElse(null)), this.getOsgiServletContext());
        }
        catch (ServletException e) {
            throw new RuntimeException("Couldn't run servlet context initializer " + initializer.getClass(), e);
        }
    }

    private Set<Class<?>> filterClasses(HandlesTypes typesAnnotation) {
        HashSet result = new HashSet();
        if (typesAnnotation == null) {
            this.cachedClasses.forEach((bundle, classes) -> result.addAll((Collection<Class<?>>)classes));
        } else {
            Class[] requestedTypes = typesAnnotation.value();
            Predicate<Class> isAnnotation = Class::isAnnotation;
            List annotations = Stream.of(requestedTypes).filter(isAnnotation).map(clazz -> clazz).collect(Collectors.toList());
            List superTypes = Stream.of(requestedTypes).filter(isAnnotation.negate()).collect(Collectors.toList());
            Predicate<Class> hasType = clazz -> annotations.stream().anyMatch(annotation -> AnnotationReader.getAnnotationFor(clazz, annotation).isPresent()) || superTypes.stream().anyMatch(superType -> GenericTypeReflector.isSuperType(HasErrorParameter.class, (Type)clazz));
            this.cachedClasses.forEach((bundle, classes) -> result.addAll(classes.stream().filter(hasType).collect(Collectors.toList())));
        }
        return result;
    }

    private ServletContext createOSGiServletContext() {
        DynamicType.Builder builder = new ByteBuddy().subclass(OSGiServletContext.class);
        Class osgiServletContextClass = builder.make().load(OSGiServletContext.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded();
        return (ServletContext)ReflectTools.createProxyInstance(osgiServletContextClass, ServletContext.class);
    }

    private static final class LazyOSGiDetector {
        private static final boolean IS_IN_OSGI = LazyOSGiDetector.isInOSGi();

        private LazyOSGiDetector() {
        }

        private static boolean isInOSGi() {
            try {
                Class.forName("org.osgi.framework.FrameworkUtil");
                UsageStatistics.markAsUsed("flow/osgi", LazyOSGiDetector.getOSGiVersion());
                return true;
            }
            catch (ClassNotFoundException exception) {
                return false;
            }
        }

        private static String getOSGiVersion() {
            try {
                Bundle osgiBundle = FrameworkUtil.getBundle(Bundle.class);
                return osgiBundle.getVersion().toString();
            }
            catch (Throwable throwable) {
                LoggerFactory.getLogger(OSGiAccess.class).info("Unable to detect used OSGi framework version due to " + throwable.getMessage());
                return null;
            }
        }

        static /* synthetic */ boolean access$000() {
            return IS_IN_OSGI;
        }
    }

    public static abstract class OSGiServletContext
    implements ServletContext {
        private final Map<String, Object> attributes = new HashMap<String, Object>();

        public void setAttribute(String name, Object object) {
            this.attributes.put(name, object);
        }

        public Object getAttribute(String name) {
            return this.attributes.get(name);
        }

        public void log(String msg) {
            LoggerFactory.getLogger(OSGiAccess.class).warn(msg);
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            return Collections.emptyMap();
        }
    }
}

