/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.server.frontend.scanner.AbstractDependenciesScanner;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.ThemeData;
import com.vaadin.flow.server.frontend.scanner.ThemeWrapper;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.NoTheme;
import com.vaadin.flow.theme.Theme;
import com.vaadin.flow.theme.ThemeDefinition;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FullDependenciesScanner
extends AbstractDependenciesScanner {
    private static final String COULD_NOT_LOAD_ERROR_MSG = "Could not load annotation class ";
    private static final String VALUE = "value";
    private ThemeDefinition themeDefinition;
    private AbstractTheme themeInstance;
    private Set<String> classes = new HashSet<String>();
    private Map<String, String> packages;
    private Set<String> scripts = new LinkedHashSet<String>();
    private Set<CssData> cssData;
    private List<String> modules;
    private final Class<?> abstractTheme;
    private final SerializableBiFunction<Class<?>, Class<? extends Annotation>, List<? extends Annotation>> annotationFinder;

    FullDependenciesScanner(ClassFinder finder) {
        this(finder, AnnotationReader::getAnnotationsFor);
    }

    FullDependenciesScanner(ClassFinder finder, SerializableBiFunction<Class<?>, Class<? extends Annotation>, List<? extends Annotation>> annotationFinder) {
        super(finder);
        long start = System.currentTimeMillis();
        this.annotationFinder = annotationFinder;
        try {
            this.abstractTheme = finder.loadClass(AbstractTheme.class.getName());
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("Could not load " + AbstractTheme.class.getName() + " class", exception);
        }
        this.packages = this.discoverPackages();
        HashMap<String, Set<String>> themeModules = new HashMap<String, Set<String>>();
        LinkedHashSet<String> regularModules = new LinkedHashSet<String>();
        this.collectAnnotationValues((clazz, module) -> this.handleModule((Class<?>)clazz, (String)module, (Set<String>)regularModules, (Map<String, Set<String>>)themeModules), JsModule.class, module -> this.invokeAnnotationMethodAsString((Annotation)module, VALUE));
        this.collectAnnotationValues((clazz, script) -> {
            this.classes.add(clazz.getName());
            this.scripts.add((String)script);
        }, JavaScript.class, module -> this.invokeAnnotationMethodAsString((Annotation)module, VALUE));
        this.cssData = this.discoverCss();
        this.discoverTheme();
        this.modules = this.calculateModules(regularModules, themeModules);
        this.getLogger().info("Visited {} classes. Took {} ms.", (Object)this.getClasses().size(), (Object)(System.currentTimeMillis() - start));
    }

    @Override
    public Map<String, String> getPackages() {
        return Collections.unmodifiableMap(this.packages);
    }

    @Override
    public List<String> getModules() {
        return Collections.unmodifiableList(this.modules);
    }

    @Override
    public Set<String> getScripts() {
        return Collections.unmodifiableSet(this.scripts);
    }

    @Override
    public Set<CssData> getCss() {
        return Collections.unmodifiableSet(this.cssData);
    }

    @Override
    public ThemeDefinition getThemeDefinition() {
        return this.themeDefinition;
    }

    @Override
    public AbstractTheme getTheme() {
        return this.themeInstance;
    }

    @Override
    public Set<String> getClasses() {
        return Collections.unmodifiableSet(this.classes);
    }

    private CssData createCssData(Annotation cssImport) {
        CssData data = new CssData();
        data.id = this.adaptCssValue(cssImport, "id");
        data.include = this.adaptCssValue(cssImport, "include");
        data.themefor = this.adaptCssValue(cssImport, "themeFor");
        data.value = this.adaptCssValue(cssImport, VALUE);
        return data;
    }

    private String adaptCssValue(Annotation cssImport, String method) {
        String value = this.invokeAnnotationMethodAsString(cssImport, method);
        if (value == null) {
            return value;
        }
        return value.isEmpty() ? null : value;
    }

    private Map<String, String> discoverPackages() {
        try {
            Class loadedAnnotation = this.getFinder().loadClass(NpmPackage.class.getName());
            Set<Class<?>> annotatedClasses = this.getFinder().getAnnotatedClasses(loadedAnnotation);
            HashMap<String, String> result = new HashMap<String, String>();
            for (Class<?> clazz : annotatedClasses) {
                this.classes.add(clazz.getName());
                List packageAnnotations = (List)this.annotationFinder.apply(clazz, loadedAnnotation);
                packageAnnotations.forEach(pckg -> result.put(this.invokeAnnotationMethodAsString((Annotation)pckg, VALUE), this.invokeAnnotationMethodAsString((Annotation)pckg, "version")));
            }
            return result;
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException(COULD_NOT_LOAD_ERROR_MSG + NpmPackage.class.getName(), exception);
        }
    }

    private Set<CssData> discoverCss() {
        try {
            Class loadedAnnotation = this.getFinder().loadClass(CssImport.class.getName());
            Set<Class<?>> annotatedClasses = this.getFinder().getAnnotatedClasses(loadedAnnotation);
            LinkedHashSet<CssData> result = new LinkedHashSet<CssData>();
            for (Class<?> clazz : annotatedClasses) {
                this.classes.add(clazz.getName());
                List imports = (List)this.annotationFinder.apply(clazz, loadedAnnotation);
                imports.stream().forEach(imp -> result.add(this.createCssData((Annotation)imp)));
            }
            return result;
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException(COULD_NOT_LOAD_ERROR_MSG + CssData.class.getName(), exception);
        }
    }

    private <T extends Annotation> void collectAnnotationValues(BiConsumer<Class<?>, String> valueHandler, Class<T> annotationType, Function<Annotation, String> valueExtractor) {
        try {
            Class loadedAnnotation = this.getFinder().loadClass(annotationType.getName());
            Set<Class<?>> annotatedClasses = this.getFinder().getAnnotatedClasses(loadedAnnotation);
            annotatedClasses.stream().forEach(clazz -> ((List)this.annotationFinder.apply((Class<?>)clazz, loadedAnnotation)).forEach(ann -> valueHandler.accept((Class<?>)clazz, (String)valueExtractor.apply((Annotation)ann))));
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException(COULD_NOT_LOAD_ERROR_MSG + annotationType.getName(), exception);
        }
    }

    private void discoverTheme() {
        ThemeData data = this.verifyTheme();
        if (data == null) {
            this.setupTheme(this.getLumoTheme(), "");
            return;
        }
        if (data.isNotheme()) {
            return;
        }
        try {
            Class theme = this.getFinder().loadClass(data.name);
            this.setupTheme(theme, data.variant);
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("Could not load theme class " + data.name, exception);
        }
    }

    private void setupTheme(Class<? extends AbstractTheme> theme, String variant) {
        if (theme != null) {
            this.themeDefinition = new ThemeDefinition(theme, variant);
            try {
                this.themeInstance = new ThemeWrapper(theme);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Unable to create a new '" + theme.getName() + "' theme instance", e);
            }
        }
    }

    private ThemeData verifyTheme() {
        try {
            Class loadedThemeAnnotation = this.getFinder().loadClass(Theme.class.getName());
            Set<Class<?>> annotatedClasses = this.getFinder().getAnnotatedClasses(loadedThemeAnnotation);
            Set<ThemeData> themes = annotatedClasses.stream().flatMap(clazz -> ((List)this.annotationFinder.apply((Class<?>)clazz, loadedThemeAnnotation)).stream()).map(theme -> new ThemeData(((Class)this.invokeAnnotationMethod((Annotation)theme, VALUE)).getName(), this.invokeAnnotationMethodAsString((Annotation)theme, "variant"))).collect(Collectors.toSet());
            Class loadedNoThemeAnnotation = this.getFinder().loadClass(NoTheme.class.getName());
            Set notThemeClasses = this.getFinder().getAnnotatedClasses(loadedNoThemeAnnotation).stream().collect(Collectors.toSet());
            if (themes.size() > 1) {
                throw new IllegalStateException("Using multiple different Theme configurations is not supported. The list of found themes:\n" + this.getThemesList(themes));
            }
            if (!themes.isEmpty() && !notThemeClasses.isEmpty()) {
                throw new IllegalStateException("@" + Theme.class.getSimpleName() + " (" + this.getThemesList(themes) + ") and @" + NoTheme.class.getSimpleName() + " annotations can't be used simultaneously.");
            }
            if (!notThemeClasses.isEmpty()) {
                return ThemeData.createNoTheme();
            }
            return themes.isEmpty() ? null : themes.iterator().next();
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("Could not load theme annotation class", exception);
        }
    }

    private String getThemesList(Collection<ThemeData> themes) {
        return themes.stream().map(theme -> "name = '" + theme.getName() + "' and variant = '" + theme.getVariant() + "'").collect(Collectors.joining(", "));
    }

    private void handleModule(Class<?> clazz, String module, Set<String> modules, Map<String, Set<String>> themeModules) {
        if (this.abstractTheme.isAssignableFrom(clazz)) {
            Set themingModules = themeModules.computeIfAbsent(clazz.getName(), cl -> new LinkedHashSet());
            themingModules.add(module);
        } else {
            this.classes.add(clazz.getName());
            modules.add(module);
        }
    }

    private List<String> calculateModules(Set<String> modules, Map<String, Set<String>> themeModules) {
        Set<String> themingModules = themeModules.get(this.getThemeDefinition() == null ? null : this.getThemeDefinition().getTheme().getName());
        if (themingModules == null) {
            return new ArrayList<String>(modules);
        }
        if (this.getThemeDefinition() != null) {
            this.classes.add(this.getThemeDefinition().getTheme().getName());
        }
        ArrayList<String> result = new ArrayList<String>(themingModules.size() + modules.size());
        result.addAll(themingModules);
        result.addAll(modules);
        return result;
    }

    private String invokeAnnotationMethodAsString(Annotation target, String methodName) {
        Object result = this.invokeAnnotationMethod(target, methodName);
        return result == null ? null : result.toString();
    }

    private Object invokeAnnotationMethod(Annotation target, String methodName) {
        try {
            return target.getClass().getDeclaredMethod(methodName, new Class[0]).invoke((Object)target, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(String.format("Failed to access method '%s' in annotation interface '%s', should not be happening due to JLS definition of annotation interface", methodName, target), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(String.format("Got an exception by invoking method '%s' from annotation '%s'", methodName, target), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Annotation '%s' has no method named `%s", target, methodName), e);
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger((String)"dev-updater");
    }
}

