/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeUpdater;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class TaskRunNpmInstall
implements FallibleCommand {
    static final String SKIPPING_NPM_INSTALL = "Skipping `npm install`.";
    private final NodeUpdater packageUpdater;
    private final List<String> ignoredNodeFolders = Arrays.asList(".bin", ".staging");

    TaskRunNpmInstall(NodeUpdater packageUpdater) {
        this.packageUpdater = packageUpdater;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        if (this.packageUpdater.modified || this.shouldRunNpmInstall()) {
            this.packageUpdater.log().info("Running `npm install` to resolve and optionally download frontend dependencies. This may take a moment, please stand by...");
            this.runNpmInstall();
        } else {
            this.packageUpdater.log().info(SKIPPING_NPM_INSTALL);
        }
    }

    private boolean shouldRunNpmInstall() {
        if (this.packageUpdater.nodeModulesFolder.isDirectory()) {
            File[] installedPackages = this.packageUpdater.nodeModulesFolder.listFiles((dir, name) -> !this.ignoredNodeFolders.contains(name));
            assert (installedPackages != null);
            return installedPackages.length == 0 || installedPackages.length == 1 && "@vaadin/flow-frontend/".startsWith(installedPackages[0].getName());
        }
        return true;
    }

    private void runNpmInstall() throws ExecutionFailedException {
        List<String> npmExecutable;
        try {
            npmExecutable = FrontendUtils.getNpmExecutable(this.packageUpdater.npmFolder.getAbsolutePath());
        }
        catch (IllegalStateException exception) {
            throw new ExecutionFailedException(exception.getMessage(), exception);
        }
        ArrayList<String> command = new ArrayList<String>(npmExecutable);
        command.add("install");
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        builder.environment().put("ADBLOCK", "1");
        builder.directory(this.packageUpdater.npmFolder);
        builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        String commandString = command.stream().collect(Collectors.joining(" "));
        Process process = null;
        try {
            process = builder.start();
            this.packageUpdater.log().debug("Output of `{}`:", (Object)commandString);
            StringBuilder toolOutput = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String stdoutLine;
                while ((stdoutLine = reader.readLine()) != null) {
                    this.packageUpdater.log().debug(stdoutLine);
                    toolOutput.append(stdoutLine);
                }
            }
            int errorCode = process.waitFor();
            if (errorCode != 0) {
                this.packageUpdater.log().error("Command `{}` failed:\n{}", (Object)commandString, (Object)toolOutput);
                this.packageUpdater.log().error(">>> Dependency ERROR. Check that all required dependencies are deployed in npm repositories.");
                throw new ExecutionFailedException("Npm install has exited with non zero status. Some dependencies are not installed. Check npm command output");
            }
            this.packageUpdater.log().info("Frontend dependencies resolved successfully.");
        }
        catch (IOException | InterruptedException e) {
            this.packageUpdater.log().error("Error when running `npm install`", (Throwable)e);
            throw new ExecutionFailedException("Command 'npm install' failed to finish", e);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }
}

