/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom.impl;

import com.vaadin.flow.dom.ElementUtil;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.dom.StyleUtil;
import com.vaadin.flow.internal.nodefeature.ElementStylePropertyMap;
import java.io.Serializable;
import java.util.stream.Stream;

public class BasicElementStyle
implements Style {
    private ElementStylePropertyMap propertyMap;

    public BasicElementStyle(ElementStylePropertyMap propertyMap) {
        this.propertyMap = propertyMap;
    }

    @Override
    public Style set(String name, String value) {
        ElementUtil.validateStylePropertyName(name);
        if (value == null) {
            return this.remove(name);
        }
        String trimmedValue = value.trim();
        ElementUtil.validateStylePropertyValue(trimmedValue);
        this.propertyMap.setProperty(StyleUtil.stylePropertyToAttribute(name), (Serializable)((Object)trimmedValue), true);
        return this;
    }

    @Override
    public Style remove(String name) {
        ElementUtil.validateStylePropertyName(name);
        this.propertyMap.removeProperty(StyleUtil.stylePropertyToAttribute(name));
        return this;
    }

    @Override
    public Style clear() {
        this.propertyMap.removeAllProperties();
        return this;
    }

    @Override
    public String get(String name) {
        ElementUtil.validateStylePropertyName(name);
        return (String)((Object)this.propertyMap.getProperty(StyleUtil.stylePropertyToAttribute(name)));
    }

    @Override
    public Stream<String> getNames() {
        return this.propertyMap.getPropertyNames();
    }

    @Override
    public boolean has(String name) {
        return this.propertyMap.hasProperty(StyleUtil.stylePropertyToAttribute(name));
    }
}

