/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.ServletHelper;
import com.vaadin.flow.server.SessionExpiredHandler;
import com.vaadin.flow.server.SynchronizedRequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.ServerRpcHandler;
import com.vaadin.flow.server.communication.UidlWriter;
import elemental.json.JsonObject;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UidlRequestHandler
extends SynchronizedRequestHandler
implements SessionExpiredHandler {
    private ServerRpcHandler rpcHandler;

    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        return ServletHelper.isRequestType(request, ServletHelper.RequestType.UIDL);
    }

    protected ServerRpcHandler createRpcHandler() {
        return new ServerRpcHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        UI ui = session.getService().findUI(request);
        if (ui == null) {
            UidlRequestHandler.commitJsonResponse(response, UidlRequestHandler.wrapJsonForClient(VaadinService.createUINotFoundJSON()));
            return true;
        }
        try (StringWriter stringWriter = new StringWriter();){
            this.getRpcHandler(session).handleRpc(ui, request.getReader(), request);
            UidlRequestHandler.writeUidl(ui, stringWriter, false);
        }
        UidlRequestHandler.commitJsonResponse(response, stringWriter.toString());
        return true;
    }

    private void writeRefresh(VaadinResponse response) throws IOException {
        String json = VaadinService.createCriticalNotificationJSON(null, null, null, null);
        UidlRequestHandler.commitJsonResponse(response, json);
    }

    private static void writeUidl(UI ui, Writer writer, boolean resync) throws IOException {
        JsonObject uidl = new UidlWriter().createUidl(ui, false, resync);
        writer.write(UidlRequestHandler.wrapJsonForClient(uidl.toJson()));
    }

    private static String wrapJsonForClient(String jsonString) {
        return "for(;;);[" + jsonString + "]";
    }

    private static final Logger getLogger() {
        return LoggerFactory.getLogger((String)UidlRequestHandler.class.getName());
    }

    @Override
    public boolean handleSessionExpired(VaadinRequest request, VaadinResponse response) throws IOException {
        if (!ServletHelper.isRequestType(request, ServletHelper.RequestType.UIDL)) {
            return false;
        }
        VaadinService service = request.getService();
        service.writeUncachedStringResponse(response, "application/json; charset=UTF-8", UidlRequestHandler.wrapJsonForClient(VaadinService.createSessionExpiredJSON()));
        return true;
    }

    private ServerRpcHandler getRpcHandler(VaadinSession session) {
        session.checkHasLock();
        if (this.rpcHandler == null) {
            this.rpcHandler = this.createRpcHandler();
        }
        return this.rpcHandler;
    }

    public static void commitJsonResponse(VaadinResponse response, String json) throws IOException {
        response.setContentType("application/json; charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        byte[] b = json.getBytes(StandardCharsets.UTF_8);
        response.setContentLength(b.length);
        OutputStream outputStream = response.getOutputStream();
        outputStream.write(b);
        outputStream.flush();
    }
}

