/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.FallibleCommand;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCopyLocalFrontendFiles
implements FallibleCommand {
    private final File targetDirectory;
    private final File frontendResourcesDirectory;

    TaskCopyLocalFrontendFiles(File npmFolder, File frontendResourcesDirectory) {
        this.targetDirectory = new File(npmFolder, "node_modules/@vaadin/flow-frontend/");
        this.frontendResourcesDirectory = frontendResourcesDirectory;
    }

    @Override
    public void execute() {
        this.createTargetFolder();
        if (this.frontendResourcesDirectory != null && this.frontendResourcesDirectory.isDirectory()) {
            TaskCopyLocalFrontendFiles.log().info("Copying project local frontend resources.");
            try {
                FileUtils.copyDirectory((File)this.frontendResourcesDirectory, (File)this.targetDirectory);
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Failed to copy project frontend resources from '%s' to '%s'", this.frontendResourcesDirectory, this.targetDirectory), e);
            }
            TaskCopyLocalFrontendFiles.log().info("Copying frontend directory completed.");
        } else {
            TaskCopyLocalFrontendFiles.log().debug("Found no local frontend resources for the project");
        }
    }

    private void createTargetFolder() {
        try {
            FileUtils.forceMkdir((File)Objects.requireNonNull(this.targetDirectory));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create directory '%s'", this.targetDirectory), e);
        }
    }

    private static Logger log() {
        return LoggerFactory.getLogger(TaskCopyLocalFrontendFiles.class);
    }
}

