/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.FallibleCommand;
import com.vaadin.flow.server.frontend.JarContentsManager;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCopyFrontendFiles
implements FallibleCommand {
    private static final String JAR_SUFFIX = ".jar";
    private static final String[] WILDCARD_INCLUSIONS = new String[]{"**/*.js", "**/*.css"};
    private File targetDirectory;
    private transient Set<File> jarFiles = null;

    TaskCopyFrontendFiles(File npmFolder, Set<File> jarFilesToScan) {
        Objects.requireNonNull(npmFolder, "Parameter 'npmFolder' must not be null");
        Objects.requireNonNull(jarFilesToScan, "Parameter 'jarFilesToScan' must not be null");
        this.targetDirectory = new File(npmFolder, "node_modules/@vaadin/flow-frontend/");
        this.jarFiles = jarFilesToScan.stream().filter(file -> file.getName().endsWith(JAR_SUFFIX)).filter(File::exists).collect(Collectors.toSet());
    }

    @Override
    public void execute() {
        long start = System.nanoTime();
        TaskCopyFrontendFiles.log().info("Copying frontend resources from jar files ...");
        this.createTargetFolder();
        JarContentsManager jarContentsManager = new JarContentsManager();
        for (File jarFile : this.jarFiles) {
            jarContentsManager.copyIncludedFilesFromJarTrimmingBasePath(jarFile, "META-INF/resources/frontend", this.targetDirectory, WILDCARD_INCLUSIONS);
        }
        long ms = (System.nanoTime() - start) / 1000000L;
        TaskCopyFrontendFiles.log().info("Visited {} jar files. Took {} ms.", (Object)this.jarFiles.size(), (Object)ms);
    }

    private void createTargetFolder() {
        try {
            FileUtils.forceMkdir((File)Objects.requireNonNull(this.targetDirectory));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create directory '%s'", this.targetDirectory), e);
        }
    }

    private static Logger log() {
        return LoggerFactory.getLogger((String)"dev-updater");
    }
}

