/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.server.DefaultDeploymentConfiguration;
import com.vaadin.flow.server.PropertyDeploymentConfiguration;
import com.vaadin.flow.server.VaadinServletConfiguration;
import com.vaadin.flow.server.frontend.FrontendUtils;
import elemental.json.JsonObject;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.io.FileUtils;

public final class DeploymentConfigurationFactory
implements Serializable {
    private DeploymentConfigurationFactory() {
    }

    public static DeploymentConfiguration createDeploymentConfiguration(Class<?> systemPropertyBaseClass, ServletConfig servletConfig) throws ServletException {
        return new DefaultDeploymentConfiguration(systemPropertyBaseClass, DeploymentConfigurationFactory.createInitParameters(systemPropertyBaseClass, servletConfig));
    }

    public static DeploymentConfiguration createPropertyDeploymentConfiguration(Class<?> systemPropertyBaseClass, ServletConfig servletConfig) throws ServletException {
        return new PropertyDeploymentConfiguration(systemPropertyBaseClass, DeploymentConfigurationFactory.createInitParameters(systemPropertyBaseClass, servletConfig));
    }

    protected static Properties createInitParameters(Class<?> systemPropertyBaseClass, ServletConfig servletConfig) throws ServletException {
        String name;
        Properties initParameters = new Properties();
        DeploymentConfigurationFactory.readUiFromEnclosingClass(systemPropertyBaseClass, initParameters);
        DeploymentConfigurationFactory.readConfigurationAnnotation(systemPropertyBaseClass, initParameters);
        ServletContext context = servletConfig.getServletContext();
        Enumeration e = context.getInitParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            initParameters.setProperty(name, context.getInitParameter(name));
        }
        e = servletConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            initParameters.setProperty(name, servletConfig.getInitParameter(name));
        }
        DeploymentConfigurationFactory.readBuildInfo(initParameters);
        return initParameters;
    }

    private static void readBuildInfo(Properties initParameters) {
        try {
            URL resource;
            File tokenFile;
            String json = null;
            String tokenLocation = initParameters.getProperty("vaadin.frontend.token.file");
            if (tokenLocation != null && (tokenFile = new File(tokenLocation)) != null && tokenFile.canRead()) {
                json = FileUtils.readFileToString((File)tokenFile, (String)"UTF-8");
            }
            if (json == null && (resource = DeploymentConfigurationFactory.class.getClassLoader().getResource("META-INF/VAADIN/config/flow-build-info.json")) != null) {
                json = FrontendUtils.streamToString(resource.openStream());
            }
            if (json != null) {
                JsonObject buildInfo = (JsonObject)JsonUtil.parse(json);
                if (buildInfo.hasKey("productionMode")) {
                    initParameters.setProperty("productionMode", String.valueOf(buildInfo.getBoolean("productionMode")));
                    System.clearProperty("vaadin.productionMode");
                }
                if (buildInfo.hasKey("compatibilityMode")) {
                    initParameters.setProperty("compatibilityMode", String.valueOf(buildInfo.getBoolean("compatibilityMode")));
                    System.clearProperty("vaadin.compatibilityMode");
                }
                if (buildInfo.hasKey("npmFolder")) {
                    initParameters.setProperty("project.basedir", buildInfo.getString("npmFolder"));
                }
                if (buildInfo.hasKey("frontendFolder")) {
                    initParameters.setProperty("vaadin.frontend.frontend.folder", buildInfo.getString("frontendFolder"));
                }
                if (buildInfo.hasKey("enableDevServer")) {
                    initParameters.setProperty("enableDevServer", String.valueOf(buildInfo.getBoolean("enableDevServer")));
                }
                if (buildInfo.hasKey("reuseDevServer")) {
                    initParameters.setProperty("reuseDevServer", String.valueOf(buildInfo.getBoolean("reuseDevServer")));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void readUiFromEnclosingClass(Class<?> systemPropertyBaseClass, Properties initParameters) {
        Class<?> enclosingClass = systemPropertyBaseClass.getEnclosingClass();
        if (enclosingClass != null && UI.class.isAssignableFrom(enclosingClass)) {
            initParameters.put("UI", enclosingClass.getName());
        }
    }

    private static void readConfigurationAnnotation(Class<?> systemPropertyBaseClass, Properties initParameters) throws ServletException {
        Method[] methods;
        Optional<VaadinServletConfiguration> optionalConfigAnnotation = AnnotationReader.getAnnotationFor(systemPropertyBaseClass, VaadinServletConfiguration.class);
        if (!optionalConfigAnnotation.isPresent()) {
            return;
        }
        VaadinServletConfiguration configuration = optionalConfigAnnotation.get();
        for (Method method : methods = VaadinServletConfiguration.class.getDeclaredMethods()) {
            VaadinServletConfiguration.InitParameterName name = method.getAnnotation(VaadinServletConfiguration.InitParameterName.class);
            assert (name != null) : "All methods declared in VaadinServletConfiguration should have a @InitParameterName annotation";
            try {
                Object value = method.invoke((Object)configuration, new Object[0]);
                String stringValue = value instanceof Class ? ((Class)value).getName() : value.toString();
                initParameters.setProperty(name.value(), stringValue);
            }
            catch (Exception e) {
                throw new ServletException("Could not read @VaadinServletConfiguration value " + method.getName(), (Throwable)e);
            }
        }
    }
}

