/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.DevModeHandler;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.frontend.ClassFinder;
import com.vaadin.flow.server.frontend.JarContentsManager;
import com.vaadin.flow.server.frontend.NodeTasks;
import com.vaadin.flow.server.startup.ServletDeployer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HandlesTypes(value={Route.class, NpmPackage.class, WebComponentExporter.class})
public class DevModeInitializer
implements ServletContainerInitializer,
Serializable {
    public void onStartup(Set<Class<?>> classes, ServletContext context) throws ServletException {
        Collection registrations = context.getServletRegistrations().values();
        if (registrations.isEmpty()) {
            return;
        }
        DeploymentConfiguration config = ServletDeployer.StubServletConfig.createDeploymentConfiguration(context, (ServletRegistration)registrations.iterator().next(), VaadinServlet.class);
        DevModeInitializer.initDevModeHandler(classes, context, config);
    }

    public static void initDevModeHandler(Set<Class<?>> classes, ServletContext context, DeploymentConfiguration config) {
        if (config.isProductionMode()) {
            DevModeInitializer.log().debug("Skipping DEV MODE because PRODUCTION MODE is set.");
            return;
        }
        if (config.isCompatibilityMode()) {
            DevModeInitializer.log().debug("Skipping DEV MODE because BOWER MODE is set.");
            return;
        }
        if (!config.enableDevServer()) {
            DevModeInitializer.log().debug("Skipping DEV MODE because dev server shouldn't be enabled.");
            return;
        }
        String baseDir = config.getStringProperty("project.basedir", System.getProperty("user.dir", "."));
        NodeTasks.Builder builder = new NodeTasks.Builder(new ClassFinder.DefaultClassFinder(classes), new File(baseDir));
        DevModeInitializer.log().info("Starting dev-mode updaters in {} folder.", (Object)builder.npmFolder);
        if (!builder.generatedFolder.exists()) {
            try {
                FileUtils.forceMkdir((File)builder.generatedFolder);
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Failed to create directory '%s'", builder.generatedFolder), e);
            }
        }
        File flowNodeDirectory = new File(builder.npmFolder, "node_modules/@vaadin/flow-frontend/");
        File generatedPackages = new File(builder.generatedFolder, "package.json");
        if (!flowNodeDirectory.exists() || !generatedPackages.exists()) {
            DevModeInitializer.copyFrontendFilesFromJars(flowNodeDirectory);
        }
        if (!new File(builder.npmFolder, "webpack.generated.js").exists()) {
            builder.withWebpack(builder.npmFolder, "webpack.config.js", "webpack.generated.js");
        }
        if (!new File(builder.npmFolder, "package.json").exists() || !generatedPackages.exists()) {
            builder.createMissingPackageJson(true);
        }
        HashSet<String> visitedClassNames = new HashSet<String>();
        builder.enablePackagesUpdate(true).enableImportsUpdate(true).runNpmInstall(true).withEmbeddableWebComponents(true).collectVisitedClasses(visitedClassNames).build().execute();
        VaadinServletContext vaadinContext = new VaadinServletContext(context);
        vaadinContext.setAttribute(new VisitedClasses(visitedClassNames));
        DevModeHandler.start(config, builder.npmFolder);
    }

    private static Logger log() {
        return LoggerFactory.getLogger(DevModeInitializer.class);
    }

    private static void copyFrontendFilesFromJars(File flowNodeDirectory) {
        List collect = Stream.of(System.getProperty("java.class.path").split(";")).filter(path -> path.endsWith(".jar")).map(File::new).filter(File::exists).collect(Collectors.toList());
        DevModeInitializer.log().info("Found {} jars to copy files from.", (Object)collect.size());
        try {
            FileUtils.forceMkdir((File)Objects.requireNonNull(flowNodeDirectory));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create directory '%s'", flowNodeDirectory), e);
        }
        String[] wildcardInclusions = new String[]{"**/*.js", "**/*.css"};
        JarContentsManager jarContentsManager = new JarContentsManager();
        for (File jarFile : collect) {
            jarContentsManager.copyIncludedFilesFromJarTrimmingBasePath(jarFile, "META-INF/resources/frontend", flowNodeDirectory, wildcardInclusions);
        }
    }

    public static class VisitedClasses
    implements Serializable {
        private Set<String> visitedClassNames;

        public VisitedClasses(Set<String> visitedClassNames) {
            assert (visitedClassNames != null);
            this.visitedClassNames = visitedClassNames;
        }

        public boolean allDependenciesVisited(Class<?> dependencyClass) {
            if (this.visitedClassNames.contains(dependencyClass.getName())) {
                return true;
            }
            if (((JsModule[])dependencyClass.getDeclaredAnnotationsByType(JsModule.class)).length != 0) {
                return false;
            }
            Class<?> superclass = dependencyClass.getSuperclass();
            if (superclass == null) {
                return true;
            }
            return this.allDependenciesVisited(superclass);
        }
    }
}

