/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.ClassFinder;
import com.vaadin.flow.server.frontend.FrontendDependencies;
import com.vaadin.flow.server.frontend.ImportExtractor;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.LoggerFactory;

public class TaskUpdateImports
extends NodeUpdater {
    private final File generatedFlowImports;
    private final File frontendDirectory;
    private static final String IMPORT = "import '%s';";

    TaskUpdateImports(ClassFinder finder, FrontendDependencies frontendDependencies, File npmFolder, File generatedPath, File frontendDirectory) {
        super(finder, frontendDependencies, npmFolder, generatedPath);
        this.frontendDirectory = frontendDirectory;
        this.generatedFlowImports = new File(generatedPath, "generated-flow-imports.js");
    }

    @Override
    public void execute() {
        HashSet<String> modules = new HashSet<String>();
        modules.addAll(this.resolveModules(this.frontDeps.getModules(), true));
        modules.addAll(this.resolveModules(this.frontDeps.getScripts(), false));
        modules.addAll(this.getGeneratedModules(this.generatedFolder, Collections.singleton(this.generatedFlowImports.getName())));
        modules = modules.stream().filter(module -> !module.contains("://")).collect(Collectors.toSet());
        modules = this.sortModules(modules);
        try {
            this.updateMainJsFile(this.getMainJsContent(modules));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to update the Flow imports file '%s'", this.generatedFlowImports), e);
        }
    }

    private Set<String> sortModules(Set<String> modules) {
        return modules.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private List<String> getMainJsContent(Set<String> modules) {
        ArrayList<String> lines = new ArrayList<String>();
        AbstractTheme theme = this.frontDeps.getTheme();
        ThemeDefinition themeDef = this.frontDeps.getThemeDefinition();
        if (theme != null) {
            if (!theme.getHeaderInlineContents().isEmpty()) {
                lines.add("const div = document.createElement('div');");
                theme.getHeaderInlineContents().forEach(html -> {
                    lines.add("div.innerHTML = '" + html.replaceAll("(?m)(^\\s+|\\s?\n)", "") + "';");
                    lines.add("document.head.insertBefore(div.firstElementChild, document.head.firstChild);");
                });
            }
            theme.getHtmlAttributes(themeDef.getVariant()).forEach((key, value) -> lines.add("document.body.setAttribute('" + key + "', '" + value + "');"));
        }
        ArrayList<String> imports = new ArrayList<String>(modules.size());
        this.modulesToImports(modules, theme, imports);
        lines.addAll(imports);
        return lines;
    }

    private void modulesToImports(Set<String> modules, AbstractTheme theme, Collection<String> imports) {
        HashSet<String> resourceNotFound = new HashSet<String>();
        HashSet<String> npmNotFound = new HashSet<String>();
        HashSet<String> visited = new HashSet<String>();
        Iterator<String> iterator = modules.iterator();
        while (iterator.hasNext()) {
            String originalModulePath;
            String translatedModulePath = originalModulePath = iterator.next();
            if (theme != null && translatedModulePath.contains(theme.getBaseUrl())) {
                translatedModulePath = theme.translateUrl(translatedModulePath);
            }
            if (this.importedFileExists(translatedModulePath)) {
                imports.add(String.format(IMPORT, this.toValidBrowserImport(translatedModulePath)));
            } else if (this.importedFileExists(originalModulePath)) {
                imports.add(String.format(IMPORT, this.toValidBrowserImport(originalModulePath)));
            } else if (originalModulePath.startsWith("./")) {
                resourceNotFound.add(originalModulePath);
            } else {
                npmNotFound.add(originalModulePath);
                imports.add(String.format(IMPORT, originalModulePath));
            }
            if (theme == null) continue;
            this.handleImports(originalModulePath, theme, imports, visited);
        }
        if (!resourceNotFound.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder("\n\n  Failed to resolve the following files either:\n   \u00b7 in the `/frontend` sources folder\n   \u00b7 or as a `META-INF/resources/frontend` resource in some JAR. \n       \u279c ");
            errorMessage.append(String.join((CharSequence)"\n       \u279c ", resourceNotFound));
            errorMessage.append("\n  Please, double check that those files exist.\n");
            throw new IllegalStateException(errorMessage.toString());
        }
        if (!npmNotFound.isEmpty()) {
            String message = "\n\n  Failed to find the following imports in the `node_modules` tree:\n      \u279c " + String.join((CharSequence)"\n       \u279c ", npmNotFound) + "\n  If the build fails, check that npm packages are installed.\n";
            TaskUpdateImports.log().info(message);
        }
    }

    private void handleImports(String path, AbstractTheme theme, Collection<String> imports, Set<String> visitedImports) {
        if (visitedImports.contains(path)) {
            return;
        }
        File file = this.getImportedFrontendFile(path);
        if (file == null) {
            return;
        }
        Path filePath = file.toPath();
        visitedImports.add(filePath.normalize().toString());
        try {
            this.visitImportsRecursively(filePath, path, theme, imports, visitedImports);
        }
        catch (IOException exception) {
            LoggerFactory.getLogger(TaskUpdateImports.class).warn("Could not read file {}. Skipping applyig theme for its imports", (Object)file.getPath(), (Object)exception);
        }
    }

    private void visitImportsRecursively(Path filePath, String path, AbstractTheme theme, Collection<String> imports, Set<String> visitedImports) throws IOException {
        String content = Files.readAllLines(filePath, StandardCharsets.UTF_8).stream().collect(Collectors.joining("\n"));
        ImportExtractor extractor = new ImportExtractor(content);
        List<String> importedPaths = extractor.getImportedPaths();
        for (String importedPath : importedPaths) {
            String translatedPath;
            String resolvedPath = this.resolve(importedPath, filePath, path);
            if (resolvedPath.contains(theme.getBaseUrl()) && this.importedFileExists(translatedPath = theme.translateUrl(resolvedPath))) {
                imports.add(String.format(IMPORT, this.normalizeImportPath(translatedPath)));
            }
            this.handleImports(resolvedPath, theme, imports, visitedImports);
        }
    }

    private String normalizeImportPath(String path) {
        String importPath = this.toValidBrowserImport(path);
        File file = new File(importPath);
        return file.toPath().normalize().toString();
    }

    private String resolve(String importedPath, Path moduleFile, String path) {
        String pathPrefix = moduleFile.toString();
        pathPrefix = pathPrefix.substring(0, pathPrefix.length() - path.length());
        String resolvedPath = moduleFile.getParent().resolve(importedPath).toString();
        if (resolvedPath.startsWith(pathPrefix)) {
            resolvedPath = resolvedPath.substring(pathPrefix.length());
        }
        return resolvedPath;
    }

    private boolean importedFileExists(String jsImport) {
        File file = this.getImportedFrontendFile(jsImport);
        if (file != null) {
            return true;
        }
        boolean found = this.isFile(this.nodeModulesFolder, jsImport);
        found = found || this.isFile(this.nodeModulesFolder, jsImport + ".js");
        found = found || this.isFile(this.nodeModulesFolder, jsImport, "package.json");
        return found || this.isFile(this.generatedFolder, TaskUpdateImports.generatedResourcePathIntoRelativePath(jsImport));
    }

    private File getImportedFrontendFile(String jsImport) {
        File file = this.getFile(this.frontendDirectory, jsImport);
        if (file.exists()) {
            return file;
        }
        file = this.getFile(this.nodeModulesFolder, "@vaadin/flow-frontend/", jsImport);
        return file.exists() ? file : null;
    }

    private File getFile(File base, String ... path) {
        return new File(base, String.join((CharSequence)"/", path));
    }

    private boolean isFile(File base, String ... path) {
        return this.getFile(base, path).isFile();
    }

    private String toValidBrowserImport(String jsImport) {
        if (jsImport.startsWith("GENERATED/")) {
            return TaskUpdateImports.generatedResourcePathIntoRelativePath(jsImport);
        }
        if (this.isFile(this.frontendDirectory, jsImport)) {
            if (!jsImport.startsWith("./")) {
                TaskUpdateImports.log().warn("Use the './' prefix for files in the 'frontend' folder: '{}', please update your annotations.", (Object)jsImport);
            }
            return "Frontend/" + jsImport.replaceFirst("^\\./", "");
        }
        return jsImport;
    }

    private void updateMainJsFile(List<String> newContent) throws IOException {
        List oldContent;
        List list = oldContent = this.generatedFlowImports.exists() ? FileUtils.readLines((File)this.generatedFlowImports, (String)"UTF-8") : null;
        if (newContent.equals(oldContent)) {
            TaskUpdateImports.log().info("No js modules to update");
        } else {
            FileUtils.forceMkdir((File)this.generatedFlowImports.getParentFile());
            FileUtils.writeStringToFile((File)this.generatedFlowImports, (String)String.join((CharSequence)"\n", newContent), (String)"UTF-8");
            TaskUpdateImports.log().info("Updated {}", (Object)this.generatedFlowImports);
        }
    }

    private static String generatedResourcePathIntoRelativePath(String path) {
        return path.replace("GENERATED/", "./");
    }
}

