/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public interface ClassFinder
extends Serializable {
    public Set<Class<?>> getAnnotatedClasses(Class<? extends Annotation> var1);

    default public Set<Class<?>> getAnnotatedClasses(String className) throws ClassNotFoundException {
        return this.getAnnotatedClasses(this.loadClass(className));
    }

    public URL getResource(String var1);

    public <T> Class<T> loadClass(String var1) throws ClassNotFoundException;

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> var1);

    default public <T> Set<Class<? extends T>> getSubTypesOf(String name) throws ClassNotFoundException {
        Class<T> parent = this.loadClass(name);
        return this.getSubTypesOf(parent);
    }

    public static class CachedClassFinder
    implements ClassFinder {
        private ClassFinder classFinder;
        private Map<Class<? extends Annotation>, Set<Class<?>>> annotatedClassesMapCache = new HashMap();

        public CachedClassFinder(ClassFinder classFinder) {
            this.classFinder = classFinder;
        }

        @Override
        public Set<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotation) {
            return this.annotatedClassesMapCache.computeIfAbsent(annotation, key -> this.classFinder.getAnnotatedClasses((Class<? extends Annotation>)key));
        }

        @Override
        public URL getResource(String name) {
            return this.classFinder.getResource(name);
        }

        @Override
        public <T> Class<T> loadClass(String name) throws ClassNotFoundException {
            return this.classFinder.loadClass(name);
        }

        @Override
        public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
            return this.classFinder.getSubTypesOf(type);
        }
    }

    public static class DefaultClassFinder
    implements ClassFinder {
        private final Set<Class<?>> classes;
        private final transient ClassLoader classLoader;

        public DefaultClassFinder(Set<Class<?>> classes) {
            this.classes = classes;
            this.classLoader = classes.isEmpty() ? this.getClass().getClassLoader() : classes.iterator().next().getClassLoader();
        }

        public DefaultClassFinder(ClassLoader classLoader, Class<?> ... classes) {
            this.classLoader = classLoader;
            this.classes = new HashSet();
            for (Class<?> clazz : classes) {
                this.classes.add(clazz);
            }
        }

        @Override
        public Set<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotation) {
            return this.classes.stream().filter(cl -> cl.getAnnotationsByType(annotation).length > 0).collect(Collectors.toSet());
        }

        @Override
        public URL getResource(String name) {
            return this.classLoader.getResource(name);
        }

        @Override
        public <T> Class<T> loadClass(String name) throws ClassNotFoundException {
            return this.classLoader.loadClass(name);
        }

        @Override
        public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
            return this.classes.stream().filter(cl -> type.isAssignableFrom((Class<?>)cl) && !type.equals(cl)).map(cl -> cl).collect(Collectors.toSet());
        }
    }
}

