/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.CompatibilityModeStatus;
import com.vaadin.flow.server.DeploymentConfigurationFactory;
import com.vaadin.flow.server.PropertyDeploymentConfiguration;
import com.vaadin.flow.shared.communication.PushMode;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDeploymentConfiguration
extends PropertyDeploymentConfiguration {
    private static final String SEPARATOR = "\n====================================================================";
    public static final String NOT_PRODUCTION_MODE_INFO = "\n====================================================================\nVaadin is running in DEBUG MODE.\nAdd productionMode=true to web.xml to disable debug features.\n====================================================================";
    public static final String WARNING_COMPATIBILITY_MODE = "\n====================================================================\nRunning in Vaadin 13 (Flow 1) compatibility mode.\n\nThis mode uses webjars/Bower for client side dependency management and HTML imports for dependency loading.\n\nThe default mode in Vaadin 14+ (Flow 2+) is based on npm for dependency management and JavaScript modules for dependency inclusion.\n\nSee http://vaadin.com/docs for more information.\n====================================================================";
    public static final String WARNING_XSRF_PROTECTION_DISABLED = "\n====================================================================\nWARNING: Cross-site request forgery protection is disabled!\n====================================================================";
    public static final String WARNING_HEARTBEAT_INTERVAL_NOT_NUMERIC = "\n====================================================================\nWARNING: heartbeatInterval has been set to a non integer value in web.xml. The default of 5min will be used.\n====================================================================";
    public static final String WARNING_PUSH_MODE_NOT_RECOGNIZED = "\n====================================================================\nWARNING: pushMode has been set to an unrecognized value\nin web.xml. The permitted values are \"disabled\", \"manual\",\nand \"automatic\". The default of \"disabled\" will be used.\n====================================================================";
    public static final int DEFAULT_HEARTBEAT_INTERVAL = 300;
    public static final int DEFAULT_WEB_COMPONENT_DISCONNECT = 300;
    public static final boolean DEFAULT_CLOSE_IDLE_SESSIONS = false;
    public static final boolean DEFAULT_SYNC_ID_CHECK = true;
    public static final boolean DEFAULT_SEND_URLS_AS_PARAMETERS = true;
    private boolean productionMode;
    private boolean compatibilityMode;
    private boolean xsrfProtectionEnabled;
    private int heartbeatInterval;
    private int webComponentDisconnect;
    private boolean closeIdleSessions;
    private PushMode pushMode;
    private String pushURL;
    private boolean syncIdCheck;
    private boolean sendUrlsAsParameters;
    private boolean requestTiming;
    private static AtomicBoolean loggWarning = new AtomicBoolean(true);

    public DefaultDeploymentConfiguration(Class<?> systemPropertyBaseClass, Properties initParameters) {
        super(systemPropertyBaseClass, initParameters);
        boolean log = loggWarning.getAndSet(false);
        this.checkProductionMode(log);
        this.checkCompatibilityMode(log);
        this.checkRequestTiming();
        this.checkXsrfProtection(log);
        this.checkHeartbeatInterval();
        this.checkWebComponentDisconnectTimeout();
        this.checkCloseIdleSessions();
        this.checkPushMode();
        this.checkPushURL();
        this.checkSyncIdCheck();
        this.checkSendUrlsAsParameters();
    }

    @Override
    public boolean isProductionMode() {
        return this.productionMode;
    }

    @Override
    public boolean isBowerMode() {
        return this.compatibilityMode;
    }

    @Override
    public boolean isRequestTiming() {
        return this.requestTiming;
    }

    @Override
    public boolean isXsrfProtectionEnabled() {
        return this.xsrfProtectionEnabled;
    }

    @Override
    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    @Override
    public int getWebComponentDisconnect() {
        return this.webComponentDisconnect;
    }

    @Override
    public boolean isCloseIdleSessions() {
        return this.closeIdleSessions;
    }

    @Override
    public boolean isSyncIdCheckEnabled() {
        return this.syncIdCheck;
    }

    @Override
    public boolean isSendUrlsAsParameters() {
        return this.sendUrlsAsParameters;
    }

    @Override
    public PushMode getPushMode() {
        return this.pushMode;
    }

    @Override
    public String getPushURL() {
        return this.pushURL;
    }

    private void checkProductionMode(boolean loggWarning) {
        this.productionMode = this.getBooleanProperty("productionMode", false);
        if (!this.productionMode && loggWarning) {
            this.getLogger().warn(NOT_PRODUCTION_MODE_INFO);
        }
    }

    private void checkCompatibilityMode(boolean loggWarning) {
        boolean explicitlySet = false;
        if (this.getStringProperty("bowerMode", null) != null) {
            this.compatibilityMode = this.getBooleanProperty("bowerMode", false);
            explicitlySet = true;
        } else if (this.getStringProperty("compatibilityMode", null) != null) {
            this.compatibilityMode = this.getBooleanProperty("compatibilityMode", false);
            explicitlySet = true;
        }
        Consumer consumer = (Consumer)this.getInitParameters().get(DeploymentConfigurationFactory.DEV_MODE_ENABLE_STRATEGY);
        if (consumer != null) {
            if (explicitlySet && !this.compatibilityMode) {
                consumer.accept(CompatibilityModeStatus.EXPLICITLY_SET_FALSE);
            } else if (!explicitlySet) {
                consumer.accept(CompatibilityModeStatus.UNDEFINED);
            }
        }
        if (this.compatibilityMode && loggWarning) {
            this.getLogger().warn(WARNING_COMPATIBILITY_MODE);
        }
    }

    private void checkRequestTiming() {
        this.requestTiming = this.getBooleanProperty("requestTiming", !this.productionMode);
    }

    private void checkXsrfProtection(boolean loggWarning) {
        boolean bl = this.xsrfProtectionEnabled = !this.getBooleanProperty("disable-xsrf-protection", false);
        if (!this.xsrfProtectionEnabled && loggWarning) {
            this.getLogger().warn(WARNING_XSRF_PROTECTION_DISABLED);
        }
    }

    private void checkHeartbeatInterval() {
        try {
            this.heartbeatInterval = this.getApplicationOrSystemProperty("heartbeatInterval", 300, Integer::parseInt);
        }
        catch (NumberFormatException e) {
            this.getLogger().warn(WARNING_HEARTBEAT_INTERVAL_NOT_NUMERIC);
            this.heartbeatInterval = 300;
        }
    }

    private void checkWebComponentDisconnectTimeout() {
        try {
            this.webComponentDisconnect = this.getApplicationOrSystemProperty("webComponentDisconnect", 300, Integer::parseInt);
        }
        catch (NumberFormatException e) {
            this.getLogger().warn(WARNING_HEARTBEAT_INTERVAL_NOT_NUMERIC);
            this.webComponentDisconnect = 300;
        }
    }

    private void checkCloseIdleSessions() {
        this.closeIdleSessions = this.getBooleanProperty("closeIdleSessions", false);
    }

    private void checkPushMode() {
        try {
            this.pushMode = this.getApplicationOrSystemProperty("pushMode", PushMode.DISABLED, stringMode -> Enum.valueOf(PushMode.class, stringMode.toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn(WARNING_PUSH_MODE_NOT_RECOGNIZED);
            this.pushMode = PushMode.DISABLED;
        }
    }

    private void checkPushURL() {
        this.pushURL = this.getStringProperty("pushURL", "");
    }

    private void checkSyncIdCheck() {
        this.syncIdCheck = this.getBooleanProperty("syncIdCheck", true);
    }

    private void checkSendUrlsAsParameters() {
        this.sendUrlsAsParameters = this.getBooleanProperty("sendUrlsAsParameters", true);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger((String)this.getClass().getName());
    }
}

