/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.ErrorNavigationEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.EventUtil;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.LocationChangeEvent;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationHandler;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.PreserveOnRefresh;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.AfterNavigationHandler;
import com.vaadin.flow.router.internal.BeforeEnterHandler;
import com.vaadin.flow.router.internal.BeforeLeaveHandler;
import com.vaadin.flow.router.internal.Postpone;
import com.vaadin.flow.server.VaadinSession;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractNavigationStateRenderer
implements NavigationHandler {
    private static List<Integer> statusCodes = ReflectTools.getConstantIntValues(HttpServletResponse.class);
    private final NavigationState navigationState;
    private Postpone postponed = null;

    public AbstractNavigationStateRenderer(NavigationState navigationState) {
        this.navigationState = navigationState;
    }

    public NavigationState getNavigationState() {
        return this.navigationState;
    }

    static <T extends HasElement> T getRouteTarget(Class<T> routeTargetType, NavigationEvent event) {
        UI ui = event.getUI();
        Optional<HasElement> currentInstance = ui.getInternals().getActiveRouterTargetsChain().stream().filter(component -> component.getClass().equals(routeTargetType)).findAny();
        return (T)currentInstance.orElseGet(() -> Instantiator.get(ui).createRouteTarget(routeTargetType, event));
    }

    @Override
    public int handle(NavigationEvent event) {
        ArrayList<HasElement> chain;
        UI ui = event.getUI();
        Class<? extends Component> routeTargetType = this.navigationState.getNavigationTarget();
        List<Class<? extends RouterLayout>> routeLayoutTypes = this.getRouterLayoutTypes(routeTargetType, ui.getRouter());
        assert (routeTargetType != null);
        assert (routeLayoutTypes != null);
        this.clearContinueNavigationAction(ui);
        AbstractNavigationStateRenderer.checkForDuplicates(routeTargetType, routeLayoutTypes);
        if (this.eventActionsSupported()) {
            TransitionOutcome transitionOutcome;
            Deque<BeforeLeaveHandler> leaveHandlers;
            BeforeLeaveEvent beforeNavigationDeactivating = new BeforeLeaveEvent(event, routeTargetType, routeLayoutTypes);
            if (this.postponed != null) {
                leaveHandlers = this.postponed.getLeaveObservers();
                if (!leaveHandlers.isEmpty()) {
                    this.postponed = null;
                }
            } else {
                ArrayList<BeforeLeaveHandler> beforeLeaveHandlers = new ArrayList<BeforeLeaveHandler>(ui.getNavigationListeners(BeforeLeaveHandler.class));
                beforeLeaveHandlers.addAll(EventUtil.collectBeforeLeaveObservers(ui));
                leaveHandlers = new ArrayDeque<BeforeLeaveHandler>(beforeLeaveHandlers);
            }
            if ((transitionOutcome = this.executeBeforeLeaveNavigation(beforeNavigationDeactivating, leaveHandlers)) == TransitionOutcome.FORWARDED) {
                return this.forward(event, beforeNavigationDeactivating);
            }
            if (transitionOutcome == TransitionOutcome.REROUTED) {
                return this.reroute(event, beforeNavigationDeactivating);
            }
            if (transitionOutcome == TransitionOutcome.POSTPONED) {
                BeforeLeaveEvent.ContinueNavigationAction currentAction = beforeNavigationDeactivating.getContinueNavigationAction();
                currentAction.setReferences(this, event);
                this.storeContinueNavigationAction(ui, currentAction);
                return 200;
            }
        }
        if (AbstractNavigationStateRenderer.isPreserveOnRefreshTarget(routeTargetType, routeLayoutTypes)) {
            Optional<ArrayList<HasElement>> maybeChain = this.createOrRehandlePreserveOnRefreshComponent(event);
            if (!maybeChain.isPresent()) {
                return 200;
            }
            chain = maybeChain.get();
        } else {
            chain = this.createChain(event);
            AbstractNavigationStateRenderer.clearAllPreservedChains(ui);
        }
        Component componentInstance = (Component)chain.get(0);
        BeforeEnterEvent beforeNavigationActivating = new BeforeEnterEvent(event, routeTargetType, routeLayoutTypes);
        LocationChangeEvent locationChangeEvent = new LocationChangeEvent(event.getSource(), event.getUI(), event.getTrigger(), event.getLocation(), chain);
        this.notifyNavigationTarget(componentInstance, event, beforeNavigationActivating, locationChangeEvent);
        if (beforeNavigationActivating.hasRerouteTarget()) {
            return this.reroute(event, beforeNavigationActivating);
        }
        List<HasElement> routerLayouts = chain.subList(1, chain.size());
        ArrayList<BeforeEnterHandler> enterHandlers = new ArrayList<BeforeEnterHandler>(ui.getNavigationListeners(BeforeEnterHandler.class));
        enterHandlers.addAll(EventUtil.collectBeforeEnterObservers(ui.getInternals().getActiveRouterTargetsChain(), chain));
        TransitionOutcome transitionOutcome = this.executeBeforeEnterNavigation(beforeNavigationActivating, enterHandlers);
        if (this.eventActionsSupported() && TransitionOutcome.FORWARDED.equals((Object)transitionOutcome)) {
            return this.forward(event, beforeNavigationActivating);
        }
        if (this.eventActionsSupported() && TransitionOutcome.REROUTED.equals((Object)transitionOutcome)) {
            return this.reroute(event, beforeNavigationActivating);
        }
        ui.getInternals().showRouteTarget(event.getLocation(), this.navigationState.getResolvedPath(), componentInstance, routerLayouts);
        AbstractNavigationStateRenderer.updatePageTitle(event, componentInstance);
        int statusCode = locationChangeEvent.getStatusCode();
        AbstractNavigationStateRenderer.validateStatusCode(statusCode, routeTargetType);
        ArrayList<AfterNavigationHandler> afterNavigationHandlers = new ArrayList<AfterNavigationHandler>(ui.getNavigationListeners(AfterNavigationHandler.class));
        afterNavigationHandlers.addAll(EventUtil.collectAfterNavigationObservers(ui));
        this.fireAfterNavigationListeners(new AfterNavigationEvent(locationChangeEvent), afterNavigationHandlers);
        return statusCode;
    }

    protected abstract void notifyNavigationTarget(Component var1, NavigationEvent var2, BeforeEnterEvent var3, LocationChangeEvent var4);

    protected abstract List<Class<? extends RouterLayout>> getRouterLayoutTypes(Class<? extends Component> var1, Router var2);

    protected abstract boolean eventActionsSupported();

    private ArrayList<HasElement> createChain(NavigationEvent event) {
        Class<? extends Component> routeTargetType = this.navigationState.getNavigationTarget();
        List<Class<? extends RouterLayout>> routeLayoutTypes = this.getRouterLayoutTypes(routeTargetType, event.getUI().getRouter());
        ArrayList<HasElement> chain = new ArrayList<HasElement>();
        chain.add(AbstractNavigationStateRenderer.getRouteTarget(routeTargetType, event));
        for (Class<? extends RouterLayout> parentType : routeLayoutTypes) {
            chain.add(AbstractNavigationStateRenderer.getRouteTarget(parentType, event));
        }
        return chain;
    }

    private void clearContinueNavigationAction(UI ui) {
        this.storeContinueNavigationAction(ui, null);
    }

    private void storeContinueNavigationAction(UI ui, BeforeLeaveEvent.ContinueNavigationAction currentAction) {
        BeforeLeaveEvent.ContinueNavigationAction previousAction = ui.getInternals().getContinueNavigationAction();
        if (previousAction != null && previousAction != currentAction) {
            previousAction.setReferences(null, null);
        }
        ui.getInternals().setContinueNavigationAction(currentAction);
    }

    private void fireAfterNavigationListeners(AfterNavigationEvent event, List<AfterNavigationHandler> afterNavigationHandlers) {
        afterNavigationHandlers.forEach(listener -> listener.afterNavigation(event));
    }

    private TransitionOutcome executeBeforeLeaveNavigation(BeforeLeaveEvent beforeNavigation, Deque<BeforeLeaveHandler> leaveHandlers) {
        while (!leaveHandlers.isEmpty()) {
            BeforeLeaveHandler listener = leaveHandlers.remove();
            listener.beforeLeave(beforeNavigation);
            AbstractNavigationStateRenderer.validateBeforeEvent(beforeNavigation);
            if (beforeNavigation.hasForwardTarget()) {
                return TransitionOutcome.FORWARDED;
            }
            if (beforeNavigation.hasRerouteTarget()) {
                return TransitionOutcome.REROUTED;
            }
            if (!beforeNavigation.isPostponed()) continue;
            this.postponed = Postpone.withLeaveObservers(leaveHandlers);
            return TransitionOutcome.POSTPONED;
        }
        return TransitionOutcome.FINISHED;
    }

    private TransitionOutcome executeBeforeEnterNavigation(BeforeEnterEvent beforeNavigation, List<BeforeEnterHandler> enterHandlers) {
        for (BeforeEnterHandler eventHandler : enterHandlers) {
            eventHandler.beforeEnter(beforeNavigation);
            AbstractNavigationStateRenderer.validateBeforeEvent(beforeNavigation);
            if (beforeNavigation.hasForwardTarget()) {
                return TransitionOutcome.FORWARDED;
            }
            if (!beforeNavigation.hasRerouteTarget()) continue;
            return TransitionOutcome.REROUTED;
        }
        return TransitionOutcome.FINISHED;
    }

    private int forward(NavigationEvent event, BeforeEvent beforeNavigation) {
        NavigationHandler handler = beforeNavigation.getForwardTarget();
        NavigationEvent newNavigationEvent = this.getNavigationEvent(event, beforeNavigation);
        newNavigationEvent.getUI().getPage().getHistory().replaceState(null, newNavigationEvent.getLocation());
        return handler.handle(newNavigationEvent);
    }

    private int reroute(NavigationEvent event, BeforeEvent beforeNavigation) {
        NavigationHandler handler = beforeNavigation.getRerouteTarget();
        NavigationEvent newNavigationEvent = this.getNavigationEvent(event, beforeNavigation);
        return handler.handle(newNavigationEvent);
    }

    private NavigationEvent getNavigationEvent(NavigationEvent event, BeforeEvent beforeNavigation) {
        if (beforeNavigation.hasErrorParameter()) {
            ErrorParameter<?> errorParameter = beforeNavigation.getErrorParameter();
            return new ErrorNavigationEvent(event.getSource(), event.getLocation(), event.getUI(), NavigationTrigger.PROGRAMMATIC, errorParameter);
        }
        Class<? extends Component> targetType = beforeNavigation.hasForwardTarget() ? beforeNavigation.getForwardTargetType() : beforeNavigation.getRouteTargetType();
        Location location = new Location(RouteConfiguration.forRegistry(event.getSource().getRegistry()).getUrlBase(targetType).orElseThrow(() -> new IllegalStateException(String.format("The target component '%s' has no registered route", targetType))));
        if (beforeNavigation.hasForwardTarget()) {
            ArrayList<String> segments = new ArrayList<String>(location.getSegments());
            segments.addAll(beforeNavigation.getForwardTargetParameters());
            location = new Location(segments);
        }
        return new NavigationEvent(event.getSource(), location, event.getUI(), NavigationTrigger.PROGRAMMATIC);
    }

    private Optional<ArrayList<HasElement>> createOrRehandlePreserveOnRefreshComponent(NavigationEvent event) {
        ArrayList<HasElement> chain;
        Location location = event.getLocation();
        UI ui = event.getUI();
        VaadinSession session = ui.getSession();
        if (ui.getInternals().getExtendedClientDetails() == null) {
            if (AbstractNavigationStateRenderer.hasPreservedChainOfLocation(session, location)) {
                ui.getPage().retrieveExtendedClientDetails(details -> this.handle(event));
                return Optional.empty();
            }
            chain = this.createChain(event);
            ui.getPage().retrieveExtendedClientDetails(details -> {
                String windowName = ui.getInternals().getExtendedClientDetails().getWindowName();
                AbstractNavigationStateRenderer.setPreservedChain(session, windowName, location, chain);
            });
        } else {
            String windowName = ui.getInternals().getExtendedClientDetails().getWindowName();
            Optional<ArrayList<HasElement>> maybePreserved = AbstractNavigationStateRenderer.getPreservedChain(session, windowName, event.getLocation());
            if (maybePreserved.isPresent()) {
                chain = maybePreserved.get();
                HasElement root = chain.get(chain.size() - 1);
                Component component = (Component)chain.get(0);
                Optional<UI> maybePrevUI = component.getUI();
                root.getElement().removeFromTree();
                maybePrevUI.ifPresent(prevUi -> this.moveElementsToNewUI((UI)prevUi, ui));
            } else {
                chain = this.createChain(event);
                AbstractNavigationStateRenderer.setPreservedChain(session, windowName, location, chain);
            }
        }
        return Optional.of(chain);
    }

    private static void validateStatusCode(int statusCode, Class<? extends Component> targetClass) {
        if (!statusCodes.contains(statusCode)) {
            String msg = String.format("Error state code must be a valid HttpServletResponse value. Received invalid value of '%s' for '%s'", statusCode, targetClass.getName());
            throw new IllegalStateException(msg);
        }
    }

    private static void validateBeforeEvent(BeforeEvent event) {
        if (event.hasForwardTarget() && event.hasRerouteTarget()) {
            throw new IllegalStateException("Error forward & reroute can not be set at the same time");
        }
    }

    private static void checkForDuplicates(Class<? extends Component> routeTargetType, Collection<Class<? extends RouterLayout>> routeLayoutTypes) {
        HashSet<Class<HasElement>> duplicateCheck = new HashSet<Class<HasElement>>();
        duplicateCheck.add(routeTargetType);
        for (Class<? extends RouterLayout> parentType : routeLayoutTypes) {
            if (duplicateCheck.add(parentType)) continue;
            throw new IllegalArgumentException(parentType + " is used in multiple locations");
        }
    }

    private static void updatePageTitle(NavigationEvent navigationEvent, Component routeTarget) {
        String title = routeTarget instanceof HasDynamicTitle ? ((HasDynamicTitle)((Object)routeTarget)).getPageTitle() : AbstractNavigationStateRenderer.lookForTitleInTarget(routeTarget).map(PageTitle::value).orElse("");
        navigationEvent.getUI().getPage().setTitle(title);
    }

    private static Optional<PageTitle> lookForTitleInTarget(Component routeTarget) {
        return Optional.ofNullable(routeTarget.getClass().getAnnotation(PageTitle.class));
    }

    private static boolean isPreserveOnRefreshTarget(Class<? extends Component> routeTargetType, List<Class<? extends RouterLayout>> routeLayoutTypes) {
        return routeTargetType.isAnnotationPresent(PreserveOnRefresh.class) || routeLayoutTypes.stream().anyMatch(layoutType -> layoutType.isAnnotationPresent(PreserveOnRefresh.class));
    }

    private void moveElementsToNewUI(UI prevUi, UI newUi) {
        List<Element> uiChildren = prevUi.getElement().getChildren().collect(Collectors.toList());
        uiChildren.forEach(element -> {
            element.removeFromTree();
            newUi.getElement().appendChild((Element)element);
        });
    }

    static boolean hasPreservedChain(VaadinSession session) {
        PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
        return cache != null && !cache.isEmpty();
    }

    static boolean hasPreservedChainOfLocation(VaadinSession session, Location location) {
        PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
        return cache != null && cache.values().stream().anyMatch(entry -> ((String)entry.getFirst()).equals(location.getPath()));
    }

    static Optional<ArrayList<HasElement>> getPreservedChain(VaadinSession session, String windowName, Location location) {
        PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
        if (cache != null && cache.containsKey(windowName) && ((String)((Pair)cache.get(windowName)).getFirst()).equals(location.getPath())) {
            return Optional.of(((Pair)cache.get(windowName)).getSecond());
        }
        return Optional.empty();
    }

    static void setPreservedChain(VaadinSession session, String windowName, Location location, ArrayList<HasElement> chain) {
        PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
        if (cache == null) {
            cache = new PreservedComponentCache();
        }
        cache.put(windowName, new Pair<String, ArrayList<HasElement>>(location.getPath(), chain));
        session.setAttribute(PreservedComponentCache.class, cache);
    }

    private static void clearAllPreservedChains(UI ui) {
        VaadinSession session = ui.getSession();
        if (AbstractNavigationStateRenderer.hasPreservedChain(session)) {
            ui.getPage().retrieveExtendedClientDetails(details -> {
                String windowName = ui.getInternals().getExtendedClientDetails().getWindowName();
                PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
                if (cache != null) {
                    cache.remove(windowName);
                }
            });
        }
    }

    private static class PreservedComponentCache
    extends HashMap<String, Pair<String, ArrayList<HasElement>>> {
        private PreservedComponentCache() {
        }
    }

    private static enum TransitionOutcome {
        FORWARDED,
        FINISHED,
        REROUTED,
        POSTPONED;

    }
}

