/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.FallibleCommand;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependencies;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeUpdater
implements FallibleCommand {
    static final String GENERATED_PREFIX = "GENERATED/";
    static final String DEPENDENCIES = "dependencies";
    private static final String DEV_DEPENDENCIES = "devDependencies";
    private static final String DEP_LICENSE_KEY = "license";
    private static final String DEP_LICENSE_DEFAULT = "UNLICENSED";
    private static final String DEP_NAME_KEY = "name";
    private static final String DEP_NAME_DEFAULT = "no-name";
    private static final String DEP_NAME_FLOW_DEPS = "@vaadin/flow-deps";
    private static final String DEP_VERSION_KEY = "version";
    private static final String DEP_VERSION_DEFAULT = "1.0.0";
    protected final File npmFolder;
    protected final File nodeModulesFolder;
    protected final File generatedFolder;
    protected final FrontendDependencies frontDeps;
    private final ClassFinder finder;
    boolean modified;

    protected NodeUpdater(ClassFinder finder, FrontendDependencies frontendDependencies, File npmFolder, File generatedPath) {
        this.frontDeps = finder != null && frontendDependencies == null ? new FrontendDependencies(finder) : frontendDependencies;
        this.finder = finder;
        this.npmFolder = npmFolder;
        this.nodeModulesFolder = new File(npmFolder, "node_modules/");
        this.generatedFolder = generatedPath;
    }

    Set<String> getGeneratedModules(File directory, Set<String> excludes) {
        if (!directory.exists()) {
            return Collections.emptySet();
        }
        Function<String, String> unixPath = str -> str.replace("\\", "/");
        URI baseDir = directory.toURI();
        return FileUtils.listFiles((File)directory, (String[])new String[]{"js"}, (boolean)true).stream().filter(file -> {
            String path = (String)unixPath.apply(file.getPath());
            if (path.contains("/node_modules/")) {
                return false;
            }
            return excludes.stream().noneMatch(postfix -> path.endsWith((String)unixPath.apply((String)postfix)));
        }).map(file -> GENERATED_PREFIX + (String)unixPath.apply(baseDir.relativize(file.toURI()).getPath())).collect(Collectors.toSet());
    }

    List<String> resolveModules(Collection<String> modules, boolean isJsModule) {
        return modules.stream().map(module -> this.resolveResource((String)module, isJsModule)).collect(Collectors.toList());
    }

    protected String resolveResource(String importPath, boolean isJsModule) {
        String resolved = importPath;
        if (!importPath.startsWith("@")) {
            String resource;
            if (importPath.startsWith("frontend://")) {
                resolved = importPath.replaceFirst("frontend://", "./");
                if (isJsModule) {
                    this.log().warn("Do not use the '{}' protocol in '@JsModule', changing '{}' to '{}', please update your component.", new Object[]{"frontend://", importPath, resolved});
                }
            }
            if (this.hasMetaInfResource(resource = resolved.replaceFirst("^\\./+", ""))) {
                if (!resolved.startsWith("./")) {
                    this.log().warn("Use the './' prefix for files in JAR files: '{}', please update your component.", (Object)importPath);
                }
                resolved = "@vaadin/flow-frontend/" + resource;
            }
        }
        return resolved;
    }

    private boolean hasMetaInfResource(String resource) {
        return this.finder.getResource("META-INF/frontend/" + resource) != null || this.finder.getResource("META-INF/resources/frontend/" + resource) != null;
    }

    JsonObject getMainPackageJson() throws IOException {
        return this.getPackageJson(new File(this.npmFolder, "package.json"));
    }

    JsonObject getAppPackageJson() throws IOException {
        return this.getPackageJson(new File(this.generatedFolder, "package.json"));
    }

    JsonObject getPackageJson(File packageFile) throws IOException {
        JsonObject packageJson = null;
        if (packageFile.exists()) {
            String fileContent = FileUtils.readFileToString((File)packageFile, (String)StandardCharsets.UTF_8.name());
            packageJson = Json.parse((String)fileContent);
        }
        return packageJson;
    }

    boolean updateMainDefaultDependencies(JsonObject packageJson) {
        boolean added = false;
        added = this.addDependency(packageJson, null, DEP_NAME_KEY, DEP_NAME_DEFAULT) || added;
        added = this.addDependency(packageJson, null, DEP_LICENSE_KEY, DEP_LICENSE_DEFAULT) || added;
        added = this.addDependency(packageJson, DEPENDENCIES, "@polymer/polymer", "3.2.0") || added;
        added = this.addDependency(packageJson, DEPENDENCIES, "@webcomponents/webcomponentsjs", "^2.2.10") || added;
        try {
            String customPkg = "./" + this.npmFolder.getAbsoluteFile().toPath().relativize(this.generatedFolder.getAbsoluteFile().toPath()).toString();
            added = this.addDependency(packageJson, DEPENDENCIES, DEP_NAME_FLOW_DEPS, customPkg.replaceAll("\\\\", "/")) || added;
        }
        catch (IllegalArgumentException iae) {
            this.log().error("Exception in relativization of '%s' to '%s'", (Object)this.npmFolder.getAbsoluteFile().toPath(), (Object)this.generatedFolder.getAbsoluteFile().toPath());
            throw iae;
        }
        added = this.addDependency(packageJson, DEV_DEPENDENCIES, "webpack", "4.30.0") || added;
        added = this.addDependency(packageJson, DEV_DEPENDENCIES, "webpack-cli", "3.3.0") || added;
        added = this.addDependency(packageJson, DEV_DEPENDENCIES, "webpack-dev-server", "3.3.0") || added;
        added = this.addDependency(packageJson, DEV_DEPENDENCIES, "webpack-babel-multi-target-plugin", "2.1.0") || added;
        added = this.addDependency(packageJson, DEV_DEPENDENCIES, "copy-webpack-plugin", "5.0.3") || added;
        added = this.addDependency(packageJson, DEV_DEPENDENCIES, "webpack-merge", "4.2.1") || added;
        added = this.addDependency(packageJson, DEV_DEPENDENCIES, "raw-loader", "3.0.0") || added;
        return added;
    }

    void updateAppDefaultDependencies(JsonObject packageJson) {
        this.addDependency(packageJson, null, DEP_NAME_KEY, DEP_NAME_FLOW_DEPS);
        this.addDependency(packageJson, null, DEP_VERSION_KEY, DEP_VERSION_DEFAULT);
        this.addDependency(packageJson, null, DEP_LICENSE_KEY, DEP_LICENSE_DEFAULT);
    }

    boolean addDependency(JsonObject json, String key, String pkg, String vers) {
        if (key != null) {
            if (!json.hasKey(key)) {
                json.put(key, (JsonValue)Json.createObject());
            }
            json = (JsonObject)json.get(key);
        }
        if (!json.hasKey(pkg) || !json.getString(pkg).equals(vers)) {
            json.put(pkg, vers);
            this.log().info("Added \"{}\": \"{}\" line.", (Object)pkg, (Object)vers);
            return true;
        }
        return false;
    }

    void writeMainPackageFile(JsonObject packageJson) throws IOException {
        this.writePackageFile(packageJson, new File(this.npmFolder, "package.json"));
    }

    void writeAppPackageFile(JsonObject packageJson) throws IOException {
        this.writePackageFile(packageJson, new File(this.generatedFolder, "package.json"));
    }

    void writePackageFile(JsonObject json, File packageFile) throws IOException {
        this.log().info("Updated npm {}.", (Object)packageFile.getAbsolutePath());
        FileUtils.forceMkdirParent((File)packageFile);
        FileUtils.writeStringToFile((File)packageFile, (String)(JsonUtil.stringify((JsonValue)json, (int)2) + "\n"), (String)StandardCharsets.UTF_8.name());
    }

    Logger log() {
        return LoggerFactory.getLogger((String)"dev-updater");
    }
}

