/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.DevModeHandler;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.frontend.ClassFinder;
import com.vaadin.flow.server.frontend.NodeTasks;
import com.vaadin.flow.server.startup.ServletDeployer;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HandlesTypes(value={Route.class, NpmPackage.class, WebComponentExporter.class})
public class DevModeInitializer
implements ServletContainerInitializer,
Serializable {
    public void onStartup(Set<Class<?>> classes, ServletContext context) throws ServletException {
        Collection registrations = context.getServletRegistrations().values();
        if (registrations.isEmpty()) {
            return;
        }
        DeploymentConfiguration config = ServletDeployer.StubServletConfig.createDeploymentConfiguration(context, (ServletRegistration)registrations.iterator().next(), VaadinServlet.class);
        DevModeInitializer.initDevModeHandler(classes, context, config);
    }

    public static void initDevModeHandler(Set<Class<?>> classes, ServletContext context, DeploymentConfiguration config) {
        if (config.isProductionMode()) {
            DevModeInitializer.log().debug("Skipping DEV MODE because PRODUCTION MODE is set.");
            return;
        }
        if (config.isCompatibilityMode()) {
            DevModeInitializer.log().debug("Skipping DEV MODE because BOWER MODE is set.");
            return;
        }
        if (!config.enableDevServer()) {
            DevModeInitializer.log().debug("Skipping DEV MODE because dev server shouldn't be enabled.");
            return;
        }
        String baseDir = config.getStringProperty("project.basedir", System.getProperty("user.dir", "."));
        NodeTasks.Builder builder = new NodeTasks.Builder(new ClassFinder.DefaultClassFinder(classes), new File(baseDir));
        DevModeInitializer.log().info("Starting dev-mode updaters in {} folder.", (Object)builder.npmFolder);
        for (File file : Arrays.asList(new File(builder.npmFolder, "package.json"), new File(builder.generatedFolder, "package.json"), new File(builder.npmFolder, "webpack.config.js"), builder.generatedFolder)) {
            if (file.canRead()) continue;
            DevModeInitializer.log().warn("Skipping DEV MODE because cannot read '{}' file.", (Object)file.getPath());
            return;
        }
        HashSet<String> visitedClassNames = new HashSet<String>();
        builder.enablePackagesUpdate(true).enableImportsUpdate(true).runNpmInstall(true).withEmbeddableWebComponents(true).collectVisitedClasses(visitedClassNames).build().execute();
        VaadinServletContext vaadinContext = new VaadinServletContext(context);
        vaadinContext.setAttribute(new VisitedClasses(visitedClassNames));
        DevModeHandler.start(vaadinContext, config, builder.npmFolder);
    }

    private static Logger log() {
        return LoggerFactory.getLogger(DevModeInitializer.class);
    }

    public static class VisitedClasses
    implements Serializable {
        private Set<String> visitedClassNames;

        public VisitedClasses(Set<String> visitedClassNames) {
            assert (visitedClassNames != null);
            this.visitedClassNames = visitedClassNames;
        }

        public boolean allDependenciesVisited(Class<?> dependencyClass) {
            if (this.visitedClassNames.contains(dependencyClass.getName())) {
                return true;
            }
            if (((JsModule[])dependencyClass.getDeclaredAnnotationsByType(JsModule.class)).length != 0) {
                return false;
            }
            Class<?> superclass = dependencyClass.getSuperclass();
            if (superclass == null) {
                return true;
            }
            return this.allDependenciesVisited(superclass);
        }
    }
}

