/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.ClassFinder;
import com.vaadin.flow.server.frontend.FrontendClassVisitor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassVisitor;

class FrontendAnnotatedClassVisitor
extends ClassVisitor {
    private final String annotationName;
    private final List<HashMap<String, Object>> data = new ArrayList<HashMap<String, Object>>();
    private final ClassFinder finder;

    FrontendAnnotatedClassVisitor(ClassFinder finder, String annotationName) {
        super(458752);
        this.finder = finder;
        this.annotationName = annotationName;
    }

    public void visitClass(String name) {
        if (name == null) {
            return;
        }
        try {
            URL url = this.finder.getResource(name.replace(".", "/") + ".class");
            ClassReader cr = new ClassReader(url.openStream());
            cr.accept((ClassVisitor)this, 0);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.visitClass(superName);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        String cname = descriptor.replace("/", ".");
        if (cname.contains(this.annotationName)) {
            return new FrontendClassVisitor.RepeatedAnnotationVisitor(){
                HashMap<String, Object> info = new HashMap();

                public void visit(String name, Object value) {
                    if (FrontendAnnotatedClassVisitor.this.data.indexOf(this.info) < 0) {
                        FrontendAnnotatedClassVisitor.this.data.add(this.info);
                    }
                    this.info.put(name, value);
                }

                @Override
                public AnnotationVisitor visitAnnotation(String name, String descriptor) {
                    this.info = new HashMap();
                    return this;
                }
            };
        }
        return null;
    }

    public <T> Set<T> getValues(String parameter) {
        return this.data.stream().filter(h -> h.containsKey(parameter)).map(h -> h.get(parameter)).collect(Collectors.toSet());
    }

    public <T> Set<T> getValuesForKey(String key, String value, String property) {
        return this.data.stream().filter(h -> h.containsKey(key) && h.get(key).equals(value)).map(h -> h.get(property)).collect(Collectors.toSet());
    }
}

