/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.polymertemplate.EventHandler;
import com.vaadin.flow.component.polymertemplate.ModelItem;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.component.polymertemplate.RepeatIndex;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.AbstractServerHandlers;
import com.vaadin.flow.internal.nodefeature.PolymerEventListenerMap;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

public class PolymerServerEventHandlers
extends AbstractServerHandlers<PolymerTemplate<?>> {
    private static final String REPEAT_INDEX_VALUE = "event.model.index";

    public PolymerServerEventHandlers(StateNode node) {
        super(node);
    }

    @Override
    protected void addHandlerMethod(Method method, Collection<Method> methods) {
        super.addHandlerMethod(method, methods);
        this.addMethodParameters(method);
    }

    @Override
    protected void ensureSupportedParameterTypes(Method method) {
        Stream.of(method.getParameters()).forEach(parameter -> this.checkParameterTypeAndAnnotation(method, (Parameter)parameter));
    }

    @Override
    protected Class<? extends EventHandler> getHandlerAnnotation() {
        return EventHandler.class;
    }

    @Override
    protected DisabledUpdateMode getUpdateMode(Method method) {
        return method.getAnnotation(this.getHandlerAnnotation()).value();
    }

    private void checkParameterTypeAndAnnotation(Method method, Parameter parameter) {
        Class<?> parameterType;
        boolean hasRepeatIndexAnnotation;
        boolean hasEventDataAnnotation = parameter.isAnnotationPresent(EventData.class) || parameter.isAnnotationPresent(ModelItem.class);
        if (!Boolean.logicalXor(hasEventDataAnnotation, hasRepeatIndexAnnotation = parameter.isAnnotationPresent(RepeatIndex.class))) {
            throw new IllegalStateException(String.format("EventHandler method '%s' should have the parameter with index %s annotated either with @EventData annotation (to get any particular data from the event) or have 'int' or 'Integer' type and be annotated with @RepeatIndex annotation (to get element index in dom-repeat)", method.getName(), PolymerServerEventHandlers.getParameterIndex(parameter)));
        }
        if (!(hasEventDataAnnotation || (parameterType = parameter.getType()).equals(Integer.TYPE) || parameterType.equals(Integer.class))) {
            throw new IllegalStateException(String.format("EventHandler method '%s' has parameter with index %s, annotated with @RepeatIndex that has incorrect type '%s', should be 'int' or 'Integer'", method.getName(), PolymerServerEventHandlers.getParameterIndex(parameter), parameterType));
        }
    }

    private static String getParameterIndex(Parameter parameter) {
        return parameter.getName().replace("arg", "");
    }

    private void addMethodParameters(Method method) {
        this.getNode().getFeature(PolymerEventListenerMap.class).add(method.getName(), this.getParameters(method));
    }

    private String[] getParameters(Method method) {
        return (String[])Stream.of(method.getParameters()).flatMap(parameter -> Stream.of(Optional.ofNullable(parameter.getAnnotation(EventData.class)).map(EventData::value), Optional.ofNullable(parameter.getAnnotation(RepeatIndex.class)).map(annotation -> REPEAT_INDEX_VALUE), Optional.ofNullable(parameter.getAnnotation(ModelItem.class)).map(ModelItem::value))).filter(Optional::isPresent).map(Optional::get).toArray(String[]::new);
    }
}

