/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.server.PwaIcon;
import com.vaadin.flow.server.PwaRegistry;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PwaHandler
implements RequestHandler {
    private final Map<String, RequestHandler> requestHandlerMap = new HashMap<String, RequestHandler>();
    private final PwaRegistry pwaRegistry;

    public PwaHandler(PwaRegistry pwaRegistry) {
        this.pwaRegistry = pwaRegistry;
        this.init();
    }

    private void init() {
        if (!this.pwaRegistry.getPwaConfiguration().isEnabled()) {
            return;
        }
        for (PwaIcon icon : this.pwaRegistry.getIcons()) {
            this.requestHandlerMap.put(icon.getRelHref(), (session, request, response) -> {
                response.setContentType(icon.getType());
                if (icon.shouldBeCached()) {
                    response.setHeader("Cache-Control", "no-cache, must-revalidate");
                }
                try (OutputStream out = response.getOutputStream();){
                    icon.write(out);
                }
                return true;
            });
        }
        this.requestHandlerMap.put(this.pwaRegistry.getPwaConfiguration().relOfflinePath(), (session, request, response) -> {
            response.setContentType("text/html");
            try (PrintWriter writer = response.getWriter();){
                writer.write(this.pwaRegistry.getOfflineHtml());
            }
            return true;
        });
        this.requestHandlerMap.put(this.pwaRegistry.getPwaConfiguration().relManifestPath(), (session, request, response) -> {
            response.setContentType("application/manifest+json");
            try (PrintWriter writer = response.getWriter();){
                writer.write(this.pwaRegistry.getManifestJson());
            }
            return true;
        });
        this.requestHandlerMap.put(this.pwaRegistry.getPwaConfiguration().relServiceWorkerPath(), (session, request, response) -> {
            response.setContentType("application/javascript");
            try (PrintWriter writer = response.getWriter();){
                writer.write(this.pwaRegistry.getServiceWorkerJs());
            }
            return true;
        });
    }

    @Override
    public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        String requestUri = request.getPathInfo();
        if (this.pwaRegistry.getPwaConfiguration().isEnabled()) {
            if (this.requestHandlerMap.containsKey(requestUri)) {
                return this.requestHandlerMap.get(requestUri).handleRequest(session, request, response);
            }
            if (requestUri.startsWith("/VAADIN/static/server/workbox/")) {
                String resourceName = "VAADIN/static/server/workbox/" + requestUri.substring("VAADIN/static/server/workbox/".length() + 1).replaceAll("/", "");
                return this.handleWorkboxResource(resourceName, response);
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean handleWorkboxResource(String fileName, VaadinResponse response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(PwaHandler.class);
    }
}

