/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.NodeVisitor;
import com.vaadin.flow.dom.ShadowRoot;
import com.vaadin.flow.i18n.LocaleChangeEvent;
import com.vaadin.flow.i18n.LocaleChangeObserver;
import com.vaadin.flow.router.AfterNavigationObserver;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.BeforeLeaveObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class EventUtil {
    private EventUtil() {
    }

    public static List<BeforeEnterObserver> collectBeforeEnterObservers(Collection<? extends HasElement> oldChain, Collection<? extends HasElement> newChain) {
        Set chainRootElements = Stream.concat(oldChain.stream(), newChain.stream()).map(HasElement::getElement).collect(Collectors.toSet());
        return newChain.stream().flatMap(chainRoot -> {
            Element chainRootElement = chainRoot.getElement();
            Predicate<Element> currentRootAndNonRoots = element -> element.equals(chainRootElement) || !chainRootElements.contains(element);
            return EventUtil.getImplementingComponents(EventUtil.flattenDescendants(chainRootElement, currentRootAndNonRoots), BeforeEnterObserver.class);
        }).collect(Collectors.toList());
    }

    public static List<BeforeLeaveObserver> collectBeforeLeaveObservers(UI ui) {
        return EventUtil.getImplementingComponents(EventUtil.flattenDescendants(ui.getElement()), BeforeLeaveObserver.class).collect(Collectors.toList());
    }

    public static List<AfterNavigationObserver> collectAfterNavigationObservers(UI ui) {
        return EventUtil.getImplementingComponents(EventUtil.flattenDescendants(ui.getElement()), AfterNavigationObserver.class).collect(Collectors.toList());
    }

    public static List<LocaleChangeObserver> collectLocaleChangeObservers(Element element) {
        return EventUtil.getImplementingComponents(EventUtil.flattenDescendants(element), LocaleChangeObserver.class).collect(Collectors.toList());
    }

    public static List<LocaleChangeObserver> collectLocaleChangeObservers(List<HasElement> components) {
        Stream<Element> elements = components.stream().flatMap(component -> EventUtil.flattenDescendants(component.getElement()));
        return EventUtil.getImplementingComponents(elements, LocaleChangeObserver.class).collect(Collectors.toList());
    }

    public static void informLocaleChangeObservers(UI ui) {
        LocaleChangeEvent localeChangeEvent = new LocaleChangeEvent(ui, ui.getLocale());
        EventUtil.collectLocaleChangeObservers(ui.getElement()).forEach(observer -> observer.localeChange(localeChangeEvent));
    }

    public static void informLocaleChangeObservers(UI ui, List<HasElement> components) {
        LocaleChangeEvent localeChangeEvent = new LocaleChangeEvent(ui, ui.getLocale());
        EventUtil.collectLocaleChangeObservers(components).forEach(observer -> observer.localeChange(localeChangeEvent));
    }

    public static <T> Stream<T> getImplementingComponents(Stream<Element> elementStream, Class<T> type) {
        return elementStream.flatMap(o -> o.getComponent().map(Stream::of).orElseGet(Stream::empty)).filter(component -> type.isAssignableFrom(component.getClass())).map(component -> component);
    }

    public static void inspectHierarchy(Element node, Collection<Element> descendants, Predicate<Element> filter) {
        node.accept(new DescendantsVisitor(descendants, filter));
    }

    private static Stream<Element> flattenDescendants(Element element) {
        return EventUtil.flattenDescendants(element, item -> true);
    }

    private static Stream<Element> flattenDescendants(Element element, Predicate<Element> recursionPredicate) {
        ArrayList<Element> descendants = new ArrayList<Element>();
        EventUtil.inspectHierarchy(element, descendants, recursionPredicate);
        return descendants.stream();
    }

    private static class DescendantsVisitor
    implements NodeVisitor {
        private final Collection<Element> collector;
        private Predicate<Element> filter;

        DescendantsVisitor(Collection<Element> collector, Predicate<Element> filter) {
            this.collector = collector;
            this.filter = filter;
        }

        @Override
        public boolean visit(NodeVisitor.ElementType type, Element element) {
            boolean include = this.filter.test(element);
            if (include) {
                this.collector.add(element);
            }
            return include;
        }

        @Override
        public boolean visit(ShadowRoot root) {
            return true;
        }
    }
}

