/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutEventListener;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.Command;
import java.security.InvalidParameterException;

public final class Shortcuts {
    static final String NULL = "Parameter '%s' must not be null!";

    private Shortcuts() {
    }

    public static ShortcutRegistration addShortcutListener(Component lifecycleOwner, Command command, Key key, KeyModifier ... keyModifiers) {
        if (lifecycleOwner == null) {
            throw new InvalidParameterException(String.format(NULL, "lifecycleOwner"));
        }
        if (command == null) {
            throw new InvalidParameterException(String.format(NULL, "command"));
        }
        if (key == null) {
            throw new InvalidParameterException(String.format(NULL, "key"));
        }
        return new ShortcutRegistration(lifecycleOwner, UI::getCurrent, event -> command.execute(), key).withModifiers(keyModifiers);
    }

    public ShortcutRegistration addShortcutListener(Component lifecycleOwner, ShortcutEventListener listener, Key key, KeyModifier ... keyModifiers) {
        if (lifecycleOwner == null) {
            throw new InvalidParameterException(String.format(NULL, "lifecycleOwner"));
        }
        if (listener == null) {
            throw new InvalidParameterException(String.format(NULL, "listener"));
        }
        if (key == null) {
            throw new InvalidParameterException(String.format(NULL, "key"));
        }
        return new ShortcutRegistration(lifecycleOwner, UI::getCurrent, listener, key).withModifiers(keyModifiers);
    }
}

