/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.RouteBaseData;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RoutesChangedEvent;
import com.vaadin.flow.router.RoutesChangedListener;
import com.vaadin.flow.router.internal.AbstractRouteRegistry;
import com.vaadin.flow.router.internal.ConfiguredRoutes;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SessionRouteRegistry
extends AbstractRouteRegistry {
    private RouteRegistry parentRegistry;
    private final VaadinSession session;

    SessionRouteRegistry(VaadinSession session, VaadinService service) {
        this.session = session;
        if (service != null) {
            this.parentRegistry = service.getRouteRegistry();
        }
    }

    public static RouteRegistry getSessionRegistry(VaadinSession session) {
        Objects.requireNonNull(session, "Null session is not supported for session route registry");
        SessionRouteRegistry registry = session.getAttribute(SessionRouteRegistry.class);
        if (registry == null) {
            registry = new SessionRouteRegistry(session, session.getService());
            session.setAttribute(SessionRouteRegistry.class, registry);
        }
        if (!registry.session.equals(session)) {
            throw new IllegalStateException("Session has as the attribute a route registered to another session");
        }
        return registry;
    }

    @Override
    public List<RouteData> getRegisteredRoutes() {
        ArrayList<RouteData> routes = new ArrayList<RouteData>(super.getRegisteredRoutes());
        List<RouteData> registeredRoutes = this.parentRegistry.getRegisteredRoutes();
        if (!registeredRoutes.isEmpty()) {
            Set collect = routes.stream().map(RouteBaseData::getUrl).collect(Collectors.toSet());
            registeredRoutes.stream().filter(data -> !collect.contains(data.getUrl())).forEach(routes::add);
        }
        return routes;
    }

    @Override
    public Registration addRoutesChangeListener(RoutesChangedListener listener) {
        Registration parentRegistration = this.parentRegistry.addRoutesChangeListener(event -> {
            ConfiguredRoutes configuration = this.getConfiguration();
            List<RouteBaseData<?>> addedVisible = event.getAddedRoutes().stream().filter(routeData -> !configuration.hasRoute(routeData.getUrl())).collect(Collectors.toList());
            List<RouteBaseData<?>> removedVisible = event.getRemovedRoutes().stream().filter(routeData -> !configuration.hasRoute(routeData.getUrl())).collect(Collectors.toList());
            if (!addedVisible.isEmpty() || !removedVisible.isEmpty()) {
                this.fireEvent(new RoutesChangedEvent(event.getSource(), addedVisible, removedVisible));
            }
        });
        Registration registration = super.addRoutesChangeListener(listener);
        return () -> {
            registration.remove();
            parentRegistration.remove();
        };
    }

    @Override
    public Optional<Class<? extends Component>> getNavigationTarget(String pathString) {
        Objects.requireNonNull(pathString, "pathString must not be null.");
        Optional<Class<? extends Component>> navigationTarget = this.getNavigationTarget(pathString, Collections.emptyList());
        if (navigationTarget.isPresent()) {
            return navigationTarget;
        }
        return this.parentRegistry.getNavigationTarget(pathString);
    }

    @Override
    public Optional<Class<? extends Component>> getNavigationTarget(String pathString, List<String> segments) {
        Objects.requireNonNull(pathString, "pathString must not be null.");
        if (this.getConfiguration().hasRoute(pathString, segments)) {
            return this.getConfiguration().getRoute(pathString, segments);
        }
        return this.parentRegistry.getNavigationTarget(pathString, segments);
    }

    @Override
    public Optional<String> getTargetUrl(Class<? extends Component> navigationTarget) {
        Optional<String> targetUrl = super.getTargetUrl(navigationTarget);
        if (targetUrl.isPresent()) {
            return targetUrl;
        }
        return this.parentRegistry.getTargetUrl(navigationTarget);
    }

    @Override
    public List<Class<? extends RouterLayout>> getRouteLayouts(String path, Class<? extends Component> navigationTarget) {
        if (this.getConfiguration().hasRoute(path)) {
            return super.getRouteLayouts(path, navigationTarget);
        }
        return this.parentRegistry.getRouteLayouts(path, navigationTarget);
    }
}

